/*
 * 	BNE Block Progress Bar
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	April 9, 2020
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var ColorPalette = wp.blockEditor.ColorPalette;
	var PanelBody = wp.components.PanelBody;
	var TextControl = wp.components.TextControl;
	var RangeControl = wp.components.RangeControl;
	var ToggleControl = wp.components.ToggleControl;
	
	//console.log(wp.editor);
	
	// Icons
	var blockIcon = 
		el( 'svg', { className: 'components-bne-svg', width: '24', height: '24', 'viewbox': '0 0 24 24', x:"0px", y:"0px", fill: 'none', xmlns: 'http://www.w3.org/2000/svg' },
			el( 'path', { d: "M3.81901 14.8365L3.47852 15.5048L3.81901 14.8365ZM3.16349 14.181L2.49524 14.5215L3.16349 14.181ZM20.8365 14.181L21.5048 14.5215L20.8365 14.181ZM20.181 14.8365L20.5215 15.5048L20.181 14.8365ZM20.181 9.16349L20.5215 8.49524L20.181 9.16349ZM20.8365 9.81901L21.5048 9.47852L20.8365 9.81901ZM3.81901 9.16349L3.47852 8.49524L3.81901 9.16349ZM3.16349 9.81901L2.49524 9.47852L3.16349 9.81901ZM5.4 9.75H18.6V8.25H5.4V9.75ZM20.25 11.4V12.6H21.75V11.4H20.25ZM18.6 14.25H5.4V15.75H18.6V14.25ZM3.75 12.6V11.4H2.25V12.6H3.75ZM5.4 14.25C4.96758 14.25 4.68838 14.2494 4.47588 14.2321C4.27213 14.2154 4.19659 14.1871 4.15951 14.1683L3.47852 15.5048C3.76231 15.6494 4.05722 15.7028 4.35373 15.7271C4.64148 15.7506 4.99234 15.75 5.4 15.75V14.25ZM2.25 12.6C2.25 13.0077 2.24942 13.3585 2.27293 13.6463C2.29715 13.9428 2.35064 14.2377 2.49524 14.5215L3.83175 13.8405C3.81285 13.8034 3.78459 13.7279 3.76795 13.5241C3.75058 13.3116 3.75 13.0324 3.75 12.6H2.25ZM4.15951 14.1683C4.01839 14.0963 3.90365 13.9816 3.83175 13.8405L2.49524 14.5215C2.71095 14.9448 3.05516 15.289 3.47852 15.5048L4.15951 14.1683ZM20.25 12.6C20.25 13.0324 20.2494 13.3116 20.2321 13.5241C20.2154 13.7279 20.1871 13.8034 20.1683 13.8405L21.5048 14.5215C21.6494 14.2377 21.7028 13.9428 21.7271 13.6463C21.7506 13.3585 21.75 13.0077 21.75 12.6H20.25ZM18.6 15.75C19.0077 15.75 19.3585 15.7506 19.6463 15.7271C19.9428 15.7028 20.2377 15.6494 20.5215 15.5048L19.8405 14.1683C19.8034 14.1871 19.7279 14.2154 19.5241 14.2321C19.3116 14.2494 19.0324 14.25 18.6 14.25V15.75ZM20.1683 13.8405C20.0963 13.9816 19.9816 14.0964 19.8405 14.1683L20.5215 15.5048C20.9448 15.289 21.289 14.9448 21.5048 14.5215L20.1683 13.8405ZM18.6 9.75C19.0324 9.75 19.3116 9.75058 19.5241 9.76795C19.7279 9.78459 19.8034 9.81285 19.8405 9.83175L20.5215 8.49524C20.2377 8.35064 19.9428 8.29715 19.6463 8.27293C19.3585 8.24942 19.0077 8.25 18.6 8.25V9.75ZM21.75 11.4C21.75 10.9923 21.7506 10.6415 21.7271 10.3537C21.7028 10.0572 21.6494 9.76231 21.5048 9.47852L20.1683 10.1595C20.1871 10.1966 20.2154 10.2721 20.2321 10.4759C20.2494 10.6884 20.25 10.9676 20.25 11.4H21.75ZM19.8405 9.83175C19.9816 9.90365 20.0963 10.0184 20.1683 10.1595L21.5048 9.47852C21.289 9.05516 20.9448 8.71095 20.5215 8.49524L19.8405 9.83175ZM5.4 8.25C4.99234 8.25 4.64148 8.24942 4.35373 8.27293C4.05722 8.29715 3.76231 8.35064 3.47852 8.49524L4.15951 9.83175C4.19659 9.81285 4.27213 9.78459 4.47588 9.76795C4.68838 9.75058 4.96759 9.75 5.4 9.75V8.25ZM3.75 11.4C3.75 10.9676 3.75058 10.6884 3.76795 10.4759C3.78459 10.2721 3.81285 10.1966 3.83175 10.1595L2.49524 9.47852C2.35064 9.76231 2.29715 10.0572 2.27293 10.3537C2.24942 10.6415 2.25 10.9923 2.25 11.4H3.75ZM3.47852 8.49524C3.05516 8.71095 2.71095 9.05516 2.49524 9.47852L3.83175 10.1595C3.90365 10.0184 4.01839 9.90365 4.15951 9.83175L3.47852 8.49524ZM14.75 9V15H16.25V9H14.75Z" } )
		)	
	;

	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/progress-bar', {
		title: __( 'Progress Bar', 'bne' ),
		description: __( 'Show the progress of your work, skills or earnings.', 'bne' ),
		icon: blockIcon,
		category: 'bne-blocks',
		attributes: {
			label: {
				type: 'string'
			},
			height: {
				type: 'number',
				default: 25
			},
			percent: {
				type: 'number',
				default: 60
			},
			displayPercent: {
				type: 'booleon',
				default: 1
			},
			color: {
				type: 'string',
				default: '#007bff',
			},
			striped: {
				type: 'booleon',
				default: 0
			},
			animate: {
				type: 'booleon',
				default: 0
			},
			
		},
		
		
		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			var blockClasses =
				( ( attributes.height < 10 ) ? ' has-percent-outside' : '')
				+ ( attributes.displayPercent ? ' has-percent-label' : '' )
				+ ( attributes.label ? ' has-progress-bar-label' : '' )
			;
						
  			return [

				// Panel Controls
				el( InspectorControls, {},

 					// General Panel
 					el( PanelBody, {
							title: __( 'Progress Bar Settings', 'bne' ),
							initialOpen: true,
						},
		                el( TextControl, {
								label: __( 'Label', 'bne' ),
								value: attributes.label,
								onChange: function( newLabel ) {
									props.setAttributes( { label: newLabel } );
								}
			                } 
			            ),
						el( RangeControl, {
								label: __( 'Height', 'bne' ),
								value: attributes.height,
								onChange: function( newHeight ) {
									props.setAttributes( { height: newHeight } );
								},
								min: 1,
								max: 30,
								step: 1
							}
						),
						el( RangeControl, {
								label: __( 'Percent', 'bne' ),
								value: attributes.percent,
								onChange: function( newPercent ) {
									props.setAttributes( { percent: newPercent } );
								},
								min: 1,
								max: 100,
								step: 1
							}
						),
						el( ToggleControl, {
								label: __( 'Display Percent', 'bne' ),
								checked: !!attributes.displayPercent,
								onChange: function( newDisplayPercent ) {
									props.setAttributes( { displayPercent: newDisplayPercent } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Striped', 'bne' ),
								checked: !!attributes.striped,
								onChange: function( newStriped ) {
									props.setAttributes( { striped: newStriped } );
								}
							} 
						),
						( ( attributes.striped == 1 ) &&
							el( ToggleControl, {
									label: __( 'Animate', 'bne' ),
									checked: !!attributes.animate,
									onChange: function( newAnimate ) {
										props.setAttributes( { animate: newAnimate } );
									}
								} 
							)
						),
						el('p', {}, __( 'Color', 'bne' ) ),
						el( ColorPalette, {
								value: attributes.color,
								onChange: function( newColor ) {
									props.setAttributes( { color: newColor } );
								},
							},
						)
					) // PanelBody
				), // InspectorControls


				// Editor
				// ========================== //
				el( 'div', {
						className: props.className + ' bne-progress'+ blockClasses, 
						style: {} 
					},
					attributes.label &&
						el( 'span', {
								className: 'progress-label'
							},
							attributes.label
						),
						
					el( 'div', {
							className: 'progress',
							style: {
								height: attributes.height+'px',
							}
						},
						el( 'div', {
								className: 'progress-bar' + (attributes.striped ? ' progress-bar-striped' : '') + (attributes.animate ? ' progress-bar-animated' : ''),
								'role': 'progressbar',
								'aria-valuenow': attributes.percent,
								'aria-valuemin': 0,
								'aria-valuemax': 100,
								'data-percent': attributes.percent,
								style: {
									width: attributes.percent+'%',
									backgroundColor: attributes.color
								}
							},
							el( 'span', {
									className: 'sr-only'
								},
								attributes.percent+'%'
							),
							( attributes.displayPercent == 1 ) &&
								el( 'span', {
										className: 'percent'
									},
									attributes.percent+'%'
								),
						),//div.progress-bar
					) //div.progress
				) //div.bne-progress
			]; // END return
		}, // END edit
	
		
		// ========================== //
		// Save
		// ========================== //
		save: function (props) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			var blockClasses =
				( ( attributes.height < 10 ) ? ' has-percent-outside' : '')
				+ ( attributes.displayPercent ? ' has-percent-label' : '' )
				+ ( attributes.label ? ' has-progress-bar-label' : '' )
			;
						
			return (
				el( 'div', {
						className: 'bne-progress'+ blockClasses, 
						style: {}
					},
					attributes.label &&
						el( 'span', {
								className: 'progress-label'
							},
							attributes.label
						),
						
					el( 'div', {
							className: 'progress',
							style: {
								height: attributes.height+'px',
							}
						},
						el( 'div', {
								className: 'progress-bar' + (attributes.striped ? ' progress-bar-striped' : '') + (attributes.animate ? ' progress-bar-animated' : ''),
								'role': 'progressbar',
								'aria-valuenow': attributes.percent,
								'aria-valuemin': 0,
								'aria-valuemax': 100,
								'data-percent': attributes.percent,
								style: {
									width: attributes.percent+'%',
									backgroundColor: attributes.color
								}
							},
							el( 'span', {
									className: 'sr-only'
								},
								attributes.percent+'%'
							),
							( attributes.displayPercent == 1 ) &&
								el( 'span', {
										className: 'percent'
									},
									attributes.percent+'%'
								),
						),//div.progress-bar
					) //div.progress
				) //div.bne-progress
			
			) // End return
		} // End save

	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);