/*
 * 	BNE Block Posts
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	March 3, 2022
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var ServerSideRender = wp.serverSideRender;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var PanelBody = wp.components.PanelBody;
	var TextControl = wp.components.TextControl;
	var SelectControl = wp.components.SelectControl;
	var CheckboxControl = wp.components.CheckboxControl;
	var RangeControl = wp.components.RangeControl;
	var ToggleControl = wp.components.ToggleControl;
	
	//console.log(wp.editor);
	
	
	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/posts', {
		title: __( 'Blog Posts', 'bne' ),
		description: __( 'Your latest blog posts. Use this to showcase a few of your posts in your landing pages.', 'bne' ),
		icon: 'welcome-write-blog',
		category: 'bne-blocks',
		keywords: [ __( 'articles', 'bne' ) ],
		attributes: {
			layout: {
				type: 'string',
				default: 'grid'
			},
			postStyle: {
				type: 'string',
				default: 'default'
			},
			cardShadow: {
				type: 'string',
				default: 'shadow-none'
			},
			columns: {
				type: 'number',
				default: 3
			},
			categorySelected: {
				type: 'string'
			},
			limit: {
				type: 'number',
				default: 6
			},
			thumbnail: {
				type: 'string',
				default: 'full'
			},
			thumbnailStyle: {
				type: 'string',
				default: 'flat'
			},
			showExcerpt: {
				type: 'boolean',
				default: 1				
			},
			showCategory: {
				type: 'boolean',
				default: 1				
			},
			showDate: {
				type: 'boolean',
				default: 1				
			},
			showAuthor: {
				type: 'boolean',
				default: 1				
			},
			showComments: {
				type: 'boolean',
				default: 1				
			},
			showReadmore: {
				type: 'boolean',
				default: 0				
			},
			readmoreText: {
				type: 'string'
			}
		},
		supports: {
			html: false
		},
		
		
		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes);


	  		
  			return [

				// Panel Controls
				el( InspectorControls, {},

 					// General Panel
 					el( PanelBody, {
							title: __( 'Layout', 'bne' ),
							initialOpen: true,
						},
						el( SelectControl, {
								value: attributes.layout,
								label: __('Display'),
								onChange: function( newLayout ) {
									props.setAttributes( { layout: newLayout } );
								},
								options: [
									{ value: 'list', label: __( 'List', 'bne' ) },
									{ value: 'grid', label: __( 'Grid', 'bne' ) },
									{ value: 'portfolio', label: __( 'Portfolio', 'bne' ) }
								],
							} 
						),
						( attributes.layout == 'grid' || attributes.layout == 'portfolio' ) &&
							el( RangeControl, {
									label: __( 'Columns', 'bne' ),
									value: attributes.columns,
									onChange: function( newColumns ) {
										props.setAttributes( { columns: newColumns } );
									},
									min: 1,
									max: 4,
									step: 1
								}
							),
						( attributes.layout == 'grid' ) &&
							el( SelectControl, {
									value: attributes.postStyle,
									label: __('Style'),
									onChange: function( newPostStyle ) {
										props.setAttributes( { postStyle: newPostStyle } );
									},
									options: [
										{ value: 'default', label: __( 'Default (no frame)', 'bne' ) },
										{ value: 'card', label: __( 'Card', 'bne' ) },
									]
								} 
							),
						( attributes.postStyle == 'card' || attributes.layout == 'portfolio' ) &&
							el( SelectControl, {
									value: attributes.cardShadow,
									label: __('Card Shadow'),
									onChange: function( newCardShadow ) {
										props.setAttributes( { cardShadow: newCardShadow } );
									},
									options: [
										{ value: 'shadow-none', label: __( 'No Shadow', 'bne' ) },
										{ value: 'shadow-sm', label: __( 'Small Shadow', 'bne' ) },
										{ value: 'shadow', label: __( 'Medium Shadow', 'bne' ) },
										{ value: 'shadow-lg', label: __( 'Large Shadow', 'bne' ) },
									]
								} 
							)
					),
 					el( PanelBody, {
							title: __( 'Post Settings', 'bne' ),
							initialOpen: true,
						},
						el( SelectControl, {
								value: attributes.categorySelected,
								label: __( 'Category', 'bne' ),
								onChange: function( newCategorySelected ) {
									props.setAttributes( { categorySelected: newCategorySelected } );
								},
								options: bne_blocks_posts_vars.categories
							} 
						),
						el( RangeControl, {
								label: __( 'Number of items', 'bne' ),
								value: attributes.limit,
								onChange: function( newLimit ) {
									props.setAttributes( { limit: newLimit } );
								},
								min: 1,
								max: 100,
								step: 1
							}
						),
						( attributes.layout !== 'portfolio' ) &&
							el( SelectControl, {
									value: attributes.thumbnail,
									label: __('Featured Image'),
									onChange: function( newThumbnail ) {
										props.setAttributes( { thumbnail: newThumbnail } );
									},
									options: [
										{ value: 'mini', label: __( 'Mini (75px)', 'bne' ) },
										{ value: 'thumbnail', label: __( 'Small (Thumbnail Crop)', 'bne' ) },
										{ value: 'medium', label: __( 'Medium (Medium Crop)', 'bne' ) },
										{ value: 'large', label: __( 'Large (Large Crop)', 'bne' ) },
										{ value: 'full', label: __( 'Full', 'bne' ) },
										{ value: 'hide', label: __( 'Hide', 'bne' ) },
									]
								} 
							),
						( attributes.layout != 'portfolio' ) &&
							el( SelectControl, {
									value: attributes.thumbnailStyle,
									label: __('Featured Image Style'),
									onChange: function( newThumbnailStyle ) {
										props.setAttributes( { thumbnailStyle: newThumbnailStyle } );
									},
									options: [
										{ value: 'flat', label: __( 'Flat (no frame)', 'bne' ) },
										{ value: 'pretty', label: __( 'Pretty', 'bne' ) },
										{ value: 'modern', label: __( 'Modern', 'bne' ) },
									]
								} 
							),
						el( ToggleControl, {
								label: __( 'Display Excerpt', 'bne' ),
								checked: !!attributes.showExcerpt,
								onChange: function( newShowExcerpt ) {
									props.setAttributes( { showExcerpt: newShowExcerpt } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Display Category', 'bne' ),
								checked: !!attributes.showCategory,
								onChange: function( newShowCategory ) {
									props.setAttributes( { showCategory: newShowCategory } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Display Date', 'bne' ),
								checked: !!attributes.showDate,
								onChange: function( newShowDate ) {
									props.setAttributes( { showDate: newShowDate } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Display Author', 'bne' ),
								checked: !!attributes.showAuthor,
								onChange: function( newShowAuthor ) {
									props.setAttributes( { showAuthor: newShowAuthor } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Display Comments', 'bne' ),
								checked: !!attributes.showComments,
								onChange: function( newShowComments ) {
									props.setAttributes( { showComments: newShowComments } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Display Readmore Button', 'bne' ),
								checked: !!attributes.showReadmore,
								onChange: function( newShowReadmore ) {
									props.setAttributes( { showReadmore: newShowReadmore } );
								}
							} 
						),
						( attributes.showReadmore == 1 ) &&
			                el( TextControl, {
									label: __( 'Customize Read More Link', 'bne' ),
									value: attributes.readmoreText,
									onChange: function( newReadmoreText ) {
										props.setAttributes( { readmoreText: newReadmoreText } );
									}
				                } 
				            )
						
					),
				),


				// Editor
				// ========================== //
				el( ServerSideRender, {
					block: 'bne/posts',
					attributes: attributes
				} ) // End div.bne-posts
			
			]; // END return
		}, // END edit
	
		
		// ========================== //
		// Save
		// ========================== //
		save: function() {
       	 	// Rendering in PHP
	   	 	return null;
		} // End save

	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);