/*
 * 	BNE Block Modal (Popup)
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	April 16, 2020
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var ColorPalette = wp.editor.ColorPalette;
	var InnerBlocks = wp.blockEditor.InnerBlocks;
	var RichText = wp.blockEditor.RichText;
	var PanelBody = wp.components.PanelBody;
	var Button = wp.components.Button;
	var Dashicon = wp.components.Dashicon;
	var Placeholder = wp.components.Placeholder;	
	var TextControl = wp.components.TextControl;
	var SelectControl = wp.components.SelectControl;
	var ToggleControl = wp.components.ToggleControl;
	
	//console.log(wp.editor);
	
	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/modal', {
		title: __( 'Modal (Popup)', 'bne' ),
		description: __( 'Add a modal popup for additional content that can open from any page element.', 'bne' ),
		icon: 'editor-expand',
		category: 'bne-blocks',
		attributes: {
			modalID: {
				type: 'string',
				default: ''
			},
			size: {
				type: 'string',
				default: 'md'
			},
			autoOpen: {
				type: 'boolean',
				default: 0
			},
			heading: {
				type: 'string',
				default: ''
			}
		},

		supports: {
			anchor: false,
			html: false
		},
		
		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			
			// Toggle Modal to Edit/Close
			var ModalToggle = function ModalToggle(event) {
				event.preventDefault();
			 	jQuery('#'+attributes.modalID).toggle();
			};
			
			
			// Set a unique ID
			if( ! attributes.modalID ) {
				//props.setAttributes( { modalID: Math.floor((Math.random() * 1000) + 1) } );
				props.setAttributes( { modalID: Math.floor((Math.random() * 1000) + 1).toString() } );
			}
  		
  			return [

				// Panel Controls
				// ========================== //
				el( InspectorControls, {},

 					// Font Settings Panel
 					el( PanelBody, {
							title: __( 'Modal Settings', 'bne' ),
							initialOpen: true,
						},
						
						// Size
						el( SelectControl, {
								value: attributes.size,
								label: __( 'Size', 'bne' ),
								onChange: function( newSize ) {
									props.setAttributes( { size: newSize } );
								},
								options: [
									{ value: 'sm', label: __( 'Small', 'bne' ) },
									{ value: 'md', label: __( 'Medium', 'bne' ) },
									{ value: 'lg', label: __( 'Lage', 'bne' ) },
								]
							} 
						),
						
						// Open by default
						el( ToggleControl, {
								label: __( 'Show automatically', 'bne' ),
								help: __( 'Sets this modal to open automatically on page load', 'bne' ),
								checked: !!attributes.autoOpen,
								onChange: function( newAutoOpen ) {
									props.setAttributes( { autoOpen: newAutoOpen } );
								}
							} 
						),
						
						// Heading
						el( TextControl, {
								label: __('Heading', 'bne' ),
								value: attributes.heading,
								onChange: function( newHeading ) {
									props.setAttributes( { heading: newHeading } );
								}
							} 
						),

						// Trigger
						el( TextControl, {
								label: __('Trigger ID', 'bne' ),
								value: attributes.modalID,
								onChange: function( newModalID ) {
									props.setAttributes( { modalID: newModalID } );
								}
							} 
						),
						el( 'p', {},
							el('strong',{}, __('Classname:','bne') ), 
							' modal-trigger-'+attributes.modalID
						),
						el( 'p', {},
							__( 'Modals are hidden on the page until requested from a click action. Use the above classname on any button, link, or image to open this modal.', 'bne' )
						)
						
					), // end PanelBody

				), // End InspectorControls



				// Editor
				// ========================== //
				el( 'div', {
						className: props.className + ' bne-modal', 
						style: {} 
					},
					
					// Trigger Toggle
					el( Placeholder, {
							icon: 'editor-expand',
							label: __( 'Modal (Popup)', 'bne' ),
							focus: true,
							instructions: __( 'Modals are hidden on the page until requested from a click action. Use the above classname on any button, link, or image to open this modal.', 'bne' )
						},
						el( Button, {
								className: 'modal-trigger',
								focus: true,
								isSecondary: true,
								onClick: ModalToggle
							},
							__('Edit This model', 'bne' )
						),
						el( 'span', { 
								className: 'trigger-class-notice', 
							},
							'modal-trigger-'+attributes.modalID
						)
					),
					
					
					// Modal Content Display
					el( 'div', {
							id: attributes.modalID,
							className: 'bne-modal-wrapper',
							style: { display:'none'}
						},
						el( 'div', { className: 'modal' },
							el( 'div', { className: 'modal-dialog modal-'+ attributes.size },
								el( 'div', { className: 'modal-content' },
								
									// Heading
									el( 'div', { className: 'modal-header' },
										el( RichText, {
											tagName: 'h5',
											className: 'modal-title',
											placeholder: __('Add a heading...', 'bne' ),
											multiline: false,
											allowedFormats: ['bold', 'italic'],
											keepPlaceholderOnFocus: false,
											value: attributes.heading,
											onChange: function( newHeading ) {
												props.setAttributes( { heading: newHeading } );
											},
										} ),
										el( 'button', { 
											type: 'button',
											className: 'close' },
											el( 'i', { className: 'fas fa-times' } )
										)
									),
									
									// Content
									el( 'div', { className: 'modal-body' },
										// Workaround logic for this bug https://github.com/WordPress/gutenberg/issues/9897
										// Happens when applying a style option with a block that has innerblocks
										// When fixed, remove the condition
										( 'undefined' !== typeof props.insertBlocksAfter ) 
											?
												el( InnerBlocks, {
													template: [
														[ 'core/paragraph']
													],
													templateLock: false,
													templateInsertUpdatesSelection: false
												} ) 
											: 
												el( 'div' )
									)
								)
							)
						)
					),
					
				) // End div.bne-modal
			
			]; // END return
		}, // END edit
	
		
		// ========================== //
		// Save
		// ========================== //
		save: function (props) {
			//console.log(InnerBlocks.Content)
       	 	// Rendering in PHP
	   	 	return ( el( InnerBlocks.Content, {} ) );
		} // End save

	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);