/*
 * 	BNE Block Map
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	April 18, 2020
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var ServerSideRender = wp.serverSideRender;
	var PanelBody = wp.components.PanelBody;
	var SelectControl = wp.components.SelectControl;
	var TextControl = wp.components.TextControl;
	var RangeControl = wp.components.RangeControl;
	var ToggleControl = wp.components.ToggleControl;
	var Placeholder = wp.components.Placeholder;



	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/map', {
		title: __( 'Google Map', 'bne' ),
		description: __( 'Display a google map of an address or point of interest.', 'bne' ),
		icon: 'location-alt',
		category: 'bne-blocks',
		attributes: {
			APIKey: {
				type: 'string',
				default: bne_blocks_map_vars.apiKey
			},
			address: {
				type: 'string',
				default: 'Los Angeles, CA, USA'
			},
			mapType: {
				type: 'string',
				default: 'roadmap'
			},
			zoom: {
				type: 'integer',
				default: 15
			},
			height: {
				type: 'integer',
				default: 250
			},
			interactiveMap: {
				type: 'boolean',
				default: true
			},
			grayscale: {
				type: 'boolean',
				default: false
			},
			showAddress: {
				type: 'boolean',
				default: false
			},
			showDirections: {
				type: 'boolean',
				default: false
			},
		},
		supports: {
			align: ['wide','full'],
		},

		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes);
  		
  			return [

				// Panel Controls
				// ========================== //
				el( InspectorControls, {},

	                el( PanelBody, {},
		                
		                el( TextControl, {
								label: __( 'Address', 'bne' ),
								value: attributes.address,
								onChange: function( newAddress ) {
									props.setAttributes( { address: newAddress } );
								}
			                } 
			            ),
						el( SelectControl, {
								value: attributes.mapType,
								label: __('Map Type'),
								onChange: function( newMapType ) {
									props.setAttributes( { mapType: newMapType } );
								},
								options: [
									{ value: 'roadmap', label: __( 'Roadmap (default)', 'bne' ) },
									{ value: 'satellite', label: __( 'Satellite', 'bne' ) }
								]
							} 
						),
		                el( RangeControl, {
								label: __( 'Zoom', 'bne' ),
								value: attributes.zoom,
								onChange: function( newZoom ) {
									props.setAttributes( { zoom: newZoom } );
								},
		                        min: 1,
		                        max: 21,
		                        beforeIcon: "arrow-left-alt2",
		                        afterIcon: "arrow-right-alt2"
			                } 
			            ),
		                el( RangeControl, {
								label: __( 'Height (px)', 'bne' ),
								value: attributes.height,
								onChange: function( newHeight ) {
									props.setAttributes( { height: newHeight } );
								},
		                        min: 100,
		                        max: 1000,
		                        beforeIcon: "arrow-left-alt2",
		                        afterIcon: "arrow-right-alt2",
			                } 
			            ),
						el( ToggleControl, {
								label: __( 'Display as an Interactive Map', 'bne' ),
								checked: !!attributes.interactiveMap,
								onChange: function( newInteractiveMap ) {
									props.setAttributes( { interactiveMap: newInteractiveMap } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Grayscale', 'bne' ),
								checked: !!attributes.grayscale,
								onChange: function( newGrayscale ) {
									props.setAttributes( { grayscale: newGrayscale } );
								}
							} 
						),

						el( ToggleControl, {
								label: __( 'Show Address', 'bne' ),
								checked: !!attributes.showAddress,
								onChange: function( newShowAddress ) {
									props.setAttributes( { showAddress: newShowAddress } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Show Direction Button', 'bne' ),
								checked: !!attributes.showDirections,
								onChange: function( newShowDirections ) {
									props.setAttributes( { showDirections: newShowDirections } );
								}
							} 
						),
			            el( 'hr',{} ),
		                el( TextControl, {
								label: __( 'API Key', 'bne' ),
		                        help: el( 'p', {},
	                        		__( 'An API Key is required to use Google Maps. Please Create your API Key using the Google Console. ', 'bne' ),
									el( 'a', {
		                        			href: 'https://console.developers.google.com',
											target: '_blank',
		                        		},
										__( 'Learn More', 'bne' )
									)
			                    ),
								value: attributes.APIKey,
								onChange: function( newAPIKey ) {
									props.setAttributes( { APIKey: newAPIKey } );
								}
			                } 
			            )
			        )   
	
				), // End InspectorControls


				// Editor
				// ========================== //
				( !attributes.APIKey
					?	el( Placeholder,{
								icon: "location-alt",
								label: __( 'No API Key Provided.', 'bne' ),
								instructions: __( 'To display a Google Map, requires an active Google Places API key.', 'bne' ),
							},
							el( TextControl, {
								label: __( 'Enter Your Google API Key', 'bne' ),
								value: attributes.APIKey,
								onChange: function( newAPIKey ) {
									props.setAttributes( { APIKey: newAPIKey } );
								}
							} ),
						)
						
					: 	el( ServerSideRender, {
							block: 'bne/map',
							attributes: attributes
						} )
				)
			
			]; // END return
		}, // END edit
	
		
		// ========================== //
		// Save
		// ========================== //
		save: function () {
       	 	// Rendering in PHP
	   	 	return null;
		} // End save

	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);