/*
 * 	BNE Block Icon List
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	June 13, 2020
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var BlockControls = wp.blockEditor.BlockControls;
	var AlignmentToolbar = wp.blockEditor.AlignmentToolbar;
	var MediaUpload = wp.blockEditor.MediaUpload;
	var InnerBlocks = wp.editor.InnerBlocks;
	var RichText = wp.blockEditor.RichText;
	var PanelBody = wp.components.PanelBody;
	var Button = wp.components.Button;
	var ToggleControl = wp.components.ToggleControl;
	var RangeControl = wp.components.RangeControl;


	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/list', {
		title: __( 'Icon List', 'bne' ),
		description: __( 'An unordered list with icons. You can use this as a list of features or benefits.', 'bne' ),
		icon: 'editor-ul',
		category: 'bne-blocks',
		attributes: {

			// BlockControls
			alignment: {
				type: 'string',
				default: 'left'
			},
			
			// InspectorControls
			contentList: {
				type: 'array',
				source: 'children',
				selector: 'ul',
			},
       		mediaID: {
  				type: 'number',
  			},
  			mediaURL: {
  				type: 'string',
  			},
			iconSize: {
				type: 'number',
				default: 32
			},
			listGapSize: {
				type: 'number',
				default: 16
			},
			listFontSize: {
				type: 'number',
				default: 16
			},
			listColumns: {
				type: 'number',
				default: 1
			},
			useCSSGrid: {
				type: 'boolean',
				default: 0				
			},
		},
		
		
		// ========================== //
		// Edit
		// ========================== //
		edit: function( props ) {
			//console.log(props.attributes);
			var attributes = props.attributes;
    		
  			return [
	  			

				// Block Controls
				// ========================== //
  				el( BlockControls, {},
					el( AlignmentToolbar, {
						value: !attributes.alignment ? 'left' : attributes.alignment,
						onChange: function( newAlignment ) {
							props.setAttributes( { alignment: newAlignment } );
						},
					} )
				),

				// Panel Controls
				// ========================== //
				el( InspectorControls, {},
					el( PanelBody, {								
							title: __( 'List Settings', 'bne' ),
							initialOpen: true,
						},
						
						el( RangeControl, {
								label: __( 'Font Size', 'bne' ),
								value: attributes.listFontSize,
								onChange: function( newListFontSize ) {
									props.setAttributes( { listFontSize: newListFontSize } );
								},
								min: 10,
								max: 50,
								step: 1
							}
						),

						el( RangeControl, {
								label: __( 'Gap Size', 'bne' ),
								value: attributes.listGapSize,
								onChange: function( newListGapSize ) {
									props.setAttributes( { listGapSize: newListGapSize } );
								},
								min: 0,
								max: 50,
								step: 1
							}
						),

						el( RangeControl, {
								label: __( 'Columns', 'bne' ),
								value: attributes.listColumns,
								onChange: function( newListColumns ) {
									props.setAttributes( { listColumns: newListColumns } );
								},
								min: 1,
								max: 4,
								step: 1
							}
						),
						
						attributes.listColumns > 1 &&
						el( ToggleControl, {
								label: __( 'Display as a grid (left to right & evenly spaced)', 'bne' ),
								checked: !!attributes.useCSSGrid,
								onChange: function( newUseCSSGrid ) {
									props.setAttributes( { useCSSGrid: newUseCSSGrid } );
								}
							} 
						),
					
					), // end PanelBody
						
						
					el( PanelBody, {
							title: __( 'Icon', 'bne' )
						},
					
						// Image
						el( MediaUpload, {
							onSelect: function( media ) {
									props.setAttributes( { 
										mediaURL: media.url,
										mediaID: media.id
									} );
							},
							allowedTypes: 'image',
							value: attributes.mediaURL,
							render: function( media ) {
								return (
									!attributes.mediaURL 
									? (
										el( Button, {
												className: attributes.mediaURL ? 'image-button' : 'button button-large',
												style: { margin: '0' },
												onClick: media.open
												
											},
											el( 'span', { 
													className: 'dashicons dashicons-format-image', width: '20', height: '20',
													style: { margin: '3px 5px 0 0' },
												}
											),
											__( 'Upload Image', 'bne' )
										)
									) : (
										el( 'div', {
												className: 'components-base-control',
											},
										
											el( 'a', {
													href: '#',
													onClick: media.open
												},
												el( 'img', { 
													src: attributes.mediaURL 
												} ),
											),
											el('p', { style: { fontStyle: 'italic' } }, __('Click the image to edit or update') ),
											el( 'a', {
													href: '#',
													onClick: function() {
														props.setAttributes( { 
															mediaURL: '',
															mediaID: '',
														} );
													},
												},
												__( 'Remove Image', 'bne' )
											),
										)// end div
									) // end if/else
								) // end Return
							} // end Render
						} ), // end MediaUpload

						// Icon Size
						attributes.mediaURL &&
							el( 'div', {},
								el( RangeControl, {
										label: __( 'Icon Size', 'bne' ),
										value: attributes.iconSize,
										onChange: function( newIconSize ) {
											props.setAttributes( { iconSize: newIconSize } );
										},
										min: 16,
										max: 100,
										step: 1
									}
								),
							)
					
					) // end PanelBody
				
				), // End InspectorControls



				// Editor
				// ========================== //
				el( 'div', {
						className: 
							props.className + 
							' bne-list' +
							' has-columns-'+attributes.listColumns +
							( attributes.useCSSGrid ? ' list-display-grid' : '' )
						,
						style: {
							...(attributes.mediaURL ? { '--icon': 'url('+attributes.mediaURL+')' } : undefined ),
							'--icon-size': ( attributes.iconSize ? attributes.iconSize+'px' : '1rem' ),
							'--gap': ( attributes.listGapSize ? attributes.listGapSize+'px' : '0' ),
							'--font-size': ( attributes.listFontSize ? attributes.listFontSize+'px' : '1rem' ),
							'--columns': ( attributes.listColumns ? attributes.listColumns+' ' : '1' ),
							'text-align': attributes.alignment
						},
					},
					
					el( RichText, {
						tagName: 'ul',
						className: 'bne-'+(attributes.mediaURL ? 'img-list' : 'default-list' ),
						formattingControls: [ 'italic', 'link', 'bold','text-color' ],
						placeholder: __( 'Add an item...', 'bne' ),
						multiline: 'li',
						keepPlaceholderOnFocus: true,
						value: attributes.contentList,
						onChange: function( newContentList ) {
							props.setAttributes( { contentList: newContentList } );
						},


					} )
					
				)  // End div.bne-list
			
			]; // END Return
		
		}, // END edit
	


		// ========================== //
		// Save
		// ========================== //
		save: function (props) {
			//console.log(props.attributes);
			var attributes = props.attributes;
			
			return (
				el( 'div', {
						className:
							' bne-list' +
							' has-columns-'+attributes.listColumns +
							( attributes.useCSSGrid ? ' list-display-grid' : '' )
						,
						style: {
							...(attributes.mediaURL ? { '--icon': 'url('+attributes.mediaURL+')' } : undefined ),
							'--icon-size': ( attributes.iconSize ? attributes.iconSize+'px' : '1rem' ),
							'--gap': ( attributes.listGapSize ? attributes.listGapSize+'px' : '0' ),
							'--font-size': ( attributes.listFontSize ? attributes.listFontSize+'px' : '1rem' ),
							'--columns': ( attributes.listColumns ? attributes.listColumns+' ' : '1' ),
							'text-align': attributes.alignment
						},
					},
					
					el( RichText.Content, {
						tagName: 'ul',
						className: 'bne-'+(attributes.mediaURL ? 'img-list' : 'default-list' ),
						value: attributes.contentList,
					} )
					
				) // End .bne-list
			
			) // End Return
		
		}, // End save


		// ========================== //
		// DEPRECATED BLOCK
		// ========================== //
		deprecated: [


			// @deprecited @v2.2.5
			{
				attributes:{contentList:{type:'array',source:'children',selector:'ul',},mediaID:{type:'number',},mediaURL:{type:'string',},iconSize:{type:'number',default:32},listGapSize:{type:'number',default:16},listFontSize:{type:'number',default:16},listColumns:{type:'number',default:1},},save:function(props){var attributes=props.attributes;return(el('div',{className:'bne-list has-columns-'+attributes.listColumns,style:{...(attributes.mediaURL?{'--icon':'url('+attributes.mediaURL+')'}:undefined),'--icon-size':(attributes.iconSize?attributes.iconSize+'px':'1rem'),'--gap':(attributes.listGapSize?attributes.listGapSize+'px':'0'),'--font-size':(attributes.listFontSize?attributes.listFontSize+'px':'1rem'),'--columns':(attributes.listColumns?attributes.listColumns+' ':'1')},},el(RichText.Content,{tagName:'ul',className:'bne-'+(attributes.mediaURL?'img-list':'default-list'),value:attributes.contentList,})))}
			},

			// @depreciated @v2.2.4
			// Original block
			{
				attributes:{contentList:{type:'array',source:'children',selector:'ul',},mediaID:{type:'number',},mediaURL:{type:'string',},iconSize:{type:'number',default:32},listGapSize:{type:'number',default:16},listFontSize:{type:'number',default:16},listColumns:{type:'number',default:1},},save:function(props){var attributes=props.attributes;return(el('div',{className:'bne-list has-columns-'+attributes.listColumns,style:{'--icon':(attributes.mediaURL?'url('+attributes.mediaURL+')':''),'--icon-size':(attributes.iconSize?attributes.iconSize+'px':'1rem'),'--gap':(attributes.listGapSize?attributes.listGapSize+'px':'0'),'--font-size':(attributes.listFontSize?attributes.listFontSize+'px':'1rem'),'--columns':(attributes.listColumns?attributes.listColumns+' ':'1')},},el(RichText.Content,{tagName:'ul',className:'bne-'+(attributes.mediaURL?'img-list':'default-list'),value:attributes.contentList,})))}
			}
		] // END DEPRECATED



	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);