/*
 * 	BNE Block Heading
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	April 17, 2021
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var BlockControls = wp.blockEditor.BlockControls;
	var AlignmentToolbar = wp.blockEditor.AlignmentToolbar;
	var MediaUpload = wp.editor.MediaUpload;
	var RichText = wp.blockEditor.RichText;
	var PanelBody = wp.components.PanelBody;
	var Button = wp.components.Button;
	var SelectControl = wp.components.SelectControl;
	var RangeControl = wp.components.RangeControl;
	var ToggleControl = wp.components.ToggleControl;
	var ColorPalette = wp.blockEditor.ColorPalette;
	
	//console.log(wp.editor);

	// Icons
	var iconBlock = 
		el( 'svg', { 
			width: '20', 
			height: '20',
			xmlns: 'http://www.w3.org/2000/svg',
			viewBox: '0 0 512 512'
		},
		el( 'path', { d: "M496 80V48c0-8.837-7.163-16-16-16H320c-8.837 0-16 7.163-16 16v32c0 8.837 7.163 16 16 16h37.621v128H154.379V96H192c8.837 0 16-7.163 16-16V48c0-8.837-7.163-16-16-16H32c-8.837 0-16 7.163-16 16v32c0 8.837 7.163 16 16 16h37.275v320H32c-8.837 0-16 7.163-16 16v32c0 8.837 7.163 16 16 16h160c8.837 0 16-7.163 16-16v-32c0-8.837-7.163-16-16-16h-37.621V288H357.62v128H320c-8.837 0-16 7.163-16 16v32c0 8.837 7.163 16 16 16h160c8.837 0 16-7.163 16-16v-32c0-8.837-7.163-16-16-16h-37.275V96H480c8.837 0 16-7.163 16-16z" } )
	);


	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/heading', {
		title: __( 'Advanced Heading', 'bne' ),
		description: __( 'A styled Heading block with a sub heading and border option.', 'bne' ),
		icon: iconBlock,
		category: 'bne-blocks',
		attributes: {
			
			// BlockControls
			alignment: {
				type: 'string',
				default: 'left'
			},
			
			// InspectorControls
			headingText: {
				type: 'string',
				default: ''
			},
			headingColor: {
				type: 'string',
				default: ''
			},
			headingLevel: {
				type: 'string',
				default: 'h2'
			},
			headingFontSize: {
				type: 'integer'
			},
			subHeadingEnable: {
				type: 'boolean',
				default: false				
			},
			subheadingAbove: {
				type: 'boolean',
				default: false
			},
			subHeadingText: {
				type: 'string',
				default: ''
			},
			subHeadingColor: {
				type: 'string',
				default: ''
			},
			subHeadingLevel: {
				type: 'string',
				default: 'span',
			},
			subHeadingFontSize: {
				type: 'integer'
			},
			borderEnable: {
				type: 'boolean',
				default: false				
			},
			borderLocation: {
				type: 'string',
				default: 'below'
			},
			borderColor: {
				type: 'string',
				default: '#555'
			},
       		borderMediaID: {
  				type: 'number',
  			},
  			borderMediaURL: {
  				type: 'string',
  			},
			borderWidth: {
				type: 'number',
				default: 5
			},
			borderHeight: {
				type: 'number',
				default: 5
			},
		},
		
		supports: {
			anchor: true,
		},
		
		transforms: {
		    from: [
		        {
		            type: 'block',
		            blocks: [ 'core/heading' ],
		            transform: function ( attributes ) {
		                return wp.blocks.createBlock( 'bne/heading', {
		                    headingText: attributes.content,
		                    alignment: attributes.align
		                } );
		            },
		        },
		    ],
		    to: [
		        {
		            type: 'block',
		            blocks: [ 'core/heading' ],
		            transform: function ( attributes ) {
		                return wp.blocks.createBlock( 'core/heading', {
		                    content: attributes.headingText,
		                    align: attributes.alignment
		                } );
		            },
		        },
		    ]
		},	
		
			
		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			// Heading Classes
			var headingClasses =
				' heading-align-'+attributes.alignment +
				( attributes.borderEnable 
					? ' has-border has-border-'+attributes.borderLocation 
					: '' 
				) +
				( attributes.borderMediaURL 
					? ' has-border-image' 
					: '' 
				) +
				( attributes.subHeadingEnable 
					? ' has-subheading' + ( attributes.subheadingAbove ? ' has-subheading-above' : '' )
					: ''
				)
			;
			

			// EDITOR
  			return [

				// Block Controls
				// ========================== //
  				el( BlockControls, {},
					el( AlignmentToolbar, {
						value: !attributes.alignment ? 'left' : attributes.alignment,
						onChange: function( newAlignment ) {
							props.setAttributes( { alignment: newAlignment } );
						},
					} )
				),
						
						
				// Panel Controls
				// ========================== //
				el( InspectorControls, {},
				
					// Heading Settings
					el( PanelBody, {								
							title: __( 'Main Heading', 'bne' ),
							initialOpen: true,
						},
						el('p', {}, __( 'Color', 'bne' ) ),
						el( ColorPalette, {
								value: attributes.headingColor,
								onChange: function( newHeadingColor ) {
									props.setAttributes( { headingColor: newHeadingColor } );
								},
							},
						),
						el( SelectControl, {
								value: attributes.headingLevel,
								label: __('Level'),
								onChange: function( newHeadingLevel ) {
									props.setAttributes( { headingLevel: newHeadingLevel } );
								},
								options: [
									{ value: 'h1', label: __( 'H1' ) },
									{ value: 'h2', label: __( 'H2' ) },
									{ value: 'h3', label: __( 'H3' ) },
									{ value: 'h4', label: __( 'H4' ) },
									{ value: 'h5', label: __( 'H5' ) },
									{ value: 'h6', label: __( 'H6' ) },
									{ value: 'span', label: __( 'Span' ) },
								]
							} 
						),

						el( RangeControl, {
							className: "components-font-size-picker__custom-input",
							label: __( 'Custom Size (px)', 'bne' ),
							value: attributes.headingFontSize,
							initialPosition: '',
							onChange: function( newHeadingFontSize ) {
									props.setAttributes( { headingFontSize: newHeadingFontSize } );
							},
							min: 10,
							max: 100,
							beforeIcon: "editor-textcolor",
							afterIcon: "editor-textcolor",
							allowReset: true
						} ),


					), // end PanelBody
					
					
					
					// Sub Heading Settings
					el( PanelBody, {								
							title: __( 'Sub Heading', 'bne' ),
							initialOpen: attributes.subHeadingEnable ? true : false,
						},
						el( ToggleControl, {
							label: __( 'Display Sub Heading', 'bne' ),
							checked: !!attributes.subHeadingEnable,
							onChange: function( newSubHeadingEnable ) {
								props.setAttributes( { subHeadingEnable: newSubHeadingEnable } );
							}
						} ),
						
						attributes.subHeadingEnable &&
						el('div', {},

							el( ToggleControl, {
								label: __( 'Reverse the Headings', 'bne' ),
								checked: !!attributes.subheadingAbove,
								onChange: function( newSubheadingAbove ) {
									props.setAttributes( { subheadingAbove: newSubheadingAbove } );
								}
							} ),

							el('p', {}, __( 'Color', 'bne' ) ),
							el( ColorPalette, {
									value: attributes.subHeadingColor,
									onChange: function( newSubHeadingColor ) {
										props.setAttributes( { subHeadingColor: newSubHeadingColor } );
									},
								},
							),
							el( SelectControl, {
									value: attributes.subHeadingLevel,
									label: __('Level'),
									onChange: function( newSubHeadingLevel ) {
										props.setAttributes( { subHeadingLevel: newSubHeadingLevel } );
									},
									options: [
										{ value: 'h1', label: __( 'H1' ) },
										{ value: 'h2', label: __( 'H2' ) },
										{ value: 'h3', label: __( 'H3' ) },
										{ value: 'h4', label: __( 'H4' ) },
										{ value: 'h5', label: __( 'H5' ) },
										{ value: 'h6', label: __( 'H6' ) },
										{ value: 'span', label: __( 'Span' ) },
									]
								} 
							),
							el( RangeControl, {
								className: "components-font-size-picker__custom-input",
								label: __( 'Custom Size (px)' ),
								value: attributes.subHeadingFontSize,
								initialPosition: '',
								onChange: function( newSubHeadingFontSize ) {
										props.setAttributes( { subHeadingFontSize: newSubHeadingFontSize } );
								},
								min: 10,
								max: 100,
								beforeIcon: "editor-textcolor",
								afterIcon: "editor-textcolor",
								allowReset: true
							} ),

						),
					
					), // end PanelBody
					
					
					
					// Border Settings
					el( PanelBody, {								
							title: __( 'Border' ),
							initialOpen: attributes.borderEnable ? true : false,
						},

						el( ToggleControl, {
							label: __( 'Display Border', 'bne' ),
							checked: !!attributes.borderEnable,
							onChange: function( newBorderEnable ) {
								props.setAttributes( { borderEnable: newBorderEnable } );
							}
						} ),

						attributes.borderEnable &&
						el('div', {},

							el( SelectControl, {
									value: attributes.borderLocation,
									label: __( 'Location', 'bne' ),
									onChange: function( newBorderLocation ) {
										props.setAttributes( { borderLocation: newBorderLocation } );
									},
									options: [
										{ value: 'above', label: __( 'Above', 'bne' ) },
										{ value: 'side', label: __( 'Side', 'bne' ) },
										{ value: 'below', label: __( 'Below', 'bne' ) },
									]
								} 
							),
							
							el( 'hr', {} ),
							el('p', {}, __( 'Color', 'bne' ) ),
							el( ColorPalette, {
									value: attributes.borderColor,
									onChange: function( newBorderColor ) {
										props.setAttributes( { borderColor: newBorderColor } );
									},
								},
							),

							// Image
							el('p', {}, __( 'Image', 'bne' ) ),
							el( MediaUpload, {
								onSelect: function( media ) {
										props.setAttributes( { 
											borderMediaURL: media.url,
											borderMediaID: media.id
										} );
								},
								allowedTypes: 'image',
								value: attributes.borderMediaURL,
								render: function( media ) {
									return (
										!attributes.borderMediaURL 
										? (
											el( Button, {
													className: attributes.borderMediaURL ? 'image-button' : 'button button-large',
													style: { margin: '0' },
													onClick: media.open
													
												},
												el( 'span', { 
														className: 'dashicons dashicons-format-image', width: '20', height: '20',
														style: { margin: '3px 5px 0 0' },
													}
												),
												__( 'Upload Image', 'bne' )
											)
										) : (
											el( 'div', {
													className: 'components-base-control',
												},
											
												el( 'a', {
														href: '#',
														onClick: media.open
													},
													el( 'img', { 
														src: attributes.borderMediaURL 
													} ),
												),
												el('p', { style: { fontStyle: 'italic' } }, __('Click the image to edit or update') ),
												el( 'a', {
														href: '#',
														onClick: function() {
															props.setAttributes( { 
																borderMediaURL: '',
																borderMediaID: '',
															} );
														},
													},
													__( 'Remove Image', 'bne' )
												),
											)// end div
										) // end if/else
									) // end Return
								} // end Render
							} ), // end MediaUpload
							
							el( 'hr', {} ),
							el( RangeControl, {
									label: __( 'Max Width', 'bne' ),
									value: attributes.borderWidth,
									onChange: function( newBorderWidth ) {
										props.setAttributes( { borderWidth: newBorderWidth } );
									},
									min: 1,
									max: 100,
									step: 1
								}
							),

							el( RangeControl, {
									label: __( 'Max Height', 'bne' ),
									value: attributes.borderHeight,
									onChange: function( newBorderHeight ) {
										props.setAttributes( { borderHeight: newBorderHeight } );
									},
									min: 1,
									max: 100,
									step: 1
								}
							)
						)
					) // end PanelBody


				), // End InspectorControls



				// Editor
				// ========================== //
				el( 'div', {
						className: props.className + ' bne-heading'+headingClasses, 
						style: {
							'--border-width': attributes.borderWidth,
							'--border-height': attributes.borderHeight,
							'--border-color': ( attributes.borderColor ? attributes.borderColor : '#555' ),
							...(attributes.borderMediaURL ? { '--border-image': 'url('+attributes.borderMediaURL+')' } : undefined ),
							textAlign: attributes.alignment
						} 
					},
					
					el( 'div', {
							className: 'heading-inner', 
						},
						
						// Heading
						el( RichText, {
							tagName: attributes.headingLevel ? attributes.headingLevel : 'h2',
							className: 'heading-main',
							style: {
								...(attributes.headingColor ? {color: attributes.headingColor} : undefined),
								...(attributes.headingFontSize ? {fontSize: attributes.headingFontSize} : undefined)
							},
							placeholder: i18n.__( 'Write a heading...', 'bne' ),
							formattingControls: [ 'bold', 'italic', 'link', 'text-color', 'underline' ],
							title: __('Main Heading', 'bne'),
							keepPlaceholderOnFocus: true,
							value: attributes.headingText,
							onChange: function( newHeadingText ) {
								props.setAttributes( { headingText: newHeadingText } );
							},
						} ),
						

						// SubHeading
						attributes.subHeadingEnable &&
							el( RichText, {
								tagName: attributes.subHeadingLevel ? attributes.subHeadingLevel : 'span',
								className: 'heading-sub',
								style: {
									...(attributes.subHeadingColor ? {color: attributes.subHeadingColor} : undefined),
									...(attributes.subHeadingFontSize ? {fontSize: attributes.subHeadingFontSize} : undefined)
								},
								placeholder: i18n.__( 'Write a sub heading...', 'bne' ),
								title: __('Sub Heading', 'bne'),
								formattingControls: [ 'bold', 'italic', 'link', 'text-color', 'underline' ],
								keepPlaceholderOnFocus: true,
								value: attributes.subHeadingText,
								onChange: function( newSubHeadingText ) {
									props.setAttributes( { subHeadingText: newSubHeadingText } );
								},
							} )

					) // end div.heading-inner

				) // End div.bne-heading
			
			]; // END return
		
		}, // END edit
	
		
		// ========================== //
		// Save
		// ========================== //
		save: function (props) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			// Heading Classes
			var blockClasses =
				' heading-align-'+attributes.alignment +
				( attributes.borderEnable 
					? ' has-border has-border-'+attributes.borderLocation 
					: '' 
				) +
				( attributes.borderMediaURL 
					? ' has-border-image' 
					: '' 
				) +
				( attributes.subHeadingEnable 
					? ' has-subheading' + ( attributes.subheadingAbove ? ' has-subheading-above' : '' )
					: ''
				)
			;
			
			return (
				
				el( 'div', {
						className: 'bne-heading'+blockClasses, 
						style: {
							'--border-width': attributes.borderWidth+' ', // Bug? adding a space to prevent WP converting this to px
							'--border-height': attributes.borderHeight+' ', // Bug? adding a space to prevent WP converting this to px
							'--border-color': ( attributes.borderColor ? attributes.borderColor : '#555' ),
							...(attributes.borderMediaURL ? { '--border-image': 'url('+attributes.borderMediaURL+')' } : undefined ),
							textAlign: attributes.alignment
						} 
					},
					
					
					el( 'div', { 
							className: 'heading-inner' 
						},


						// Heading
						el( RichText.Content, {
							tagName: attributes.headingLevel,
							value: attributes.headingText,
							className: 'heading-main',
							style: {
								...(attributes.headingColor ? {color: attributes.headingColor} : undefined),
								...(attributes.headingFontSize ? {fontSize: attributes.headingFontSize} : undefined)
							}
						} ),

						// Heading
						attributes.subHeadingEnable &&
							el( RichText.Content, {
								tagName: attributes.subHeadingLevel,
								value: attributes.subHeadingText,
								className: 'heading-sub',
								style: {
									...(attributes.subHeadingColor ? {color: attributes.subHeadingColor} : undefined),
									...(attributes.subHeadingFontSize ? {fontSize: attributes.subHeadingFontSize} : undefined)
								}
							} )
						
					) // end div.heading-inner
				
				) // End div.bne-heading

			) // End return
		
		}, // End save


		// ========================== //
		// DEPRECATED BLOCK
		// ========================== //
		deprecated: [

			// @depreciated @v2.2.10
			// Changed default border position	
			{
				attributes:{alignment:{type:'string',default:'left'},headingText:{type:'string',default:''},headingColor:{type:'string',default:''},headingLevel:{type:'string',default:'h2'},headingFontSize:{type:'integer'},subHeadingEnable:{type:'boolean',default:!1},subheadingAbove:{type:'boolean',default:!1},subHeadingText:{type:'string',default:''},subHeadingColor:{type:'string',default:''},subHeadingLevel:{type:'string',default:'span',},subHeadingFontSize:{type:'integer'},borderEnable:{type:'boolean',default:!1},borderLocation:{type:'string',default:'above'},borderColor:{type:'string',default:'#555'},borderMediaID:{type:'number',},borderMediaURL:{type:'string',},borderWidth:{type:'number',default:5},borderHeight:{type:'number',default:5},},supports:{anchor:!0,},transforms:{from:[{type:'block',blocks:['core/heading'],transform:function(attributes){return wp.blocks.createBlock('bne/heading',{headingText:attributes.content,alignment:attributes.align})},},],to:[{type:'block',blocks:['core/heading'],transform:function(attributes){return wp.blocks.createBlock('core/heading',{content:attributes.headingText,align:attributes.alignment})},},]},save:function(props){var attributes=props.attributes;var blockClasses=' heading-align-'+attributes.alignment+(attributes.borderEnable?' has-border has-border-'+attributes.borderLocation:'')+(attributes.borderMediaURL?' has-border-image':'')+(attributes.subHeadingEnable?' has-subheading'+(attributes.subheadingAbove?' has-subheading-above':''):'');return(el('div',{className:'bne-heading'+blockClasses,style:{'--border-width':attributes.borderWidth+' ','--border-height':attributes.borderHeight+' ','--border-color':(attributes.borderColor?attributes.borderColor:'#555'),...(attributes.borderMediaURL?{'--border-image':'url('+attributes.borderMediaURL+')'}:undefined),textAlign:attributes.alignment}},el('div',{className:'heading-inner'},el(RichText.Content,{tagName:attributes.headingLevel,value:attributes.headingText,className:'heading-main',style:{...(attributes.headingColor?{color:attributes.headingColor}:undefined),...(attributes.headingFontSize?{fontSize:attributes.headingFontSize}:undefined)}}),attributes.subHeadingEnable&&el(RichText.Content,{tagName:attributes.subHeadingLevel,value:attributes.subHeadingText,className:'heading-sub',style:{...(attributes.subHeadingColor?{color:attributes.subHeadingColor}:undefined),...(attributes.subHeadingFontSize?{fontSize:attributes.subHeadingFontSize}:undefined)}}))))}	
			},
			// @depreciated @v2.2.4
			// Original block
			// @2.2.3 fixed color clearing and empty styles		
			{
				attributes:{alignment:{type:'string',default:'left'},headingText:{type:'string',source:'html',selector:'.heading-main h1,.heading-main h2,.heading-main h3,.heading-main h4,.heading-main h5,.heading-main h6,.heading-main span',},headingColor:{type:'string',default:'#333333'},headingLevel:{type:'string',default:'h2',},headingFontSize:{type:'integer'},subHeadingEnable:{type:'boolean',default:!1},subheadingAbove:{type:'boolean',default:!1},subHeadingText:{type:'string',source:'html',selector:'.heading-sub h1,.heading-sub h2,.heading-sub h3,.heading-sub h4,.heading-sub h5,.heading-sub h6,.heading-sub span',},subHeadingColor:{type:'string',default:'#888888'},subHeadingLevel:{type:'string',default:'span',},subHeadingFontSize:{type:'integer'},borderEnable:{type:'boolean',default:!1},borderLocation:{type:'string',default:'above'},borderColor:{type:'string',default:'#555'},borderMediaID:{type:'number',},borderMediaURL:{type:'string',},borderWidth:{type:'number',default:5},borderHeight:{type:'number',default:5},},supports:{anchor:!0,},transforms:{from:[{type:'block',blocks:['core/heading'],transform:function(attributes){return wp.blocks.createBlock('bne/heading',{headingText:attributes.content,alignment:attributes.align})},},],to:[{type:'block',blocks:['core/heading'],transform:function(attributes){return wp.blocks.createBlock('core/heading',{content:attributes.headingText,align:attributes.alignment})},},]},save:function(props){var attributes=props.attributes;var headingClasses=' heading-align-'+attributes.alignment+(attributes.borderEnable?' has-border has-border-'+attributes.borderLocation:'')+(attributes.borderMediaURL?' has-border-image':'')+(attributes.subHeadingEnable?' has-subheading'+(attributes.subheadingAbove?' has-subheading-above':''):'');return(el('div',{className:'bne-heading'+headingClasses,style:{'--border-width':attributes.borderWidth+' ','--border-height':attributes.borderHeight+' ','--border-color':attributes.borderColor,'--border-image':(attributes.borderMediaURL?'url('+attributes.borderMediaURL+')':''),textAlign:attributes.alignment}},el('div',{className:'heading-inner'},el('div',{className:'heading-main',},el(RichText.Content,{tagName:attributes.headingLevel,value:attributes.headingText,style:{color:attributes.headingColor,fontSize:(attributes.headingFontSize)?attributes.headingFontSize+'px':''}})),attributes.subHeadingEnable&&el('div',{className:'heading-sub',},el(RichText.Content,{tagName:attributes.subHeadingLevel,value:attributes.subHeadingText,style:{color:attributes.subHeadingColor,fontSize:(attributes.subHeadingFontSize)?attributes.subHeadingFontSize+'px':''}})))))}
			}
		] // END DEPRECATED


	} ); // End registerBlockType

} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);