/*
 * 	BNE Block Font Awesome Icon
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	April 14, 2020
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var ColorPalette = wp.blockEditor.ColorPalette;
	var PanelBody = wp.components.PanelBody;
	var TextControl = wp.components.TextControl;
	var SelectControl = wp.components.SelectControl;
	var RangeControl = wp.components.RangeControl;
	var ToggleControl = wp.components.ToggleControl;
	var URLInput = wp.blockEditor.URLInput;
	
	//console.log(wp.editor);
	
	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/fa-icon', {
		title: __( 'Font Awesome Icon', 'bne' ),
		description: __( 'Display a Font Awesome vector icon.', 'bne' ),
		icon: 'star-filled',
		category: 'bne-blocks',
		keywords: [ __( 'FA', 'bne' ), __( 'vector', 'bne' ) ],
		attributes: {
			icon: {
				type: 'string',
				default: 'address-book'
			},
			style:	{
				type: 'string',
				default: 'fas'
			},
			color: {
				type: 'string',
				color: 'inherit'
			},
			size: {
				type: 'number',
				default: 2
			},
			bgColor: {
				type: 'string',
				default: ''
			},
			bgBorderRadius: {
				type: 'number',
				default: 10
			},
			bgShadow: {
				type: 'string',
				default: 'shadow-none'
			},
			linkURL: {
				type: 'string',
				default: '',
			},
			linkTab: {
				type: 'boolean',
				default: 0				
			},
			linkLightbox: {
				type: 'boolean',
				default: 0				
			}
		},
	    supports: {
	        align: [ 'left', 'center', 'right'],
			html: false
	    },
		

		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes);
  		
  			return [

				// Panel Controls
				el( InspectorControls, {},

 					// General Panel
 					el( PanelBody, {
							title: __( 'Icon Settings', 'bne' ),
							initialOpen: true,
						},
		                el( TextControl, {
								label: __( 'Icon', 'bne' ),
								value: attributes.icon,
								onChange: function( newIcon ) {
									props.setAttributes( { icon: '' } );
									setTimeout(function(){
										props.setAttributes( { icon: newIcon } );
									},10);
									//props.setAttributes( { icon: newIcon } );
								},
								placeholder: 'address-book',
		                        help: el( 'p', {},
	                        		__( 'The icon class name. Available Icons can be found at the Font Awesome website. ', 'bne' ),
									el( 'a', {
		                        			href: 'https://fontawesome.com/icons?d=gallery',
											target: '_blank',
		                        		},
										__( 'View Icons', 'bne' )
									)
			                    ),
			                } 
			            ),
						el( SelectControl, {
								label: __('Style'),
								value: attributes.style,
								onChange: function( newStyle ) {
									props.setAttributes( { style: '' } );
									setTimeout(function(){
										props.setAttributes( { style: newStyle } );
									},10);
								},
								options: [
									{ value: 'fas', label: __( 'Solid', 'bne' ) },
									{ value: 'far', label: __( 'Regular (Pro)', 'bne' ) },
									{ value: 'fal', label: __( 'Light (Pro)', 'bne' ) },
									{ value: 'fa-thin', label: __( 'Thin (Pro)', 'bne' ) },
									{ value: 'fad', label: __( 'Duotone (Pro)', 'bne' ) },
									{ value: 'fab', label: __( 'Brands', 'bne' ) }
								],
								help: __( 'If your chosen icon does not appear, make sure you\'re using the correct style for it.', 'bne' )
							} 
						),
						el( RangeControl, {
								label: __( 'Size (em)', 'bne' ),
								value: attributes.size,
								onChange: function( newSize ) {
									props.setAttributes( { size: newSize } );
								},
								min: 1,
								max: 10,
								step: 1
							}
						),
						el('p', {}, __( 'Color', 'bne' ) ),
						el( ColorPalette, {
								value: attributes.color,
								onChange: function( newColor ) {
									props.setAttributes( { color: newColor } );
								},
							},
						),
					), // PanelBody
 					
 					// Panel: Background
 					el( PanelBody, {
							title: __( 'Icon Background', 'bne' ),
							initialOpen: true,
						},
						el('p', {}, __( 'Color', 'bne' ) ),
						el( ColorPalette, {
								value: attributes.bgColor,
								onChange: function( newBgColor ) {
									props.setAttributes( { bgColor: newBgColor } );
								},
							},
						),
						attributes.bgColor &&
							el( RangeControl, {
									label: __( 'Border Radius (%)', 'bne' ),
									value: attributes.bgBorderRadius,
									onChange: function( newBgBorderRadius ) {
										props.setAttributes( { bgBorderRadius: newBgBorderRadius } );
									},
									min: 1,
									max: 50,
									step: 1
								}
							),
						attributes.bgColor &&
							el( SelectControl, {
									value: attributes.bgShadow,
									label: __('Shadow'),
									onChange: function( newBgShadow ) {
										props.setAttributes( { bgShadow: newBgShadow } );
									},
									options: [
										{ value: 'shadow-none', label: __( 'No Shadow', 'bne' ) },
										{ value: 'shadow-sm', label: __( 'Small Shadow', 'bne' ) },
										{ value: 'shadow', label: __( 'Medium Shadow', 'bne' ) },
										{ value: 'shadow-lg', label: __( 'Large Shadow', 'bne' ) },
									]
								} 
							)
					), // PanelBody
					
 					// Panel: Link
 					el( PanelBody, {
							title: __( 'Icon Link', 'bne' ),
							initialOpen: true,
						},
						el('p', {}, __( 'Link', 'bne' ) ),
						el( URLInput, {
								className: 'components-base-control has-border',
								placeholder: __('Paste URL or type to search', 'bne' ),
								value: attributes.linkURL,
								onChange: function( newLinkURL ) {
									props.setAttributes( { linkURL: newLinkURL } );
								},
								isFullWidth: true,
								autoFocus: false
							} 
						),
						el( ToggleControl, {
								label: __( 'Open in new tab', 'bne' ),
								checked: !!attributes.linkTab,
								onChange: function( newLinkTab ) {
									props.setAttributes( { linkTab: newLinkTab } );
									props.setAttributes( { linkLightbox: 0 } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Open in Lightbox', 'bne' ),
								checked: !!attributes.linkLightbox,
								onChange: function( newLinkLightbox ) {
									props.setAttributes( { linkLightbox: newLinkLightbox } );
									props.setAttributes( { linkTab: 0 } );
								}
							} 
						),
					)


				), // InspectorControls


				// Editor
				// ========================== //
				el( 'div', {
						className: 	
							props.className
							+ ' bne-vector-icon'
							+ (attributes.bgColor ? ' has-bg-color' : '')
							+ (attributes.bgColor ? ' '+attributes.bgShadow : '')
							+ ' fa-layers fa-fw fa-'+attributes.size+'x'
						,
						style: {
							backgroundColor: (attributes.bgColor ? attributes.bgColor : 'transparent'),
							borderRadius: (attributes.bgColor ? attributes.bgBorderRadius+'%' : '0'),
							color: attributes.color
						} 
					},
					attributes.icon && attributes.style &&
						el( 'div', {
								className: 'vector-icon-inner'
							},
							el( 'i', {
								className: 'bne-fa '+attributes.style+' fa-'+attributes.icon,
							} )
						)
				) // End div.bne-vector-icon

			]; // END return
		}, // END edit
	
		
		// ========================== //
		// Save
		// ========================== //
		save: function() {
       	 	// Rendering in PHP
	   	 	return null;
		} // End save

	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);