/*
 * 	BNE Block Container
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	March 21, 2021
 *
*/
( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var BlockControls = wp.blockEditor.BlockControls;
	var BlockAlignmentToolbar = wp.blockEditor.BlockAlignmentToolbar;
	var MediaUpload = wp.blockEditor.MediaUpload;
	var InnerBlocks = wp.blockEditor.InnerBlocks;
	var PanelColorSettings = wp.editor.PanelColorSettings;
	var Toolbar = wp.components.Toolbar;
	var PanelBody = wp.components.PanelBody;
	var PanelRow = wp.components.PanelRow;
	var Tooltip = wp.components.Tooltip;
	var Button = wp.components.Button;
	var TextControl = wp.components.TextControl;
	//var UnitControl = wp.components.__experimentalUnitControl;
	var SelectControl = wp.components.SelectControl;
	var RangeControl = wp.components.RangeControl;
	var ToggleControl = wp.components.ToggleControl;
	var Dashicon = wp.components.Dashicon;
	var ColorPalette = wp.blockEditor.ColorPalette;

	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/container', {
		title: 'Container',
		description: __( 'A styled container that allows inner blocks.', 'bne' ),
		icon: 'archive',
		category: 'bne-blocks',
		attributes: {
			blockDiv: {
				type: 'string',
				default: 'section'
			},
			textColor: {
				type: 'string',
				default: 'default'
			},
			blockSplit: {
				type: 'string',
				default: null
			},
			blockPaddingTop: {
				type: 'number',
				default: 60
			},
			blockPaddingBottom: {
				type: 'number',
				default: 60
			},
			blockMobilePaddingTop: {
				type: 'number',
				default: 30
			},
			blockMobilePaddingBottom: {
				type: 'number',
				default: 30
			},
			blockPaddingX: {
				type: 'boolean',
				default: 0				
			},
			blockMarginX: {
				type: 'boolean',
				default: 0				
			},						
			blockCenterContent: {
				type: 'boolean',
				default: 0				
			},						
			blockMaxHeight: {
				type: 'boolean',
				default: 0				
			},						
			// blockMinimumHeight: {
			// 	trype: 'number',
			// 	default: 100
			// },
			// blockMinimumHeightUnit: {
			// 	type: 'string',
			// 	default: 'px'
			// },
			backgroundColor: {
				type: 'string',
			},
			backgroundImageID: {
				type: 'number',
			},
			backgroundImageURL: {
				type: 'string',
				source: 'attribute',
				selector: 'img',
				attribute: 'src',
			},
			backgroundImageAlt: {
				type: 'string',
				default: '',
			},
			backgroundImageAltCustom: {
				type: 'string',
			},
			backgroundImageFixed: {
				type: 'boolean',
				default: 0				
			},
			backgroundImagePosition: {
				type: 'string',
				default: 'center center'
			},
			backgroundImageSize: {
				type: 'string',
				default: 'cover'
			},
			backgroundImageRepeat: {
				type: 'string',
				default: 'no-repeat'
			},
			backgroundVideo: {
				type: 'string',
			},
			backgroundVideoYouTube: {
				type: 'string',
			},
			backgroundVideoVimeo: {
				type: 'string',
			},
			backgroundVideoMobile: {
				type: 'boolean',
				default: 0				
			},
			overlayColor: {
				type: 'string',
			},
			overlayOpacity: {
				type: 'number',
				default: 20
			}
		},
		supports: {
			align: ['wide','full'],
			anchor: true,
			html: false
		},
		
		// Add attribute to wrapping block div in the editor
		getEditWrapperProps( props ) {
			console.log(props);
			return {
				'data-maxHeight': props.blockMaxHeight,
			};
		},
		
		
				
		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			console.log(attributes);
		 
			var blockDiv = attributes.blockDiv ? attributes.blockDiv : 'section';

			// Block Classes
			var blockClasses =
				(attributes.textColor ? 'text-'+attributes.textColor : 'text-default')
				+ (attributes.blockSplit ? ' has-'+attributes.blockSplit+'-bg' : '' )
				+ (attributes.backgroundColor ? ' has-bg-color' : '')
				+ (attributes.backgroundImageURL ? ' has-bg-image' : '')
				+ (attributes.backgroundVideo ? ' has-bg-video' : '')
				+ (attributes.backgroundVideoYouTube ? ' has-bg-video has-bg-youtube' : '')
				+ (attributes.backgroundVideoVimeo ? ' has-bg-video has-bg-vimeo' : '')
				+ (attributes.backgroundVideoMobile ? ' has-bg-mobile-video' : '')
				+ (attributes.overlayColor ? ' has-bg-overlay' : '') 
				+ ( attributes.blockPaddingX ? ' has-padding-x' : '')
				+ (( attributes.blockMobilePaddingTop || attributes.blockMobilePaddingBottom ) ? ' has-mobile-padding' : '')
				+ ( attributes.blockMarginX ? ' has-no-margin' : '')
				+ ( attributes.blockCenterContent ? ' has-center-alignment' : '')
				+ ( attributes.blockMaxHeight ? ' has-full-height' : '')
			; 
						
			// Return Output
			// ========================== //
			  return [
				  
				  // Block Controls
				  el( BlockControls, { key: 'controls' },
					  el( BlockAlignmentToolbar, {
							  controls: [ 'left', 'right' ],
							  isCollapsed: false,
							  value: attributes.blockSplit,
							  onChange: function( newBlockSplit ) {
								props.setAttributes( { blockSplit: newBlockSplit } );
							},
						 }
					 ),
					 
				), // End Block Controls

				
				// Panel Controls
				el( InspectorControls, {},

					 // General Panel
					 el( PanelBody, {
							title: __( 'Container Settings', 'bne' ),
							initialOpen: true,
						},
						el( SelectControl, {
								value: attributes.textColor,
								label: __('Text Color'),
								onChange: function( newTextColor ) {
									props.setAttributes( { textColor: newTextColor } );
								},
								options: [
									{ value: 'default', label: __( 'Default text color', 'bne' ) },
									{ value: 'light', label: __( 'Force light text color', 'bne' ) },
									{ value: 'dark', label: __( 'Force dark text color', 'bne' ) },
								]
							} 
						),
						el( SelectControl, {
								value: attributes.blockDiv,
								label: __('HTML Attribute'),
								onChange: function( newBlockDiv ) {
									props.setAttributes( { blockDiv: newBlockDiv } );
								},
								options: [
									{ value: 'section', label: __( 'Section', 'bne' ) },
									{ value: 'div', label: __( 'Div' ) },
									{ value: 'aside', label: __( 'Aside' ) },
								]
							} 
						),
						el( RangeControl, {
								label: __( 'Padding Top (desktop)', 'bne' ),
								value: attributes.blockPaddingTop,
								onChange: function( newBlockPaddingTop ) {
									props.setAttributes( { blockPaddingTop: newBlockPaddingTop } );
								},
								min: 0,
								max: 500,
								step: 1
							}
						),
						el( RangeControl, {
								label: __( 'Padding Bottom (desktop)', 'bne' ),
								value: attributes.blockPaddingBottom,
								onChange: function( newBlockPaddingBottom ) {
									props.setAttributes( { blockPaddingBottom: newBlockPaddingBottom } );
								},
								min: 0,
								max: 500,
								step: 1
							}
						),
						el( RangeControl, {
								label: __( 'Padding Top (mobile)', 'bne' ),
								value: attributes.blockMobilePaddingTop,
								onChange: function( newBlockMobilePaddingTop ) {
									props.setAttributes( { blockMobilePaddingTop: newBlockMobilePaddingTop } );
								},
								min: 0,
								max: 500,
								step: 1
							}
						),
						el( RangeControl, {
								label: __( 'Padding Bottom (mobile)', 'bne' ),
								value: attributes.blockMobilePaddingBottom,
								onChange: function( newBlockMobilePaddingBottom ) {
									props.setAttributes( { blockMobilePaddingBottom: newBlockMobilePaddingBottom } );
								},
								min: 0,
								max: 500,
								step: 1
							}
						),
						el( ToggleControl, {
								label: __( 'Add additional left and right padding', 'bne' ),
								checked: !!attributes.blockPaddingX,
								onChange: function( newBlockPaddingX ) {
									props.setAttributes( { blockPaddingX: newBlockPaddingX } );
								},
								help: __( 'Adds spacing around the content when the container has a background color or image.', 'bne' )
							} 
						),
						
						el( ToggleControl, {
								label: __( 'Remove top & bottom margin', 'bne' ),
								checked: !!attributes.blockMarginX,
								onChange: function( newBlockMarginX ) {
									props.setAttributes( { blockMarginX: newBlockMarginX } );
								},
								help: __( 'Useful when you want to align multiple containers within a column layout.', 'bne' )
							} 
						),
						
						el( ToggleControl, {
								label: __( 'Vertically align content', 'bne' ),
								checked: !!attributes.blockCenterContent,
								onChange: function( newBlockCenterContent ) {
									props.setAttributes( { blockCenterContent: newBlockCenterContent } );
								},
								help: __( 'Vertically centers the content within the container instead of the default top position.', 'bne' )
							} 
						),

						el( ToggleControl, {
								label: __( 'Use Max Height', 'bne' ),
								checked: !!attributes.blockMaxHeight,
								onChange: function( newBlockMaxHeight ) {
									props.setAttributes( { blockMaxHeight: newBlockMaxHeight } );
								},
								help: __( 'Positions the container\'s height to be 100vh (100% height of the browser window) or 100% available height when used within a column.', 'bne' )
							} 
						),
						
					), // end PanelBody


					// Background Panel
					 el( PanelBody, {
							title: __( 'Background', 'bne' ),
							initialOpen: true,
						},

						// Background Color
						el('p', {}, __( 'Background Color', 'bne' ) ),
						el( ColorPalette, {
								value: attributes.backgroundColor,
								onChange: function( newBackgroundColor ) {
									props.setAttributes( { backgroundColor: newBackgroundColor } );
								},
							},
						),

						// Background Image
						el('hr'),
						el('p', { style: { margin: '10px 0' }}, __( 'Background Image', 'bne' ) ),
						el( MediaUpload, {
							onSelect: function( media ) {
									props.setAttributes( { 
										backgroundImageURL: media.url,
										backgroundImageID: media.id,
										backgroundImageAlt: media.alt
									} );
							},
							allowedTypes: 'image',
							value: attributes.backgroundImageURL,
							render: function( media ) {
								return (
									!attributes.backgroundImageURL 
									? (
										el( Button, {
												className: attributes.backgroundImageURL ? 'image-button' : 'button button-large',
												style: { margin: '0' },
												onClick: media.open
											},
											el( 'span', { 
													className: 'dashicons dashicons-format-image', width: '20', height: '20',
													style: { margin: '3px 5px 0 0' },
												}
											),
											__( 'Upload Image', 'bne' )
										)
									) : (
										el( 'div', {
												className: 'components-base-control',
											},
										
											el( 'a', {
													href: '#',
													onClick: media.open
												},
												el( 'img', { 
													src: attributes.backgroundImageURL 
												} ),
											),
											el('p', { style: { fontStyle: 'italic' } }, __( 'Click the image to edit or update', 'bne' ) ),
											el( 'a', {
													className: 'components-button is-secondary is-small',
													href: '#',
													onClick: function() {
														props.setAttributes( { 
															backgroundImageURL: '',
															backgroundImageID: '',
															backgroundImageAlt: '',
														} );
													},
												},
												__( 'Remove Image', 'bne' )
											),
											el( 'div', { style: { height: '20px'} } ),
											el( TextControl, {
													label: __( 'Alt Text (Alternative Text)', 'bne' ),
													value: attributes.backgroundImageAltCustom,
													onChange: function( newBackgroundImageAltCustom ) {
														props.setAttributes( { backgroundImageAltCustom: newBackgroundImageAltCustom } );
													},
													help: __( 'Leave empty if the image is purely decorative or to use the default alt text.', 'bne' )
												} 
											)
										) // end div
									) // end if/else
								)// end Return
							}// end Render
						} ), // end MediaUpload
						

						// BG Properties
						attributes.backgroundImageURL && 
						el('div', {},
							el( ToggleControl, {
									label: __( 'Fixed Background', 'bne' ),
									checked: !!attributes.backgroundImageFixed,
									onChange: function( newBackgroundImageFixed ) {
										props.setAttributes( { backgroundImageFixed: newBackgroundImageFixed } );
									}
								} 
							),
							el( SelectControl, {
									value: attributes.backgroundImagePosition,
									label: __( 'Background Position', 'bne' ),
									onChange: function( newBackgroundImagePosition ) {
										props.setAttributes( { backgroundImagePosition: newBackgroundImagePosition } );
									},
									options: [
										{ value: 'left top', label: __( 'Left Top', 'bne' ) },
										{ value: 'left center', label: __( 'Left Center', 'bne' ) },
										{ value: 'left bottom', label: __( 'Left Bottom', 'bne' ) },
										{ value: 'right top', label: __( 'Right Top', 'bne' ) },
										{ value: 'right center', label: __( 'Right Center', 'bne' ) },
										{ value: 'right bottom', label: __( 'Right Bottom' ) },
										{ value: 'center top', label: __( 'Center Top', 'bne' ) },
										{ value: 'center center', label: __( 'Center Center', 'bne' ) },
										{ value: 'center bottom', label: __( 'Center Bottom', 'bne' ) },
									]
								} 
							),
							el( SelectControl, {
									value: attributes.backgroundImageRepeat,
									label: __('Background Repeat'),
									onChange: function( newBackgroundImageRepeat ) {
										props.setAttributes( { backgroundImageRepeat: newBackgroundImageRepeat } );
									},
									options: [
										{ value: 'no-repeat', label: __( 'No Repeat', 'bne' ) },
										{ value: 'repeat', label: __( 'Repeat Horizontally and Vertically', 'bne' ) },
										{ value: 'repeat-x', label: __( 'Repeat Horizontally', 'bne' ) },
										{ value: 'repeat-y', label: __( 'Repeat Vertically', 'bne' ) },
									]
								} 
							), // end bg size
							el( SelectControl, {
									value: attributes.backgroundImageSize,
									label: __('Background Size'),
									onChange: function( newBackgroundImageSize ) {
										props.setAttributes( { backgroundImageSize: newBackgroundImageSize } );
									},
									options: [
										{ value: 'auto', label: __( 'Auto', 'bne' ) },
										{ value: 'cover', label: __( 'Cover', 'bne' ) },
										{ value: 'contain', label: __( 'Contain', 'bne' ) },
										{ value: '100% 100%', label: __( '100% x 100%', 'bne' ) },
										{ value: '100% auto', label: __( 'Fit Horizontally', 'bne' ) },
										{ value: 'auto 100%', label: __( 'Fit Vertically', 'bne' ) },
									]
								} 
							), // end bg size
						), // end div


						// Background Video
						el('hr'),
						el('p', { style: { margin: '10px 0' }}, __( 'Background Video', 'bne' ) ),
						el( MediaUpload, {
							onSelect: function( media ) {
									props.setAttributes( { 
										backgroundVideo: media.url,
									} );
							},
							allowedTypes: 'video',
							type: 'video',
							value: attributes.backgroundVideo,
							render: function( media ) {
								return (
									!attributes.backgroundVideo 
									? (
										el( Button, {
												className: attributes.backgroundVideo ? 'image-button' : 'button button-large',
												style: { margin: '0' },
												onClick: media.open
											},
											el( 'span', { 
													className: 'dashicons dashicons-format-video', width: '20', height: '20',
													style: { margin: '3px 5px 0 0' },
												}
											),
											__( 'Upload mp4 Video' )
										)
									) : (
										el( 'div', {
												className: 'components-base-control',
											},
											
											el( 'div', { className: 'video-wrapper' },
												el( 'video', {
														className: 'video-container',
													},
													el( 'source', { 
														type: 'video/mp4',
														src: attributes.backgroundVideo
													} )
												),
											),
											el( 'a', {
													classNmae: 'components-button is-secondary is-small',
													href: '#',
													onClick: function() {
														props.setAttributes( { 
															backgroundVideo: '',
														} );
													},
												},
												__( 'Remove Video', 'bne' ),
											) // end a
										)// end div
									) // end if/else
								)// end Return
							}// end Render
						} ), // end MediaUpload
					
						el( 'div', { style: { height: '20px'} } ),
						// YouTube
						el( TextControl, {
								label: __( 'YouTube Video ID', 'bne' ),
								value: attributes.backgroundVideoYouTube,
								onChange: function( newBackgroundVideoYouTube ) {
									props.setAttributes( { backgroundVideoYouTube: newBackgroundVideoYouTube } );
								}
							} 
						),

						// Vimeo
						el( TextControl, {
								label: __( 'Vimeo Video ID', 'bne' ),
								value: attributes.backgroundVideoVimeo,
								onChange: function( newBackgroundVideoVimeo ) {
									props.setAttributes( { backgroundVideoVimeo: newBackgroundVideoVimeo } );
								}
							} 
						),
					
						( (attributes.backgroundImageURL || attributes.backgroundVideo || attributes.backgroundVideoYouTube || attributes.backgroundVideoVimeo )
						?	el( 'div', {},
								el( ToggleControl, {
										label: __( 'Enable Video on Mobile', 'bne' ),
										checked: !!attributes.backgroundVideoMobile,
										onChange: function( newBackgroundVideoMobile ) {
											props.setAttributes( { backgroundVideoMobile: newBackgroundVideoMobile } );
										},
										help: 'When video playback is disabled on mobile, the background image can be used instead.'
									} 
								)
							)
						: '' )

					), // end PanelBody
					
					
					// Overlay Panel
					el( PanelBody, {
							title: __( 'Overlay', 'bne' ),
							initialOpen: false,
						},
						el('p', {}, __( 'Overlay Color', 'bne') ),
						el( ColorPalette, {
								value: attributes.overlayColor,
								onChange: function( newOverlayColor ) {
									props.setAttributes( { overlayColor: newOverlayColor } );
								},
							},
						),
						el( RangeControl, {
								label: __( 'Overlay Opacity', 'bne' ),
								value: attributes.overlayOpacity,
								onChange: function( newOverlayOpacity ) {
									props.setAttributes( { overlayOpacity: newOverlayOpacity } );
								},
								min: 0,
								max: 100,
								step: 10
							}
						)
					)


				), // End InspectorControls
				
				

				// Editor
				// ========================== //
				el( blockDiv, {
						className: props.className + ' bne-container ' +blockClasses, 
						isSelected: true,
						style: {
							backgroundColor: attributes.backgroundColor,
							// @note Using a 0?1 as the editor has a visual 
							// issue when padding is 0 with surrounding blocks.
							'--padding-top': ( attributes.blockPaddingTop == 0 ? 1 : attributes.blockPaddingTop)+'px',
							'--padding-bottom': ( attributes.blockPaddingBottom == 0 ? 1 : attributes.blockPaddingBottom)+'px',
							
							'--mobile-padding-top': attributes.blockMobilePaddingTop+'px',
							'--mobile-padding-bottom': attributes.blockMobilePaddingBottom+'px'
						}
					},

					// Background Image
					attributes.backgroundImageURL &&
						el( 'figure', {
								className: 'bne-container-image' + ( attributes.backgroundImageFixed ? ' image-has-parallax' : '' ),
								style: {
									backgroundRepeat: 'no-repeat',
									backgroundImage: 'url('+attributes.backgroundImageURL+')',
									backgroundPosition: attributes.backgroundImagePosition,
									backgroundSize: attributes.backgroundImageSize,
									backgroundRepeat: attributes.backgroundImageRepeat
								},

							},
							
							// BG Image
							el('img', {
								src: attributes.backgroundImageURL,
								alt: attributes.backgroundImageAltCustom ? attributes.backgroundImageAltCustom : attributes.backgroundImageAlt,
								className: 'wp-image-'+attributes.backgroundImageID
							} )
						),
					

					// Background Video
					( attributes.backgroundVideo || attributes.backgroundVideoYouTube || attributes.backgroundVideoVimeo )
					?	el( 'figure', { className: 'bne-container-video wp-block-video video-wrapper' },
			
							// Mp4
							attributes.backgroundVideo &&
								el( 'video', {
										className: 'video-container',
									},
									el( 'source', { 
										type: 'video/mp4',
										src: attributes.backgroundVideo
									} )
								),
							
							// YouTube
							attributes.backgroundVideoYouTube &&
								el( 'iframe', {
									id: 'youtube-embed-id-'+attributes.backgroundVideoYouTube,
									className: 'video-container',
									src: 'https://www.youtube.com/embed/'+attributes.backgroundVideoYouTube+'?&amp;playlist='+attributes.backgroundVideoYouTube+'&amp;rel=0&amp;autoplay=0&amp;loop=1&amp;mute=1&amp;controls=0&amp;modestbranding=1',
									frameborder: 0,
								},
							),

							// Vimeo
							attributes.backgroundVideoVimeo &&
								el( 'iframe', {
									id: 'vimeo-embed-id-'+attributes.backgroundVideoVimeo,
									className: 'video-container',
									src: 'https://player.vimeo.com/video/'+attributes.backgroundVideoVimeo+'?autoplay=0&amp;loop=1&amp;title=0&amp;byline=0&amp;portrait=0&amp;muted=1&amp;controls=0',
									frameborder: 0,
								},
							),

						) // end div.bne-container-video
					:	'', 
					// END background video conditional


					//Overlay
					attributes.overlayColor &&
						el( 'div', {
								className: 'bne-container-overlay',
								style: { 
									opacity: attributes.overlayOpacity / 100,
									backgroundColor: attributes.overlayColor
								}
						} ),

					// Content
					el( 'div', {
							className: 'bne-container-content content-area-width'
						},
						
						// Workaround logic for this bug https://github.com/WordPress/gutenberg/issues/9897
						// Happens when applying a style option with a block that has innerblocks
						// When fixed, remove the condition
						( 'undefined' !== typeof props.insertBlocksAfter ) 
							? (	el( InnerBlocks, {
										template: [
											[ 'core/paragraph']
										],
										templateLock: false,
										templateInsertUpdatesSelection: false
									} 
								) 
							) : (
								el( 'div' )
							)
					
					), // End div.bne-container-content
				) // End div.bne-container
			]; // End return
		}, // End edit
	
		

		// ========================== //
		// Front Save/View
		// ========================== //
		save: function (props) {
			//console.log(props);
			var attributes = props.attributes;
			var blockDiv = attributes.blockDiv ? attributes.blockDiv : 'section';
			
			// Block Classes
			var blockClasses =
				(attributes.textColor ? 'text-'+attributes.textColor : 'text-default')
				+ (attributes.blockSplit ? ' has-'+attributes.blockSplit+'-bg' : '' )
				+ (attributes.backgroundColor ? ' has-bg-color' : '')
				+ (attributes.backgroundImageURL ? ' has-bg-image' : '')
				+ (attributes.backgroundVideo ? ' has-bg-video' : '')
				+ (attributes.backgroundVideoYouTube ? ' has-bg-video has-bg-youtube' : '')
				+ (attributes.backgroundVideoVimeo ? ' has-bg-video has-bg-vimeo' : '')
				+ (attributes.backgroundVideoMobile ? ' has-bg-mobile-video' : '')
				+ (attributes.overlayColor ? ' has-bg-overlay' : '')
				+ ( attributes.blockPaddingX ? ' has-padding-x' : '')
				+ (( attributes.blockMobilePaddingTop || attributes.blockMobilePaddingBottom ) ? ' has-mobile-padding' : '')
				+ ( attributes.blockMarginX ? ' has-no-margin' : '')
				+ ( attributes.blockCenterContent ? ' has-center-alignment' : '')
				+ ( attributes.blockMaxHeight ? ' has-full-height' : '')
			; 

			
			// Return Output
			// ========================== //
			return (
				el( blockDiv, {
						className: 'bne-container ' +blockClasses,
						style: {
							backgroundColor: attributes.backgroundColor,
							'--padding-top': attributes.blockPaddingTop+'px',
							'--padding-bottom': attributes.blockPaddingBottom+'px',
							'--mobile-padding-top': attributes.blockMobilePaddingTop+'px',
							'--mobile-padding-bottom': attributes.blockMobilePaddingBottom+'px'
						}
					},
					

					// Background Image
					attributes.backgroundImageURL &&
						el( 'figure', {
								className: 'bne-container-image' + ( attributes.backgroundImageFixed ? ' image-has-parallax' : '' ),
								style: {
									backgroundRepeat: 'no-repeat',
									backgroundImage: 'url('+attributes.backgroundImageURL+')',
									backgroundPosition: attributes.backgroundImagePosition,
									backgroundSize: attributes.backgroundImageSize,
									backgroundRepeat: attributes.backgroundImageRepeat
								},

							},

							// BG Image
							el('img', {
								src: attributes.backgroundImageURL,
								alt: attributes.backgroundImageAltCustom ? attributes.backgroundImageAltCustom : attributes.backgroundImageAlt,
								className: 'wp-image-'+attributes.backgroundImageID
							} )
						),
					

					// Background Video
					( attributes.backgroundVideo || attributes.backgroundVideoYouTube || attributes.backgroundVideoVimeo )
					?	el( 'figure', { className: 'bne-container-video wp-block-video video-wrapper' },
			
							// MP4
							attributes.backgroundVideo &&
								el( 'video', {
										className: 'video-container',
										preload: 'auto',
										autoplay: 'true',
										loop: 'true',
										muted: 'true',
										playsinline: ''
									},
									el( 'source', { 
										type: 'video/mp4',
										src: attributes.backgroundVideo
									} )
								),

							// YouTube
							attributes.backgroundVideoYouTube &&
								el( 'iframe', {
									className: 'video-container',
									id: 'youtube-embed-id-'+attributes.backgroundVideoYouTube,
									src: 'https://www.youtube.com/embed/'+attributes.backgroundVideoYouTube+'?&amp;playlist='+attributes.backgroundVideoYouTube+'&amp;rel=0&amp;autoplay=1&amp;loop=1&amp;mute=1&amp;controls=0&amp;modestbranding=1',
									frameborder: 0,
								},
							),

							// Vimeo
							attributes.backgroundVideoVimeo &&
								el( 'iframe', {
									id: 'vimeo-embed-id-'+attributes.backgroundVideoVimeo,
									className: 'video-container',
									src: 'https://player.vimeo.com/video/'+attributes.backgroundVideoVimeo+'?autoplay=1&amp;loop=1&amp;title=0&amp;byline=0&amp;portrait=0&amp;muted=1&amp;controls=0',
									frameborder: 0,
								},
							),

						) // end div.bne-container-video
					:	'',
					// END background video conditional

					//Overlay
					attributes.overlayColor &&
						el( 'div', {
								className: 'bne-container-overlay',
								style: { 
									opacity: attributes.overlayOpacity / 100,
									backgroundColor: attributes.overlayColor
								}
						} ),


					// Content
					el( 'div', {
							className: 'bne-container-content content-area-width'
						}, 
						
						el( InnerBlocks.Content, {} ),
					
					), // End .bne-container-content

				) // End .bne-container
			) // End return
		}, // End save

		
		
		// ========================== //
		// DEPRECATED BLOCKS
		// ========================== //
		deprecated: [

			// @depreciated @v2.2.10
			// Replaced with added margin class and full height class
			{
				attributes:{blockDiv:{type:'string',default:'section'},textColor:{type:'string',default:'default'},blockSplit:{type:'string',default:null},blockPaddingTop:{type:'number',default:80},blockPaddingBottom:{type:'number',default:80},blockMobilePaddingTop:{type:'number',default:30},blockMobilePaddingBottom:{type:'number',default:30},blockPaddingX:{type:'boolean',default:0},backgroundColor:{type:'string',},backgroundImageID:{type:'number',},backgroundImageURL:{type:'string',source:'attribute',selector:'img',attribute:'src',},backgroundImageAlt:{type:'string',default:'',},backgroundImageAltCustom:{type:'string',},backgroundImageFixed:{type:'boolean',default:0},backgroundImagePosition:{type:'string',default:'center center'},backgroundImageSize:{type:'string',default:'cover'},backgroundImageRepeat:{type:'string',default:'repeat'},backgroundVideo:{type:'string',},backgroundVideoYouTube:{type:'string',},backgroundVideoVimeo:{type:'string',},backgroundVideoMobile:{type:'boolean',default:0},overlayColor:{type:'string',},overlayOpacity:{type:'number',default:20}},save:function(props){var attributes=props.attributes;var blockDiv=attributes.blockDiv?attributes.blockDiv:'section';var blockClasses=(attributes.textColor?'text-'+attributes.textColor:'text-default')+(attributes.blockSplit?' has-'+attributes.blockSplit+'-bg':'')+(attributes.backgroundColor?' has-bg-color':'')+(attributes.backgroundImageURL?' has-bg-image':'')+(attributes.backgroundVideo?' has-bg-video':'')+(attributes.backgroundVideoYouTube?' has-bg-video has-bg-youtube':'')+(attributes.backgroundVideoVimeo?' has-bg-video has-bg-vimeo':'')+(attributes.backgroundVideoMobile?' has-bg-mobile-video':'')+(attributes.overlayColor?' has-bg-overlay':'')+(attributes.blockPaddingX?' has-padding-x':'')+((attributes.blockMobilePaddingTop||attributes.blockMobilePaddingBottom)?' has-mobile-padding':'');return(el(blockDiv,{className:'bne-container '+blockClasses,style:{backgroundColor:attributes.backgroundColor,'--padding-top':attributes.blockPaddingTop+'px','--padding-bottom':attributes.blockPaddingBottom+'px','--mobile-padding-top':attributes.blockMobilePaddingTop+'px','--mobile-padding-bottom':attributes.blockMobilePaddingBottom+'px'}},attributes.backgroundImageURL&&el('figure',{className:'bne-container-image'+(attributes.backgroundImageFixed?' image-has-parallax':''),style:{backgroundRepeat:'no-repeat',backgroundImage:'url('+attributes.backgroundImageURL+')',backgroundPosition:attributes.backgroundImagePosition,backgroundSize:attributes.backgroundImageSize,backgroundRepeat:attributes.backgroundImageRepeat},},el('img',{src:attributes.backgroundImageURL,alt:attributes.backgroundImageAltCustom?attributes.backgroundImageAltCustom:attributes.backgroundImageAlt,className:'wp-image-'+attributes.backgroundImageID})),(attributes.backgroundVideo||attributes.backgroundVideoYouTube||attributes.backgroundVideoVimeo)?el('figure',{className:'bne-container-video wp-block-video video-wrapper'},attributes.backgroundVideo&&el('video',{className:'video-container',preload:'auto',autoplay:'true',loop:'true',muted:'true',playsinline:''},el('source',{type:'video/mp4',src:attributes.backgroundVideo})),attributes.backgroundVideoYouTube&&el('iframe',{className:'video-container',id:'youtube-embed-id-'+attributes.backgroundVideoYouTube,src:'https://www.youtube.com/embed/'+attributes.backgroundVideoYouTube+'?&amp;playlist='+attributes.backgroundVideoYouTube+'&amp;rel=0&amp;autoplay=1&amp;loop=1&amp;mute=1&amp;controls=0&amp;modestbranding=1',frameborder:0,},),attributes.backgroundVideoVimeo&&el('iframe',{id:'vimeo-embed-id-'+attributes.backgroundVideoVimeo,className:'video-container',src:'https://player.vimeo.com/video/'+attributes.backgroundVideoVimeo+'?autoplay=1&amp;loop=1&amp;title=0&amp;byline=0&amp;portrait=0&amp;muted=1&amp;controls=0',frameborder:0,},),):'',attributes.overlayColor&&el('div',{className:'bne-container-overlay',style:{opacity:attributes.overlayOpacity/100,backgroundColor:attributes.overlayColor}}),el('div',{className:'bne-container-content content-area-width'},el(InnerBlocks.Content,{}),),))}
			},
		
			// @depreciated @v2.2.3
			// Replaced with padding top/bottom mobile options		
			{
				attributes:{blockDiv:{type:'string',default:'section'},textColor:{type:'string',default:'default'},blockSplit:{type:'string',default:null},blockPaddingTop:{type:'number',default:80},blockPaddingBottom:{type:'number',default:80},blockMobilePaddingTop:{type:'number',default:30},blockMobilePaddingBottom:{type:'number',default:30},blockPaddingX:{type:'boolean',default:0},backgroundColor:{type:'string',},backgroundImageID:{type:'number',},backgroundImageURL:{type:'string',source:'attribute',selector:'img',attribute:'src',},backgroundImageAlt:{type:'string',default:'',},backgroundImageAltCustom:{type:'string',},backgroundImageFixed:{type:'boolean',default:0},backgroundImagePosition:{type:'string',default:'center center'},backgroundImageSize:{type:'string',default:'cover'},backgroundVideo:{type:'string',},backgroundVideoYouTube:{type:'string',},backgroundVideoVimeo:{type:'string',},backgroundVideoMobile:{type:'boolean',default:0},overlayColor:{type:'string',},overlayOpacity:{type:'number',default:20}},supports:{align:['wide','full'],anchor:!0,html:!1},save:function(props){var attributes=props.attributes;var blockDiv=attributes.blockDiv?attributes.blockDiv:'section';var blockClasses=(attributes.textColor?'text-'+attributes.textColor:'text-default')+(attributes.blockSplit?' has-'+attributes.blockSplit+'-bg':'')+(attributes.backgroundColor?' has-bg-color':'')+(attributes.backgroundImageURL?' has-bg-image':'')+(attributes.backgroundVideo?' has-bg-video':'')+(attributes.backgroundVideoYouTube?' has-bg-video has-bg-youtube':'')+(attributes.backgroundVideoVimeo?' has-bg-video has-bg-vimeo':'')+(attributes.backgroundVideoMobile?' has-bg-mobile-video':'')+(attributes.overlayColor?' has-bg-overlay':'')+(attributes.blockPaddingX?' has-padding-x':'')+((attributes.blockMobilePaddingTop||attributes.blockMobilePaddingBottom)?' has-mobile-padding':'');var blockBackgroundImage=attributes.backgroundImageURL?el('img',{src:attributes.backgroundImageURL,alt:attributes.backgroundImageAltCustom?attributes.backgroundImageAltCustom:attributes.backgroundImageAlt,className:'wp-image-'+attributes.backgroundImageID},):null;return(el(blockDiv,{className:'bne-container '+blockClasses,style:{backgroundColor:attributes.backgroundColor,'--padding-top':attributes.blockPaddingTop+'px','--padding-bottom':attributes.blockPaddingBottom+'px','--mobile-padding-top':attributes.blockMobilePaddingTop+'px','--mobile-padding-bottom':attributes.blockMobilePaddingBottom+'px'}},attributes.backgroundImageURL&&el('figure',{className:'bne-container-image'+(attributes.backgroundImageFixed?' image-has-parallax':''),style:{backgroundRepeat:'no-repeat',backgroundImage:'url('+attributes.backgroundImageURL+')',backgroundPosition:(attributes.backgroundImagePosition?attributes.backgroundImagePosition:''),backgroundSize:(attributes.backgroundImageSize?attributes.backgroundImageSize:'')},},attributes.overlayColor&&el('div',{className:'bne-container-overlay',style:{opacity:attributes.overlayOpacity/100,backgroundColor:attributes.overlayColor}}),blockBackgroundImage),(attributes.backgroundVideo||attributes.backgroundVideoYouTube||attributes.backgroundVideoVimeo)?el('figure',{className:'bne-container-video wp-block-video video-wrapper'},attributes.overlayColor&&el('div',{className:'bne-container-overlay',style:{opacity:attributes.overlayOpacity/100,backgroundColor:attributes.overlayColor}}),attributes.backgroundVideo&&el('video',{className:'video-container',preload:'auto',autoplay:'true',loop:'true',muted:'true',playsinline:''},el('source',{type:'video/mp4',src:attributes.backgroundVideo})),attributes.backgroundVideoYouTube&&el('iframe',{className:'video-container',id:'youtube-embed-id-'+attributes.backgroundVideoYouTube,src:'https://www.youtube.com/embed/'+attributes.backgroundVideoYouTube+'?&amp;playlist='+attributes.backgroundVideoYouTube+'&amp;rel=0&amp;autoplay=1&amp;loop=1&amp;mute=1&amp;controls=0&amp;modestbranding=1',frameborder:0,},),attributes.backgroundVideoVimeo&&el('iframe',{id:'vimeo-embed-id-'+attributes.backgroundVideoVimeo,className:'video-container',src:'https://player.vimeo.com/video/'+attributes.backgroundVideoVimeo+'?autoplay=1&amp;loop=1&amp;title=0&amp;byline=0&amp;portrait=0&amp;muted=1&amp;controls=0',frameborder:0,},),):'',el('div',{className:'bne-container-content content-area-width'},el(InnerBlocks.Content,{}),),))}				
			},	
					
			// @depreciated @v2.2
			// Original block
			{
				attributes:{blockDiv:{type:'string',default:'section'},textColor:{type:'string',default:'default'},blockSplit:{type:'string',default:null},blockPaddingTop:{type:'number',default:80},blockPaddingBottom:{type:'number',default:80},blockMobilePaddingTop:{type:'number',default:30},blockMobilePaddingBottom:{type:'number',default:30},backgroundColor:{type:'string',},backgroundImageID:{type:'number',},backgroundImageURL:{type:'string',source:'attribute',selector:'img',attribute:'src',},backgroundImageAlt:{type:'string',default:'',},backgroundImageAltCustom:{type:'string',},backgroundImageFixed:{type:'boolean',default:0},backgroundImagePosition:{type:'string',default:'center center'},backgroundImageSize:{type:'string',default:'cover'},backgroundVideo:{type:'string',},backgroundVideoYouTube:{type:'string',},backgroundVideoVimeo:{type:'string',},backgroundVideoMobile:{type:'boolean',default:0},overlayColor:{type:'string',},overlayOpacity:{type:'number',default:20}},supports:{align:['wide','full'],anchor:!0,},save:function(props){var attributes=props.attributes;var blockDiv=attributes.blockDiv?attributes.blockDiv:'section';var blockClasses=(attributes.textColor?'text-'+attributes.textColor:'text-default')+(attributes.blockSplit?' has-'+attributes.blockSplit+'-bg':'')+(attributes.backgroundColor?' has-bg-color':'')+(attributes.backgroundImageURL?' has-bg-image':'')+(attributes.backgroundVideo?' has-bg-video':'')+(attributes.backgroundVideoYouTube?' has-bg-video has-bg-youtube':'')+(attributes.backgroundVideoVimeo?' has-bg-video has-bg-vimeo':'')+(attributes.backgroundVideoMobile?' has-bg-mobile-video':'')+(attributes.overlayColor?' has-bg-overlay':'');var blockBackgroundImage=attributes.backgroundImageURL?el('img',{src:attributes.backgroundImageURL,alt:attributes.backgroundImageAltCustom?attributes.backgroundImageAltCustom:attributes.backgroundImageAlt,className:'wp-image-'+attributes.backgroundImageID},):null;return(el(blockDiv,{className:'bne-container '+blockClasses,style:{backgroundColor:attributes.backgroundColor,}},attributes.backgroundImageURL&&el('figure',{className:'bne-container-image'+(attributes.backgroundImageFixed?' image-has-parallax':''),style:{backgroundRepeat:'no-repeat',backgroundImage:'url('+attributes.backgroundImageURL+')',backgroundPosition:(attributes.backgroundImagePosition?attributes.backgroundImagePosition:''),backgroundSize:(attributes.backgroundImageSize?attributes.backgroundImageSize:'')},},attributes.overlayColor&&el('div',{className:'bne-container-overlay',style:{opacity:attributes.overlayOpacity/100,backgroundColor:attributes.overlayColor}}),blockBackgroundImage),(attributes.backgroundVideo||attributes.backgroundVideoYouTube||attributes.backgroundVideoVimeo)?el('figure',{className:'bne-container-video wp-block-video video-wrapper'},attributes.overlayColor&&el('div',{className:'bne-container-overlay',style:{opacity:attributes.overlayOpacity/100,backgroundColor:attributes.overlayColor}}),attributes.backgroundVideo&&el('video',{className:'video-container',preload:'auto',autoplay:'true',loop:'true',muted:'true',playsinline:''},el('source',{type:'video/mp4',src:attributes.backgroundVideo})),attributes.backgroundVideoYouTube&&el('iframe',{className:'video-container',id:'youtube-embed-id-'+attributes.backgroundVideoYouTube,src:'https://www.youtube.com/embed/'+attributes.backgroundVideoYouTube+'?&amp;playlist='+attributes.backgroundVideoYouTube+'&amp;rel=0&amp;autoplay=1&amp;loop=1&amp;mute=1&amp;controls=0&amp;modestbranding=1',frameborder:0,},),attributes.backgroundVideoVimeo&&el('iframe',{id:'vimeo-embed-id-'+attributes.backgroundVideoVimeo,className:'video-container',src:'https://player.vimeo.com/video/'+attributes.backgroundVideoVimeo+'?autoplay=1&amp;loop=1&amp;title=0&amp;byline=0&amp;portrait=0&amp;muted=1&amp;controls=0',frameborder:0,},),):'',el('div',{className:'bne-container-content content-area-width',style:{paddingTop:attributes.blockPaddingTop+'px',paddingBottom:attributes.blockPaddingBottom+'px'}},el(InnerBlocks.Content,{}),),))},			
			}
		
		
		] // END DEPRECATED

	} ); // End registerBlockType
} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);