/*
 * 	BNE Block: Clear
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	April 11, 2020
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var Button = wp.components.Button;
	var Tooltip = wp.components.Tooltip;
	var Dashicon = wp.components.Dashicon;


	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType('bne/clear', {
		title: __( 'Clear', 'bne' ),
		description: __( 'An invisble element that clears any previously floated blocks and resets the row.', 'bne' ),
		icon: 'image-flip-vertical',
		category: 'bne-blocks',
		supports: {
			customClassName: false,
			html: false
		},
		
		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function (props) {
			return (
					el( 'div', { 
							className: 'clear' 
						},
						el( Tooltip, {
								text: __( 'This block clears the float', 'bne' ),
							},
							el( Button, {
									className: 'bne-block-helper-icon',
									onClick: function() {
										props.setAttributes( {
											mediaPosition: attributes.mediaPosition == "top" ? 'bottom' : 'top',
											})
										},
								},
								el( Dashicon, { icon: 'info' } )
							)
						)
					)
			)
		}, // End edit



		// ========================== //
		// Admin Save
		// ========================== //
		save: function (props) {
			return (
				el( 'div', { 
						className: 'clear' 
					},
				)
			)
		} // End save
	} ); // End registerBlockType

} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);