/*
 * 	BNE Block Card
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	July 31, 2020
 *
*/


( function( blocks, components, i18n, element, editor ) {

	// Get Block elements
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var BlockControls = wp.blockEditor.BlockControls;	
	var AlignmentToolbar = wp.blockEditor.AlignmentToolbar;
	var MediaUpload = wp.blockEditor.MediaUpload;
	var MediaPlaceholder = wp.blockEditor.MediaPlaceholder;	
	var InnerBlocks = wp.blockEditor.InnerBlocks;
	var TextControl = wp.components.TextControl;
	var SelectControl = wp.components.SelectControl;
	var Tooltip = wp.components.Tooltip;
	var Button = wp.components.Button;
	var Dashicon = wp.components.Dashicon;
	var PanelBody = wp.components.PanelBody;
	

	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/card', {
		title: 'Card',
		description: __( 'A styled container with an optional image.', 'bne' ),
		icon: 'welcome-widgets-menus',
		category: 'bne-blocks',
		attributes: {
			alignment: {
				type: 'string',
				default: null
			},
       		mediaID: {
  				type: 'number',
  			},
  			mediaURL: {
  				type: 'string',
  				source: 'attribute',
  				selector: 'img',
  				attribute: 'src',
  			},
			mediaAlt: {
				type: 'string',
			},
			mediaAltCustom: {
				type: 'string',
			},
  			mediaPosition: {
	  			type: 'string',
	  			default: 'top',
  			}
		},
		
		styles: [
		    { name: 'shadow-none', 	label: __( 'No Shadow', 'bne' ), isDefault: true },
		    { name: 'shadow-sm', 	label: __( 'Small Shadow', 'bne' ) },
		    { name: 'shadow', 		label: __( 'Regular Shadow', 'bne' ) },
		    { name: 'shadow-lg', 	label: __( 'Larger Shadow', 'bne' ) },
		],		
		
		
		// ========================== //
		// Edit
		// ========================== //
		edit: function( props ) {
			//console.log(props);
			var attributes = props.attributes;

  			return [
	  			
	  			// Block Controls
	  			// ========================== //
  				el( BlockControls, { key: 'controls' }, 
						attributes.mediaURL &&
							el( 'div', { className: 'components-toolbar' },
								el( Tooltip, {
										text: __( 'Flip the image position', 'bne' ),
									},
									el( Button, {
											className: 'components-icon-button components-toolbar__control',
											onClick: function() {
												props.setAttributes( {
													mediaPosition: attributes.mediaPosition == "top" ? 'bottom' : 'top',
	  											})
	  										},
										},
										el( Dashicon, { icon: 'image-flip-vertical' } )
									)
								)
							),
	  					el( AlignmentToolbar, {
		  						value: attributes.alignment,
		  						onChange: function( newAlignment ) {
									props.setAttributes( { alignment: newAlignment } );
								},
	 						}
	 					) 
				), // End Block Controls
				

				// Panel Controls
				// ========================== //
				el( InspectorControls, {},
					el( PanelBody, {								
							title: __( 'Card Image', 'bne' ),
							initialOpen: true,
						},

						// Image
						el( MediaUpload, {
							onSelect: function( media ) {
									props.setAttributes( { 
										mediaURL: media.url,
										mediaID: media.id,
										mediaAlt: media.alt
									} );
							},
							allowedTypes: 'image',
							value: attributes.mediaURL,
							render: function( media ) {
								return (
									!attributes.mediaURL 
									? (
										el( Button, {
												className: attributes.mediaURL ? 'image-button' : 'button button-large',
												style: { margin: '0' },
												onClick: media.open
											},
											el( 'span', { 
													className: 'dashicons dashicons-format-image', width: '20', height: '20',
													style: { margin: '3px 5px 0 0' },
												}
											),
											__( 'Upload Image', 'bne' )
										)
									) : (
										el( 'div', {
												className: 'components-base-control',
											},
										
											el( 'a', {
													href: '#',
													onClick: media.open
												},
												el( 'img', { 
													src: attributes.mediaURL 
												} ),
											),
											el('p', { style: { fontStyle: 'italic' } }, __( 'Click the image to edit or update', 'bne' ) ),
											el( 'a', {
													href: '#',
													onClick: function() {
														props.setAttributes( { 
															mediaURL: '',
															mediaID: '',
															mediaAlt: '',
														} );
													},
												},
												__( 'Remove Image', 'bne' )
											),
											el( 'div', { style: { height: '20px'} } ),
							                el( TextControl, {
													label: __( 'Alt Text (Alternative Text)', 'bne' ),
													value: attributes.mediaAltCustom,
													onChange: function( newMediaAltCustom ) {
														props.setAttributes( { mediaAltCustom: newMediaAltCustom } );
													},
													help: __( 'Leave empty if the image is purely decorative or to use the default alt text.', 'bne' )
								                } 
								            ),
					
											el( SelectControl, {
													value: attributes.mediaPosition,
													label: __( 'Image Position', 'bne' ),
													onChange: function( newMediaPosition ) {
														props.setAttributes( { mediaPosition: newMediaPosition } );
													},
													options: [
														{ value: 'top', label: __( 'Top Position', 'bne' ) },
														{ value: 'bottom', label: __( 'Bottom Position', 'bne' ) }
													]
												} 
											)

										) // end div
									) // end if/else
								)// end Return
							}// end Render
						} ), // end MediaUpload
					), // end PanelBody
				), // End InspectorControls



				// Editor
				// ========================== //
				el( 'div', {
						className: props.className + ' bne-card' + (attributes.alignment ? ' text-'+attributes.alignment : '' ), 
						style: {} 
					},
					
					// Image Placeholder
					!attributes.mediaURL &&
						el( MediaPlaceholder, {
								onSelect: function( media ) {
										props.setAttributes( { 
											mediaURL: media.url,
											mediaID: media.id,
											mediaAlt: media.alt
										} );
								},
								type: 'image',
								accept: 'image/*',
								labels: {
									title: __('Card Image'),
								}
							
						} ),
										
					// Image (top)
					attributes.mediaURL && attributes.mediaPosition === 'top' &&
						el( 'img', {
							className: 'card-img-top', 
							src: attributes.mediaURL,
							alt: attributes.mediaAltCustom ? attributes.mediaAltCustom : attributes.mediaAlt
						} ),
					
					// Body
					el( 'div', { 
							className: 'card-body',
							style: {}
						},
						
						// Workaround logic for this bug https://github.com/WordPress/gutenberg/issues/9897
						// Happens when applying a style option with a block that has innerblocks
						// When fixed, remove the condition
						( 'undefined' !== typeof props.insertBlocksAfter ) ?
							el( InnerBlocks, {
								template: [
									[ 'core/heading'],
									[ 'core/paragraph']
								],
								templateLock: false,
								templateInsertUpdatesSelection: false
							} ) : el( 'div' )
					
					), // end .card-body
					
					// Image (bottom)
					attributes.mediaURL && attributes.mediaPosition == 'bottom' &&
						el( 'img', {
							className: 'card-img-bottom', 
							src: attributes.mediaURL,
							alt: attributes.mediaAltCustom ? attributes.mediaAltCustom : attributes.mediaAlt
						} ),

				) // End div.bne-card
			
			]; // END Return
		
		}, // END edit
	


		// ========================== //
		// Save
		// ========================== //
		save: function (props) {
			//console.log(props.attributes);
			var attributes = props.attributes;
			
			return (
				el( 'div', {
						className: 'bne-card card mb-3' + (attributes.alignment ? ' text-'+attributes.alignment : '' ),
						style: {}
					},
					
					attributes.mediaPosition === 'top' &&
						el( 'img', {
							className: 'card-img-top',
							src: attributes.mediaURL,
							alt: attributes.mediaAltCustom ? attributes.mediaAltCustom : attributes.mediaAlt
						} ),
					
					el( 'div', {
							className: 'card-body',
							style: {}
						},
						el( InnerBlocks.Content, {} ),
						
					), // End .card-body
					
					attributes.mediaPosition === 'bottom' &&
						el( 'img', {
							className: 'card-img-bottom',
							src: attributes.mediaURL,
							alt: attributes.mediaAltCustom ? attributes.mediaAltCustom : attributes.mediaAlt
						} ),
					
				) // End .bne-card
			
			) // End Return
		
		} // End save

	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);