/*
 * 	BNE Block Callout
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	August 1, 2020
 *
*/


( function( blocks, components, i18n, element, editor ) {
	
	// Get Block elements
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var PanelBody = wp.components.PanelBody;
	var PanelRow = wp.components.PanelRow;
	var ToggleControl = wp.components.ToggleControl;
	var InnerBlocks = wp.blockEditor.InnerBlocks;
	var RichText = wp.blockEditor.RichText;
	var ColorPalette = wp.blockEditor.ColorPalette;
	
	
	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/callout', {
		title: __( 'Call To Action', 'bne' ),
		description: __( 'A callout box is similar to an alert box but more structured and styled.', 'bne' ),
		icon: 'megaphone',
		category: 'bne-blocks',
		attributes: {
			calloutHeading: {
				type: 'array',
				source: 'children',
				selector: 'h3',
			},
			calloutMessage: {
				type: 'array',
				source: 'children',
				selector: 'p',
			},
			calloutButton: {
				type: 'boolean',
				default: 1				
			},
			borderColor: {
				type: 'string',
				default: '#f5f5f5'
			}
		},
		supports: {
        	html: false,
		},
		
		
		// ========================== //
		// Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			return [


				// Panel Controls
				// ========================== //
				el( InspectorControls, {},
					el( PanelBody, {								
							title: __( 'Callout Settings', 'bne' ),
							initialOpen: true,
						},
						
						el( ToggleControl, {
							label: __( 'Show Button', 'bne' ),
							checked: !!attributes.calloutButton,
							onChange: function( newCalloutButton ) {
								props.setAttributes( { calloutButton: newCalloutButton } );
							}
						} ),
						
						el('p', {}, __( 'Border Color', 'bne' ) ),
						el( ColorPalette, {
								value: attributes.borderColor,
								onChange: function( newborderColor ) {
									props.setAttributes( { borderColor: newborderColor } );
								},
							}
						),						

					), // end PanelBody
				), // End InspectorControls


				// Editor
				// ========================== //
				el( 'div', {
						className: props.className + ' bne-callout', 
						style: {
							background: attributes.borderColor
						} 
					},
					el( 'div', { 
							className: 'callout-content'
						},
						el( 'div', { 
								className: 'wp-block-columns are-vertically-aligned-center', 
								style: {'display':'flex'} // WP Columns style
							},
							
							// Left Column
							el( 'div', { 
									className: 'wp-block-column text-center text-md-left', 
									style: {} 
								},
								el( RichText, {
									tagName: 'h3',
									placeholder: i18n.__('Add a heading...', 'bne' ),
									keepPlaceholderOnFocus: true,
									value: attributes.calloutHeading,
									onChange: function( newCalloutHeading ) {
										props.setAttributes( { calloutHeading: newCalloutHeading } );
									},
								} ),
								el( RichText, {
									tagName: 'p',
									placeholder: i18n.__('Add a message...', 'bne' ),
									keepPlaceholderOnFocus: true,
									value: attributes.calloutMessage,
									onChange: function( newCalloutMessage ) {
										props.setAttributes( { calloutMessage: newCalloutMessage } );
									},
								} ),
							), // End .wp-block-column
							
							// Right Column
							attributes.calloutButton &&
								el( 'div', { 
										className: 'wp-block-column', 
										style: {'flex-basis':'33.33%'} // WP Columns style (66.66/33.33)
									},
									el( InnerBlocks, {
										template: [
											[ 'core/button', {
												className: 'btn-block btn-lg',
											} ]
										],
										templateLock: true,
										templateInsertUpdatesSelection: false
										
									} ),
								) // End div.wp-block-column
						
						) // End div.wp-block-columns
						
					) // End div.callout-content
					
				) // End div.bne-callout
			];
		}, // END edit
	
	

		// ========================== //
		// Save
		// ========================== //
		save: function( props ) {
			var attributes = props.attributes;
			return (
				el( 'div', { 
						className: 'bne-callout',  
						style: {
							background: attributes.borderColor
						} 
					},
					el( 'div', { 
							className: 'callout-content'
						},
						el( 'div', { 
								className: 'wp-block-columns are-vertically-aligned-center', 
								style: {'display':'flex'} // WP Columns style
							},
							el( 'div', { 
									className: 'wp-block-column text-center text-md-left', 
									style: {} 
								},
								el( 
									RichText.Content, {
										tagName: 'h3',
										value: attributes.calloutHeading
									} 
								),
								el( 
									RichText.Content, {
										tagName: 'p',
										value: attributes.calloutMessage
									} 
								),
							), // End div.wp-block-column
							
							attributes.calloutButton &&
								el( 'div', { 
										className: 'wp-block-column', 
										style: {'flex-basis':'33.33%'} // WP Columns style (66.66/33.33)
									},
									el( InnerBlocks.Content, {} ),
								) // End div.wp-block-column
							
						) // End .wp-block-columns
					) // End div.title
				) // End div.bne-callout
			); // End Return
		
		}, // End Save


		// ========================== //
		// DEPRECATED BLOCK
		// ========================== //
		deprecated: [{
			// @depreciated @v2.2.6
			// Original block
			// Replaced with new border color control and WP columns markup		
			attributes:{calloutHeading:{type:'array',source:'children',selector:'h3',},calloutMessage:{type:'array',source:'children',selector:'p',},calloutButton:{type:'boolean',default:1},},save:function(props){var attributes=props.attributes;return(el('div',{className:'bne-callout',},el('div',{className:'callout-content',style:{}},el('div',{className:'row align-items-center',style:{}},el('div',{className:'col text-center text-md-left',style:{}},el(RichText.Content,{tagName:'h3',value:attributes.calloutHeading}),el(RichText.Content,{tagName:'p',value:attributes.calloutMessage}),),attributes.calloutButton&&el('div',{className:'col-md-4 callout-btn',style:{}},el(InnerBlocks.Content,{}),)))))}		
		}] // END DEPRECATED



	
	} ); // End registerBlockType
} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);