/*
 * 	BNE Block Alert
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	August 1, 2020
 *
*/


( function( blocks, components, i18n, element, editor ) {
	
	
	// Get Block elements
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var BlockControls = wp.blockEditor.BlockControls;
	var InnerBlocks = wp.blockEditor.InnerBlocks;
	var Toolbar = wp.components.Toolbar;
	var Dashicon = wp.components.Dashicon;
	var DropdownMenu = wp.components.DropdownMenu;
	var ColorPalette = wp.blockEditor.ColorPalette;
	var PanelBody = wp.components.PanelBody;


	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/alert', {
		title: 'Alert',
		description: __('A message alert box with an optional icon.', 'bne' ),
		icon: 'info',
		category: 'bne-blocks',
		attributes: {
       		icon: {
  				type: 'string',
  				default: ''
  			},
  			accentColor: {
	  			type: 'string',
	  			default: '#0099ff'
  			}
		},
		styles: [
		    { name: 'shadow-none', 	label: __( 'No Shadow', 'bne' ), isDefault: true },
		    { name: 'shadow-sm', 	label: __( 'Small Shadow', 'bne' ) },
		    { name: 'shadow', 		label: __( 'Regular Shadow', 'bne' ) },
		    { name: 'shadow-lg', 	label: __( 'Larger Shadow', 'bne' ) },
		],
		supports: {
			html: false
		},

				
		// ========================== //
		// Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes.icon);
			
  			return [

	  			// Block Controls
	  			// ========================== //
  				el( BlockControls, { key: 'controls' }, 
					el( Toolbar, {},
					    el( DropdownMenu, {
					        	icon: 'admin-settings',
								label: 'Alert Presets',
								controls: [
									/*
									 *	@note, using setTimeOut to reload the FA icon....
									*/
					            	{
					                	title: __( 'No Icon', 'bne' ),
										icon: '',
										onClick: function() {
											setTimeout(function(){
												props.setAttributes( { icon: '' } );
											},10);
										}
									},
					            	{
					                	title: __( 'Primary', 'bne' ),
										icon: 'editor-help',
										onClick: function() {
											props.setAttributes( { icon: '' } );
											setTimeout(function(){
												props.setAttributes( { icon: 'question-circle' } );
											},10);
											attributes.accentColor && 
												props.setAttributes( { accentColor: '#0099ff' } );
										}
									},
					            	{
					                	title: __( 'Success', 'bne' ),
										icon: 'yes',
										onClick: function() {
											props.setAttributes( { icon: '' } );
											setTimeout(function(){
												props.setAttributes( { icon: 'check-circle' } );
											},10);
											attributes.accentColor && 
												props.setAttributes( { accentColor: '#28a745' } );
										}
									},
					            	{
					                	title: __( 'Danger', 'bne' ),
										icon: 'dismiss',
										onClick: function() {
											props.setAttributes( { icon: '' } );
											setTimeout(function(){
												props.setAttributes( { icon: 'times-circle' } );
											},10);
											attributes.accentColor && 
												props.setAttributes( { accentColor: '#dc3545' } );
										}
									},
					            	{
					                	title: __( 'Warning', 'bne' ),
										icon: 'warning',
										onClick: function() {
											props.setAttributes( { icon: '' } );
											setTimeout(function(){
												props.setAttributes( { icon: 'exclamation-circle' } );
											},10);
											attributes.accentColor && 
												props.setAttributes( { accentColor: '#ffc107' } );
										}
									},
					            	{
					                	title: __( 'Info', 'bne' ),
										icon: 'info',
										onClick: function() {
											props.setAttributes( { icon: '' } );
											setTimeout(function(){
												props.setAttributes( { icon: 'info-circle' } );
											},10);
											attributes.accentColor && 
												props.setAttributes( { accentColor: '#17a2b8' } );
										}
									},
								]
							} 
						), // end DropdownMenu
		
					), // end div
				), // end BlockControls


				// Panel Controls
	  			// ========================== //
				el( InspectorControls, {},
 					el( PanelBody, {
							title: __( 'Alert Settings', 'bne' ),
							initialOpen: true,
						},
						el('p', {}, __( 'Color', 'bne' ) ),
						el( ColorPalette, {
								value: attributes.accentColor,
								onChange: function( newAccentColor ) {
									props.setAttributes( { accentColor: newAccentColor } );
								},
								colors: [
									{
										name: __( 'Primary', 'bne' ),
										slug: 'primary',
										color: '#0099ff'
									},
									{
										name: __( 'Success', 'bne' ),
										slug: 'success',
										color: '#28a745'
									},
									{
										name: __( 'Danger', 'bne' ),
										slug: 'danger',
										color: '#dc3545'
									},
									{
										name: __( 'Warning', 'bne' ),
										slug: 'warning',
										color: '#ffc107'
									},
									{
										name: __( 'Info', 'bne' ),
										slug: 'info',
										color: '#17a2b8'
									}
								]
							}
						)						
					) // PanelBody
				), // end InspectorControls

				// Editor
	  			// ========================== //
				el( 'div', {
						className: props.className + ' bne-alert alert', 
						style: { 
							borderLeftColor: attributes.accentColor, 
						}
					},

					attributes.icon && 
						el( 'div', {
								className: 'bne-alert-icon',
								style: { 
									color: attributes.accentColor, 
									fontSize: '30px', 
								}
							},
							
							el( 'i', {
								className: 'bne-fa fas fa-'+attributes.icon,
							} ),

						),
					
					el( 'div', {
							className: 'alert-content',
						},
						
						// Workaround logic for this bug https://github.com/WordPress/gutenberg/issues/9897
						// Happens when applying a style option with a block that has innerblocks
						// When fixed, remove the condition
						( 'undefined' !== typeof props.insertBlocksAfter ) 
							?
								el( InnerBlocks, {
									template: [
										[ 'core/paragraph']
									],
									templateLock: false,
									templateInsertUpdatesSelection: false
								} ) 
							: 
								el( 'div' )
					
					), // End div.alert-content
					
				) // End div.bne-alert
			
			]; // END return
		}, // END edit
	
		
	  	// ========================== //
		// Save
	  	// ========================== //
		save: function (props) {
			//console.log(props);
			var attributes = props.attributes;
			
			return (
				el( 'div', {
						className: 'bne-alert alert',
						style: { 
							borderLeftColor: attributes.accentColor, 
						}
					},

					attributes.icon && 
						el( 'div', {
								className: 'bne-alert-icon',
								style: { 
									color: attributes.accentColor, 
									fontSize: '30px', 
								}
							},
							
							el( 'i', {
								className: 'bne-fa fas fa-'+attributes.icon,
							} ),
						),

					el( 'div', {
							className: 'alert-content',
						}, 
						
						el( InnerBlocks.Content, {} ),
					
					),
					
				) // End .bne-alert
			
			) // End return
		} // End save

	} ); // End registerBlockType

} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);