/*
 * 	BNE Block XXXXX
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	February 16, 2019
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	//var Component = wp.element;
	//var Fragment = wp.element.Fragment;
	
	//var BlockFormatControls = wp.editor.BlockFormatControls;
	//var InspectorControls = wp.blockEditor.InspectorControls;
	//var BlockControls = wp.blockEditor.BlockControls;
	//var AlignmentToolbar = wp.editor.AlignmentToolbar;
	//var BlockAlignmentToolbar = wp.editor.BlockAlignmentToolbar;
	
	//var MediaUpload = wp.editor.MediaUpload;
	//var MediaUploadCheck = wp.editor.MediaUploadCheck;
	//var MediaPlaceholder = wp.editor.MediaPlaceholder;	
	//var ColorPalette = wp.editor.ColorPalette;
	//var InnerBlocks = wp.blockEditor.InnerBlocks;
	//var RichText = wp.editor.RichText;
	//var PanelColorSettings = wp.blockEditor.PanelColorSettings;
	
	//var Tooltip = wp.components.Tooltip;
	//var Toolbar = wp.components.Toolbar;
	//var Panel = wp.components.Panel;
	//var PanelBody = wp.components.PanelBody;
	//var PanelRow = wp.components.PanelRow;
	
	//var Button = wp.components.Button;
	//var ButtonGroup = wp.components.ButtonGroup;
	//var IconButton = wp.components.IconButton;
	//var Dashicon = wp.components.Dashicon;
	
	//var TextControl = wp.components.TextControl;
	//var TextareaControl = wp.components.TextareaControl;
	//var SelectControl = wp.components.SelectControl;
	//var CheckboxControl = wp.components.CheckboxControl;
	//var RadioControl = wp.components.RadioControl;
	//var RangeControl = wp.components.RangeControl;
	//var ToggleControl = wp.components.ToggleControl;
	//var FontSizePicker = wp.components.FontSizePicker;
	//var ColorPicker = wp.components.ColorPicker;
	//var PanelColor = wp.components.PanelColor;
	//var ContrastChecker = wp.components.ContrastChecker;
	//var DropdownMenu = wp.components.DropdownMenu;

	
	//console.log(wp.editor);
	
	// Icons
	var iconImageSVG = 
		el( 'svg', { className: 'dashicon dashicons-format-image', width: '20', height: '20' },
		el( 'path', { d: "M2.25 1h15.5c.69 0 1.25.56 1.25 1.25v15.5c0 .69-.56 1.25-1.25 1.25H2.25C1.56 19 1 18.44 1 17.75V2.25C1 1.56 1.56 1 2.25 1zM17 17V3H3v14h14zM10 6c0-1.1-.9-2-2-2s-2 .9-2 2 .9 2 2 2 2-.9 2-2zm3 5s0-6 3-6v10c0 .55-.45 1-1 1H5c-.55 0-1-.45-1-1V8c2 0 3 4 3 4s1-3 3-3 3 2 3 2z" } )
	);

	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/xxx', {
		title: __( 'Test', 'bne' ),
		description: __( 'A styled container with an image.', 'bne' ),
		icon: 'welcome-widgets-menus',
		category: 'bne-blocks',
		attributes: {
       		mediaID: {
  				type: 'number',
  			},
  			mediaURL: {
  				type: 'string',
  				source: 'attribute',
  				selector: 'img',
  				attribute: 'src',
  			},
  			mediaPosition: {
	  			type: 'string',
	  			default: 'top',
  			}
		},
		
		styles: [
		    { name: 'shadow-none', 	label: __( 'No Shadow', 'bne' ), isDefault: true },
		    { name: 'shadow-sm', 	label: __( 'Small Shadow' ) },
		    { name: 'shadow', 		label: __( 'Regular Shadow', 'bne' ) },
		    { name: 'shadow-lg', 	label: __( 'Larger Shadow', 'bne' ) },
		],		
		
		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes);

  			// Set an Attribute from a Btn
			var onImagePosition = function( media ) {
  				return props.setAttributes( {
  					mediaPosition: attributes.mediaPosition == "top" ? 'bottom' : 'top',
  				} );
  			};
  		
  			return [

				// Editor
				// ========================== //
				el( 'div', {
						className: props.className + ' bne-XXXX', 
						style: {} 
					},
					el( 'div', { 
							className: 'card-body',
							style: {}
						},
						
						// Workaround logic for this bug https://github.com/WordPress/gutenberg/issues/9897
						// Happens when applying a style option with a block that has innerblocks
						// When fixed, remove the condition
						( 'undefined' !== typeof props.insertBlocksAfter ) 
							?
								el( InnerBlocks, {
									template: [
										[ 'core/heading'],
										[ 'core/paragraph']
									],
									templateLock: false,
								} ) 
							: 
								el( 'div' )
					),
					
				) // End div.bne-XXXX
			
			]; // END return
		}, // END edit
	
		
		// ========================== //
		// Save
		// ========================== //
		save: function (props) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			return (
				el( 'div', {
						className: 'bne-XXXX',
						style: {}
					},
					
				) // End .bne-XXXX
			
			) // End return
		} // End save

	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);