<?php
/*
 * 	The template used for displaying general content
 *
 * 	@package BNE WordPress Framework
 *
*/
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<header class="entry-header page-heading">
		<h1 class="entry-title">
			<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
		</h1>
	</header><!-- .entry-header -->

	<?php if( 'post' == get_post_type() ) { ?>
		<?php echo bne_post_meta(); ?>
	<?php } ?>

	<div class="entry-content">
		
		<?php echo bne_post_thumbnail(); ?>
		
		<?php the_excerpt(); ?>

		<?php echo '<p><a href="'.get_the_permalink().'" title="'.the_title_attribute( array( 'echo' => false ) ).'" class="btn btn-default">'.get_theme_mod('post_read_more_label', 'Read More' ).'</a></p>'; ?>

	</div><!-- .entry-summary -->

</article><!-- #post-## -->