<?php
/*
 * 	The template for displaying Comments.
 *
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.2.1
 *
*/


/*
 * 	If the current post is protected by a password and
 * 	the visitor has not yet entered the password we will
 * 	return early without loading the comments.
*/
if( post_password_required() )
	return;
?>

<div id="comments" class="comments-area">

	<?php if( have_comments() ) : ?>
		<header class="comments-header">
			<h4 class="comments-title text-center">
				<?php
					printf( _nx( 'One thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', get_comments_number(), 'comments title', 'bne' ),
						number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' );
				?>
			</h4>
		</header>

		<?php if( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
			<nav id="comment-nav-above" class="comment-navigation" role="navigation">
				<h5 class="screen-reader-text"><?php _e( 'Comment navigation', 'bne' ); ?></h5>
				<ul class="pager">
					<li class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'bne' ) ); ?></li>
					<li class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'bne' ) ); ?></li>
				</ul>
			</nav><!-- #comment-nav-above -->
		<?php endif; // check for comment navigation ?>

		<ol class="comment-list media-list">
			<?php
				/* Loop through and list the comments. Tell wp_list_comments()
				 * to use bne_comment() to format the comments.
				 * If you want to overload this in a child theme then you can
				 * define bne_comment() and that will be used instead.
				 * See bne_comment() in includes/support.php for more.
				 */
				wp_list_comments( array( 'callback' => 'bne_comment', 'avatar_size' => 100 ) );
			?>
		</ol><!-- .comment-list -->

		<?php if( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
			<nav id="comment-nav-below" class="comment-navigation" role="navigation">
				<h5 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'bne' ); ?></h5>
				<ul class="pager">
					<li class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'bne' ) ); ?></li>
					<li class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'bne' ) ); ?></li>
				</ul>
			</nav><!-- #comment-nav-below -->
		<?php endif; // check for comment navigation ?>

	<?php endif; // have_comments() ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if( !comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'bne' ); ?></p>
	<?php endif; ?>

	<?php		
		comment_form( $args = array(
			//'fields'			=>	$fields,
			'id_form'           => 	'commentform',
			'id_submit'         => 	'commentsubmit',
			'title_reply'       => 	esc_html__( 'Leave a Reply', 'bne' ),
			'title_reply_to'    => 	esc_html__( 'Leave a Reply to %s', 'bne' ),
			'cancel_reply_link' => 	esc_html__( 'Cancel Reply', 'bne' ),
			'label_submit'      => 	esc_html__( 'Post Comment', 'bne' ),
			'class_submit' 		=> 	'btn btn-default submit',
			'comment_field' 	=>  '<div class="comments_field comment-form-message form-group"><label for="comment" class="sr-only">'.esc_html__( 'Comment', 'bne' ).' <span class="required">*</span></label><textarea id="comment" class="form-control" name="comment" cols="45" rows="5" aria-required="true" placeholder="'.esc_html__( 'Write your comment here', 'bne' ).'"></textarea></div>',
			'comment_notes_after' => '<div class="form-allowed-tags"><p>'.__( 'You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes:', 'bne' ).'</p><div class="alert alert-notice">'.allowed_tags().'</div></div>'

		));
	?>

</div><!-- #comments -->