<?php
/*
 * 	The template file for Archive pages.
 *
 * 	WARNING: This template file is a core part of the
 * 	BNE WordPress Framework. It is advised
 * 	that any edits to the way this file displays its
 * 	content be done with via hooks, filters, and
 * 	template parts.
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *
 *	@updated	v2.2.3
 *
*/

// Get Page Options
$template = get_theme_mod( 'post_archive_layout', 'list' );
$columns = get_theme_mod( 'post_archive_grid_columns', '2' );
if( $columns >= 6 ) { $columns = 6; $col = '2'; }
elseif( $columns == 5 ) { $col = '15'; } // BNE 1/5 column
else { $col = 12 / $columns; }
if( $template == 'list' ) { $col = '12'; }

get_header(); ?>

	<div id="sidebar_layout" class="archive-template clearfix">
		<div class="row">

			<!-- CONTENT (start) -->
			<div id="content" class="<?php echo bne_get_column_class( 'content' ); ?> clearfix blog-layout-<?php echo $template; ?>" role="main">

				<?php bne_page_heading(); ?>

				<?php if( have_posts() ) : ?>

					<div class="row">
						
						<?php while( have_posts() ) : the_post(); ?>
							
							<div class="col-sm-<?php echo $col; ?> clearfix">
								
								<?php get_template_part( 'template-parts/content', $template ); ?>
							
							</div><!-- .column (end) -->
							
						<?php endwhile; ?>
					
					</div><!-- .row (end) -->

					<?php bne_pagination( 'nav-below' ); ?>

				<?php else : ?>

					<?php get_template_part( 'template-parts/content', 'no_results' ); ?>

				<?php endif; ?>

			</div> <!-- #content (end) -->

			<!-- CONTENT (end) -->

			<!-- SIDEBARS (start) -->

			<?php bne_sidebars('left'); ?>

			<?php bne_sidebars('right'); ?>

			<!-- SIDEBARS (end) -->

		</div><!-- .row (end) -->
	</div><!-- #sidebar_layout.archive-template (end) -->

<?php get_footer(); ?>