<?php
/*
 * 	The template file for displaying the header.
 *
 * 	WARNING: This template file is a core part of the
 * 	BNE WordPress Framework. It is advised
 * 	that any edits to the way this file displays its
 * 	content be done with via hooks, filters, and
 * 	template parts.
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.0
 *
*/
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="profile" href="http://gmpg.org/xfn/11" />
<?php wp_head(); ?>
<script type="text/javascript">
            var getUrlVars = function() {
                var url = window.location.href;
                var lastHash = url.indexOf('#');
                var hashes = url.slice(url.indexOf('?') + 1, lastHash == -1 ? url.length : lastHash).split('&');
                var vars = [], hash;
                for(var i = 0; i < hashes.length; i++) {
                    hash = hashes[i].split('=');
                    vars.push(hash[0]);
                    vars[hash[0]] = hash[1];
                }
                return vars;
            }
            var vars = getUrlVars();
            var _paq = _paq || [];
            if ('memberurlid' in vars) _paq.push(['setCustomVariable', '1', 'memberurlid', vars['memberurlid'], 'visit']); 
            if ('uuid' in vars) _paq.push(['setCustomVariable', '2', 'uuid', vars['uuid'], 'visit']); 
            _paq.push(['trackPageView']);
            _paq.push(['enableLinkTracking']);
            (function() {
                var u=document.location.protocol + '//cdn.stoneshot.com/action/';
                _paq.push(['setTrackerUrl', u+'Visit']);
                _paq.push(['setSiteId', 'e71732fc0327491cbd6b2c7f447d162b' ]);
                var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
                g.type='text/javascript'; g.async=true; g.defer=true; g.src=u+'js/track'; s.parentNode.insertBefore(g,s);
            })();
			//handle memberurlid and cookies
			if (getUrlParameter("memberurlid")){setCookie("stoneshot-id", getUrlParameter("memberurlid"), 365);}function getUrlParameter(name){name=name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]"); var regex=new RegExp("[\\?&]" + name + "=([^&#]*)"); var results=regex.exec(location.search); return results===null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));}function setCookie(cname, cvalue, exdays){var d=new Date(); d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000); var expires="expires=" + d.toUTCString(); document.cookie=cname + "=" + cvalue + ";" + expires + ";path=/";}function getCookie(cname){var name=cname + "="; var decodedCookie=decodeURIComponent(document.cookie); var ca=decodedCookie.split(";"); for (var i=0; i < ca.length; i++){var c=ca[i]; while (c.charAt(0)==" "){c=c.substring(1);}if (c.indexOf(name)==0){return c.substring(name.length, c.length);}}return "";}
        </script>
</head>
<body <?php body_class(); ?>>
	
	<?php wp_body_open(); ?>
	
	<a class="skip-link sr-only" href="#main-content-wrapper"><?php esc_html_e( 'Skip to content', 'bne' ); ?></a>
	
	<?php bne_before(); ?>

	<div id="wrapper">
		<div id="container">

			<?php bne_header_before(); ?>
	
			<?php if( 'hide' != bne_get_page_option( 'header_display' ) ) { ?>
			
				<!-- HEADER (start) -->
				
				<div id="header-wrapper">
					<header id="branding" itemscope="itemscope" itemtype="http://schema.org/WPHeader">
						<div class="content-area-width">
	
							<?php bne_header_content_before(); ?>
							<?php bne_header_content(); ?>
							<?php bne_header_menu(); ?>
							<?php bne_header_content_after(); ?>
	
						</div><!-- .content-area-width (end) -->
					</header><!-- #branding (end) -->
				</div><!-- #header-wrapper (end) -->
				
				<!-- HEADER (end) -->
			
			<?php }
				
			bne_header_after();
			
			// Featured Area
			bne_featured_area();

			// Before Main
			bne_main_before();

			// Main Start
			bne_main_start();

			// Breadcrumbs
			bne_breadcrumbs();