<?php
/*
 * 	Main Child Theme Functions
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) 2016, Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package	Child Theme for BNE Sweetness WordPress Framework
 *
*/


/* ===================================================================================
 * 	Run BNE WordPress Framework (required)
 * ================================================================================ */

require_once( get_template_directory() . '/framework/bne-functions.php' );


/* ===================================================================================
 * 	Child Theme Functions
 * ================================================================================ */


/* 
 *	Enqueue Child Theme scripts
 *
*/
function bne_childtheme_scripts(){

	// Child Theme JS
	wp_enqueue_script( 'bne-child-js', get_stylesheet_directory_uri() . '/assets/js/theme.js', array('jquery') );

}
add_action( 'wp_enqueue_scripts', 'bne_childtheme_scripts', 11 );







/* 
 *	Configure Theme Settings
 *
 *	Allows overriding parent theme settings and hooks.
 *
*/
function bne_child_theme_setup() {
	
	// Sidebar Layout Sizes and Breakpoints
	//add_filter( 'bne_sidebar_layout_width', function() { return '9-3'; } );
	//add_filter( 'bne_sidebar_layout_responsive', function() { return 'md'; } );
	add_filter( 'bne_sidebar_layout_gutter', function() { return '90'; } );

}
add_action( 'after_setup_theme', 'bne_child_theme_setup' );




/* 
 *	Custom Color Palette
 *
*/
add_filter( 'bne_theme_color_palette', function($color_palette) {
	
	// Remove default colors
	unset($color_palette['primary']);
	unset($color_palette['secondary']);
	unset($color_palette['tertiary']);
	unset($color_palette['success']);
	unset($color_palette['danger']);
	unset($color_palette['warning']);
	unset($color_palette['info']);
	
	
	// Add custom site colors
	$color_palette['ssi_blue'] = array(
		'name'  => __( 'SSI Blue', 'bne' ),
		'slug'  => 'ssi_blue',
		'color'	=> '#425762',
	);
	$color_palette['ssi_wheat'] = array(
		'name'  => __( 'SSI Wheat', 'bne' ),
		'slug'  => 'ssi_wheat',
		'color'	=> '#996633',
	);
	$color_palette['tan'] = array(
		'name'  => __( 'Tan / Warm Gray', 'bne' ),
		'slug'  => 'tan',
		'color'	=> '#cac9ad',
	);
	$color_palette['maroon'] = array(
		'name'  => __( 'Maroon', 'bne' ),
		'slug'  => 'maroon',
		'color'	=> '#993366',
	);
	$color_palette['orage'] = array(
		'name'  => __( 'Orange', 'bne' ),
		'slug'  => 'orange',
		'color'	=> '#d07a29',
	);
	$color_palette['green'] = array(
		'name'  => __( 'Green', 'bne' ),
		'slug'  => 'green',
		'color'	=> '#999632',
	);
	$color_palette['light_beige'] = array(
		'name'  => __( 'Light Beige', 'bne' ),
		'slug'  => 'light_beige',
		'color'	=> '#e3e3d3',
	);
	return $color_palette;
});


/* == Team Plugin == */
/* Move single template to child theme */
remove_filter( 'single_template', 'gs_team_single_template' );
add_filter( 'single_template', 'custom_gs_team_single_template' );
function custom_gs_team_single_template( $single_team_template ) {
    global  $post ;
    if ( $post->post_type == 'gs_team' ) {
        $single_team_template = get_stylesheet_directory() . '/single-team.php';
    }
    return $single_team_template;
}

