function returnError(error, source) {
  var errorData = {
    code: "",
    message: "",
  };
  if (source === "code") {
    errorData.code = error.status;
    switch (error.status) {
      case 0:
        errorData.message = "Timeout (from code)";
        break;
      case 404:
        errorData.message = "Not found (from code)";
        break;
      case 400:
        errorData.message = "Bad request (from code)";
        break;
      default:
        errorData.message = "An error happened (from code)";
    }
  }
  if (source === "api") {
    errorData.code = error.code;
    errorData.message = error.message + " (from API or backend)";
  }
  return errorData;
}

var timeout = 20000;

function checkContactExist(data) {
  return new Promise(function (resolve, reject) {
    jQuery.ajax({
      type: "POST",
      url: "https://www.ssi-invest.com/wp-content/stoneshot-api/check-contact-exist.php",
      data: data,
      timeout: timeout,
      success: function (response) {
        response = jQuery.parseJSON(response);
        if (response.code !== undefined) {
          reject(returnError(response, "api"));
        } else {
          resolve(response);
        }
      },
      error: function (jqXHR) {
        reject(returnError(jqXHR, "code"));
      },
    });
  });
}

function createContact(data) {
  return new Promise(function (resolve, reject) {
    jQuery.ajax({
      type: "POST",
      url:
        "https://www.ssi-invest.com/wp-content/stoneshot-api/create-contact.php",
      data: data,
      timeout: timeout,
      success: function (response) {
        response = jQuery.parseJSON(response);
        if (response.code !== undefined) {
          reject(returnError(response, "api"));
        } else {
          resolve(response);
        }
      },
      error: function (jqXHR) {
        reject(returnError(jqXHR, "code"));
      },
    });
  });
}

function addToCampaign(data) {
  return new Promise(function (resolve, reject) {
    jQuery.ajax({
      type: "POST",
      url:
        "https://www.ssi-invest.com/wp-content/stoneshot-api/add-contact-campaign.php",
      data: data,
      timeout: 70000,
      success: function (response) {
        response = jQuery.parseJSON(response);
        if (response.code !== undefined) {
          reject(returnError(response, "api"));
        } else {
          resolve(response);
        }
      },
      error: function (jqXHR) {
        console.log(jqXHR);
        reject(returnError(jqXHR, "code"));
      },
    });
  });
}

function setCookie(cname, cvalue, exdays) {
  var d = new Date();
  d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000);
  var expires = "expires=" + d.toUTCString();
  document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
  var name = cname + "=";
  var decodedCookie = decodeURIComponent(document.cookie);
  var ca = decodedCookie.split(";");
  for (var i = 0; i < ca.length; i++) {
    var c = ca[i];
    while (c.charAt(0) == " ") {
      c = c.substring(1);
    }
    if (c.indexOf(name) == 0) {
      return c.substring(name.length, c.length);
    }
  }
  return "";
}

function getUrlParameter(name) {
  name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
  var regex = new RegExp("[\\?&]" + name + "=([^&#]*)");
  var results = regex.exec(location.search);
  return results === null
    ? ""
    : decodeURIComponent(results[1].replace(/\+/g, " "));
}

function deleteCookieAndRedirect(cookiename, url) {
  setCookie(cookiename, "", -1);
  window.location.href = url;
}

function strip(html) {
  let doc = new DOMParser().parseFromString(html, "text/html");
  return doc.body.textContent || "";
}