<?php

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;

/*
 *	BNE_Widgets_Social_Bar Class
 *	Extends the WP_Widget class with ours, BNE_Widgets_Social_Bar,
 *	to create a new available widget.
 *
 *  @since		v1.0
 *
*/
class BNE_Widgets_Social_Bar extends WP_Widget {
 
	public function __construct() {
	
		parent::__construct(
			'bne_widgets_social_bar',
			esc_html__( 'BNE Social Bar', 'bne-widgets' ),
			array(
				'classname'   => 'bne_widgets_social_bar',
				'description' => esc_html__( 'Display social profiles links from Theme Options.', 'bne-widgets' )
			)
		);

		add_action( 'widgets_init', function() {
            register_widget( 'bne_widgets_social_bar' );
        });

	} // End Construct
	
	
	
	/*  
	 * 	Front-end display of widget.
	 *
	 * 	@see WP_Widget::widget()
	 *
	 * 	@param array $args     Widget arguments.
	 * 	@param array $instance Saved values from database.
	*/
	public function widget( $args, $instance ) {    
	
		//bne_printr($instance);

		// Saved Options
		$title = apply_filters( 'widget_title', $instance['title'] );
		$color = ( !empty( $instance['color'] ) ) ? esc_attr( $instance['color'] ) : 'color';
		$shape = ( !empty( $instance['shape'] ) ) ? esc_attr( $instance['shape'] ) : 'rounded';
		$size = ( !empty( $instance['size'] ) ) ? esc_attr( $instance['size'] ) : '25';
		$align = ( !empty( $instance['align'] ) ) ? esc_attr( $instance['align'] ) : 'left';

		echo $args['before_widget'];
		
		if( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
	
		echo bne_contact_bar( 'widget', $color, $shape, '', $size, $align );

		echo $args['after_widget'];
	
	} // End widget
 
  
	/*
	 *  Sanitize widget form values as they are saved.
	 *
	 *  @see WP_Widget::update()
	 *
	 *  @param array $new_instance Values just sent to be saved.
	 *  @param array $old_instance Previously saved values from database.
	 *
	 *  @return array Updated safe values to be saved.
	*/
	public function update( $new_instance, $old_instance ) {        
	
		$instance = $old_instance;
	
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['color'] = strip_tags( $new_instance['color'] );
		$instance['shape'] = strip_tags( $new_instance['shape'] );
		$instance['size'] = strip_tags( $new_instance['size'] );
		$instance['align'] = strip_tags( $new_instance['align'] );
	
		return $instance;
	
	} // End Update
	
	/*
	 *  Back-end widget form.
	 *
	 *  @see WP_Widget::form()
	 *
	 *  @param array $instance Previously saved values from database.
	*/
	public function form( $instance ) {    
	
		if( $instance ) {
			$title = sanitize_text_field( $instance['title'] );
			$color = esc_attr($instance['color']);
			$shape = esc_attr($instance['shape']);
			$size = esc_attr( $instance['size'] );
			$align = esc_attr( $instance['align'] );
		} else {
			$title = '';
			$color = 'color';
			$shape = 'round';
			$size = '25';
			$align = 'left';
		}
		
		?>
	
		<!-- Widget Title -->
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title', 'bne-widgets'); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
		</p>

		<!-- Size -->
		<p>
			<label for="<?php echo $this->get_field_id('size'); ?>"><?php _e('Icon Size', 'bne-widgets'); ?>:</label>
			<span style="display:block;padding:2px 0" class="description"><?php echo _e( 'The size (in px) of the social icons.', 'bne-widgets'); ?></span>
			<input class="widefat" id="<?php echo $this->get_field_id('size'); ?>" name="<?php echo $this->get_field_name('size'); ?>" type="number" value="<?php echo $size; ?>" />
		</p>


		<!-- Color -->
		<p>
			<label for="<?php echo $this->get_field_id('color'); ?>"><?php _e('Icon Color', 'bne-widgets'); ?>:</label>
			<span style="display:block;padding:2px 0" class="description"><?php echo _e( 'The background color set of the social icons.', 'bne-widgets'); ?></span>
			<select name="<?php echo $this->get_field_name('color'); ?>" id="<?php echo $this->get_field_id('color'); ?>" class="widefat">
				<?php
					echo '<option value="color" id="color"', $color == 'color' ? ' selected="selected"' : '', '>'.esc_html__( 'Color', 'bne-widgets' ).'</option>';
					echo '<option value="light" id="light"', $color == 'light' ? ' selected="selected"' : '', '>'.esc_html__( 'Light', 'bne-widgets' ).'</option>';
					echo '<option value="grey" id="grey"', $color == 'grey' ? ' selected="selected"' : '', '>'.esc_html__( 'Grey', 'bne-widgets' ).'</option>';
					echo '<option value="dark" id="dark"', $color == 'dark' ? ' selected="selected"' : '', '>'.esc_html__( 'Dark', 'bne-widgets' ).'</option>';
				?>
			</select>
		</p>

		<!-- Shape -->
		<p>
			<label for="<?php echo $this->get_field_id('shape'); ?>"><?php _e('Icon Shape', 'bne-widgets'); ?>:</label>
			<span style="display:block;padding:2px 0" class="description"><?php echo _e( 'The background shape of the social icons. Choose "transparent" to remove the background completely leaving only the icon.', 'bne-widgets'); ?></span>
			<select name="<?php echo $this->get_field_name('shape'); ?>" id="<?php echo $this->get_field_id('shape'); ?>" class="widefat">
				<?php
					echo '<option value="rounded" id="rounded"', $shape == 'rounded' ? ' selected="selected"' : '', '>'.esc_html__( 'Rounded', 'bne-widgets' ).'</option>';
					echo '<option value="square" id="square"', $shape == 'square' ? ' selected="selected"' : '', '>'.esc_html__( 'Square', 'bne-widgets' ).'</option>';
					echo '<option value="circle" id="circle"', $shape == 'circle' ? ' selected="selected"' : '', '>'.esc_html__( 'Circle', 'bne-widgets' ).'</option>';
					echo '<option value="transparent" id="transparent"', $shape == 'transparent' ? ' selected="selected"' : '', '>'.esc_html__( 'Transparent', 'bne-widgets' ).'</option>';
				?>
			</select>
		</p>

		<!-- Align -->
		<p>
			<label for="<?php echo $this->get_field_id('align'); ?>"><?php _e('Alignment', 'bne-widgets'); ?>:</label>
			<span style="display:block;padding:2px 0" class="description"><?php echo _e( 'Align the social bar to the left, center, or right.', 'bne-widgets'); ?></span>
			<select name="<?php echo $this->get_field_name('align'); ?>" id="<?php echo $this->get_field_id('align'); ?>" class="widefat">
				<?php
					echo '<option value="left" id="left"', $align == 'left' ? ' selected="selected"' : '', '>'.esc_html__( 'Left', 'bne-widgets' ).'</option>';
					echo '<option value="center" id="center"', $align == 'center' ? ' selected="selected"' : '', '>'.esc_html__( 'Center', 'bne-widgets' ).'</option>';
					echo '<option value="right" id="right"', $align == 'right' ? ' selected="selected"' : '', '>'.esc_html__( 'Right', 'bne-widgets' ).'</option>';
				?>
			</select>
		</p>


    <?php 
    
    } // End Form
     
}
$BNE_Widgets_Social_Bar = new BNE_Widgets_Social_Bar();