<?php

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;



/*
 *	Add Widget Fields
 *	Adds additional fields to all widgets
 *
 *	@since v1.1
*/
function bne_widgets_add_fields( $widget, $return, $instance ) { 
    $desktop = isset( $instance['hide_on_desktop'] ) ? $instance['hide_on_desktop'] : '';
    $tablet = isset( $instance['hide_on_tablet'] ) ? $instance['hide_on_tablet'] : '';
    $mobile = isset( $instance['hide_on_mobile'] ) ? $instance['hide_on_mobile'] : '';
    $class = isset( $instance['class'] ) ? esc_attr($instance['class']) : '';
    
    ?>
		<hr>
		<p><strong><?php _e( 'Additional Settings', 'bne-widgets' ); ?></strong></p>
		<p><label><?php _e( 'Widget Visibility:', 'bne-widgets' ); ?></label></p>
		<ul>
            <li>
            	<input class="checkbox" type="checkbox" id="<?php echo $widget->get_field_id('hide_on_desktop'); ?>" name="<?php echo $widget->get_field_name('hide_on_desktop'); ?>" <?php echo (empty($desktop)) ? "":"checked"; ?> />
				<label for="<?php echo $widget->get_field_id('hide_on_desktop'); ?>"><?php _e('Hide on desktop', 'bne-widgets'); ?></label>
            </li>
            <li>
            	<input class="checkbox" type="checkbox" id="<?php echo $widget->get_field_id('hide_on_tablet'); ?>" name="<?php echo $widget->get_field_name('hide_on_tablet'); ?>" <?php echo (empty($tablet)) ? "":"checked"; ?> />
				<label for="<?php echo $widget->get_field_id('hide_on_tablet'); ?>"><?php _e('Hide on tablet', 'bne-widgets'); ?></label>
            </li>
            <li>
            	<input class="checkbox" type="checkbox" id="<?php echo $widget->get_field_id('hide_on_mobile'); ?>" name="<?php echo $widget->get_field_name('hide_on_mobile'); ?>" <?php echo (empty($mobile)) ? "":"checked"; ?> />
				<label for="<?php echo $widget->get_field_id('hide_on_mobile'); ?>"><?php _e('Hide on mobile', 'bne-widgets'); ?></label>
            </li>
		<ul>

		<p>
			<label for="<?php echo $widget->get_field_id('class'); ?>"><?php _e('Custom Classname', 'bne-widgets'); ?>:</label>
			<!--<span style="display:block;padding:2px 0" class="description"><?php echo _e( 'Include an extra classname for css customizations.', 'bne-widgets'); ?></span> -->
			<input type="text" class="widefat" id="<?php echo $widget->get_field_id('class'); ?>" name="<?php echo $widget->get_field_name('class'); ?>" value="<?php echo $class; ?>" />
		</p>
   
		
    <?php
}
add_filter('in_widget_form', 'bne_widgets_add_fields', 10, 3 );



/*
 *	Save new widget fields
 *
 *	@since v1.1
*/
function bne_widgets_add_save_options( $instance, $new_instance ) {
 
  	$new_instance['hide_on_desktop'] = ( !empty( $new_instance['hide_on_desktop'] ) ) ? $new_instance['hide_on_desktop']: '';
	$new_instance['hide_on_tablet'] = ( !empty( $new_instance['hide_on_tablet'] ) ) ? $new_instance['hide_on_tablet']: '';
	$new_instance['hide_on_mobile'] = ( !empty( $new_instance['hide_on_mobile'] ) ) ? $new_instance['hide_on_mobile']: '';
 	$new_instance['class'] = ( !empty( $new_instance['class'] ) ) ? $new_instance['class']: '';

	return $new_instance;
}
add_filter( 'widget_update_callback', 'bne_widgets_add_save_options', 10, 2 );



/*
 *	Add fields that have classes to the before_widget arg
 *
 *	@since v1.1
*/
function bne_widgets_add_classes( $params ) {
	global $wp_registered_widgets;
	$widget_id	= $params[0]['widget_id'];
	$widget_obj	= $wp_registered_widgets[$widget_id];
	$widget_opt	= get_option($widget_obj['callback'][0]->option_name);
	$widget_num	= $widget_obj['params'][0]['number'];
	$classes = array(
		(isset($widget_opt[$widget_num]['class']) && !empty($widget_opt[$widget_num]['class']) ) ? $widget_opt[$widget_num]['class']:"",
		(isset($widget_opt[$widget_num]['hide_on_desktop']) && !empty($widget_opt[$widget_num]['hide_on_desktop']) ) ? "hide_on_desktop":"",
		(isset($widget_opt[$widget_num]['hide_on_tablet']) && !empty($widget_opt[$widget_num]['hide_on_tablet'])) ? "hide_on_tablet":"",
		(isset($widget_opt[$widget_num]['hide_on_mobile']) && !empty($widget_opt[$widget_num]['hide_on_mobile'])) ? "hide_on_mobile":"",
	);
	
	// Clear out empty classe options
	$classes = array_filter($classes);

	$params[0]['before_widget'] = preg_replace(
		'/class="/',
		sprintf( 'class="%s ', implode(" ",$classes) ),
		$params[0]['before_widget'],
		1
	);
	return $params;
}
add_filter( 'dynamic_sidebar_params', 'bne_widgets_add_classes' );