<?php
/*
 * Plugin Name: BNE Widgets
 * Version: 1.2
 * Plugin URI: http://www.bnecreative.com
 * Description:  Adds a number of widgets to be used with BNE Themes v2.0+
 * Author: Kerry Kline
 * Author URI: http://www.bnecreative.com
 * Requires at least: 5.0
 * License: GPL2

    Copyright 2019  BNE Creative

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2,
    as published by the Free Software Foundation.

    You may NOT assume that you can use any other version of the GPL.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    The license for this software can likely be found here:
    http://www.gnu.org/licenses/gpl-2.0.html

*/


// Exit if accessed directly
if ( !defined('ABSPATH')) exit;

// Set Constants
define( 'BNE_WIDGETS_VERSION', '1.2' );
define( 'BNE_WIDGETS_DIR', dirname( __FILE__ ) );
define( 'BNE_WIDGETS_URI', plugins_url( '', __FILE__ ) );
define( 'BNE_WIDGETS_BASENAME', plugin_basename( __FILE__ ) );

// Requirement Notice and dependencies
add_action( 'admin_init', function() {
	$pass = true;
	if( !defined( 'BNE_FRAMEWORK_VERSION' ) || ( defined( 'BNE_FRAMEWORK_VERSION' ) && BNE_FRAMEWORK_VERSION < '2' ) ) {
		$pass = false;
	}
	
	if( false == $pass ) {	
		add_action( 'admin_notices', function() {
			echo '<div class="notice notice-error is-dismissible"><p>Apologies, but <strong>BNE Widgets</strong> requires a theme running BNE Theme Framework v2.0+</p></div>';
		});
		deactivate_plugins( BNE_WIDGETS_BASENAME );
	}
	
});

include_once( BNE_WIDGETS_DIR . '/widgets/options.php' );
include_once( BNE_WIDGETS_DIR . '/widgets/post-list.php' );
include_once( BNE_WIDGETS_DIR . '/widgets/social-bar.php' );
include_once( BNE_WIDGETS_DIR . '/widgets/map.php' );