<?php
/*
 * 	Template Part - Tagline
 *
 *	The template used to display the tagline using 
 *	bne_testimonials_get_template( $part, $atts ). 
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
 *	$atts		Shortcode options and settings
 *	returns		$output back to the shortcode
 *
 *	@since 		v2.3
 *	@updated	v2.3.1
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

$output = '';

if( 'true' == $atts['tagline'] ) {
	$tagline = ( isset( $atts['api']['tagline'] ) ) ? $atts['api']['tagline'] : get_post_meta( get_the_id(), 'tagline', true );
	$output .= '<span class="testimonial-tagline">'.$tagline.'</span>';	
}

return apply_filters( 'bne_testimonials_tagline', $output, $atts );