<?php
/*
 * 	Template Part - Single
 *
 *	The template used to display the single structure using 
 *	bne_testimonials_get_template( $part, $atts ). 
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
 *	$atts		Shortcode options and settings
 *	returns		$output back to the shortcode
 *
 *	@since 		v2.3
 *	@updated	v2.8.7
 *
*/
	
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


// Empty String
$output = '';




/*
 *	Devs - Before Single Testimonial Filter
 *
 *	Allow developers to extend content before the single 
 *	testimonial output.
 *
*/
$output .= apply_filters( 'bne_testimonials_single_before', '' );



// Edit Link for admins
if( current_user_can( 'edit_pages' ) ) {
	$output .= '<a class="testimonial-edit-button" href="'.get_edit_post_link( get_the_id() ).'" target="_blank"><span class="bne-icon-edit"></span></a>';
}


// Arrangement 1 (Author then Message)
if( '1' == $atts['arrangement'] ) {
	$content = bne_testimonials_get_template( 'author', $atts );
	$content .= bne_testimonials_get_template( 'message', $atts );

// Arrangement 2 (Message then Author)
} else {
	$content = bne_testimonials_get_template( 'message', $atts );
	$content .= bne_testimonials_get_template( 'author', $atts );
}


/*
 *	Devs - Single Testimonial Filter
 *
 *	Allow developers to extend/change testimonial content within the
 *	single testimonial output.
 *
*/
$output .= apply_filters( 'bne_testimonials_single', $content, $atts );



/*
 *	Devs - After Single Testimonial Filter
 *
 *	Allow developers to extend content after the
 *	single testimonial output.
 *
*/
$output .= apply_filters( 'bne_testimonials_single_after', '' );


return $output;