<?php
/*
 * 	Template Part - Rating
 *
 *	The template used to display the rating using 
 *	bne_testimonials_get_template( $part, $atts ). 
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
 *	$atts		Shortcode options and settings
 *	returns		$output back to the shortcode
 *
 *	@since 		v2.3
 *	@updated		v2.9
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


// Filter for API Rating
$rating = ( isset( $atts['api']['rating'] ) ) ? $atts['api']['rating'] : get_post_meta( get_the_id(), 'rating', true );


$empty = ($rating > 0 ) ? 5 - $rating : '5';
$rating_color = null;


/*
 * 	Schema Rating Header
 *	@url: https://schema.org/aggregateRating
 *	@url: https://schema.org/Rating
 *
*/
$schema_tag = bne_testimonials_get_schema( 
	$atts['schema'], 
	'header/rating'
);


// Empty String
$output = '';


if( 'true' == $atts['rating'] && $rating ) {
	
	// Star font color
	if( $atts['rating_color'] ) { $rating_color = 'style="color:'.$atts['rating_color'].';"'; }
	
	$output .= '<div class="testimonial-rating rating-'.str_replace('.', '-', $rating).'"'.$schema_tag.'>';
		
		// Star Defaults (adding "+0" removes the ".0")
		$full = ( $rating > 5 ) ? 5 : $rating + 0;
		$half = 0;
		$empty = 0;
		$max = 5;

		// Adjust full if rating is a decimal
		if( strpos( $full, "." ) !== false ) {
			$full = floor( $rating );
			$half = 1;
		}
		
		// Full Stars
		for( $stars = 1; $stars <= $full; $stars++ ) {
			$output .= '<span class="bne-icon-star-filled bne-stars" '.$rating_color.'></span>';
		}
		
		// Half Star
		if( $half == 1 ) {
			$output .= '<span class="bne-icon-star-half-outline bne-stars" '.$rating_color.'></span>';
		}
	
		// Empty Stars
		for( $stars = 1; $stars <= ( $max - $full - $half ); $stars++ ) {
			$output .= '<span class="bne-icon-star-empty bne-stars" '.$rating_color.'></span>';
		}

		// Schema Tags
		$output .= bne_testimonials_get_schema( 
			$atts['schema'], 
			'rating', 
			$rating 
		);
		
		
	$output .= '</div>';

}

return $output;	