<?php
/*
 * 	Template Part - Name
 *
 *	The template used to display the name using 
 *	bne_testimonials_get_template( $part, $atts ). 
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
 *	$atts		Shortcode options and settings
 *	returns		$output back to the shortcode
 *
 *	@since 		v2.3
 *	@updated	v2.9.5
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

// Filter for API Name & Date
$name = ( isset( $atts['api']['name'] ) ) ? $atts['api']['name'] : get_the_title();
$date = ( isset( $atts['api']['date'] ) ) ? date('Y-m-d', strtotime( $atts['api']['date'] ) ) : get_the_date( 'Y-m-d' );


// Empty String
$output = '';


/*
 * 	Schema Name and Date
 *	@url: https://schema.org/name
 *	@url: https://schema.org/datePublished
 *
*/
$output .= bne_testimonials_get_schema( 
	$atts['schema'], 
	'author', 
	array( 
		'name'			=>	$name, 
		'date'			=>	$date,
		//'item_image'	=>	$atts['schema_image'],
		//'item_type'	=>	( $atts['schema_item_type'] ) ? $atts['schema_item_type'] : 'Service'
		'item_name'		=>	$atts['schema_name'].' '.__( 'Review', 'bne-testimonials' ),
	) 
);


if( 'true' == $atts['name'] ) {
	$output .= '<span class="testimonial-name">'.$name.'</span>';		
}


return apply_filters( 'bne_testimonials_name', $output, $atts );