<?php
/*
 * 	Template Part - Message
 *
 *	The template used to display the message using 
 *	bne_testimonials_get_template( $part, $atts ). 
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
 *	$atts		Shortcode options and settings
 *	returns		$output back to the shortcode
 *
 *	@since 		v2.3
 *	@updated		v2.9
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


// Setup container styles
$styles = 'style="';
$styles .= ( $atts['message_bg_color'] ) ? 'background:'.$atts['message_bg_color'].';' : '';
$styles .= ( $atts['message_color'] ) ? 'color:'.$atts['message_color'].';' : '';
$styles .= '"';


// Configure the arrow placements
$show_arrow = 'true';
$arrow_color = $atts['message_bg_color'];
if( 'cards-h' == $atts['theme'] || 'cards' == $atts['theme'] ) {
	$arrow_side = ( '1' == $atts['arrangement'] ) ? 'left' : 'right';
	$arrow_border_side = ( '1' == $atts['arrangement'] ) ? 'right' : 'left';	
}
elseif( 'cards-v' == $atts['theme'] || 'bubble' == $atts['theme'] ) {
	$arrow_side = ( '1' == $atts['arrangement'] ) ? 'up' : 'down';
	$arrow_border_side = ( '1' == $atts['arrangement'] ) ? 'bottom' : 'top';	
} else {
	$show_arrow = 'false';
}


// Clearfix container when needed
$clear = ( 'default' == $atts['theme'] || 'simple' == $atts['theme'] ) ? '' : 'clearfix';


// Set Message from API or local and allow to be adjusted before being parsed
$message = apply_filters( 
	'bne_testimonials_the_content', 
	( isset( $atts['api']['message'] ) ) ? $atts['api']['message'] : get_the_content(), 
	$atts 
);


// Bail out of no message is available.
if( empty( $message ) ) {
	return;
}


// Readmore Link Defaults
$readmore = array(
	'class'			=>	null,
	'link'			=>	null,
	'external_link'	=>	apply_filters( 'bne_testimonials_external_readmore_link', false, $atts )
);
if( 'true' == $atts['readmore'] ) {
	$readmore['class'] = ' message-limit';
	$readmore['link'] = ' <a href="#" class="readmore">'.$atts['readmore_text'].'</a>';
	

	/*
	 * 	Yelp Readmore Link
	 *
	 *  Since Yelp only provides a "truncated" message to begin with, 
	 *	we can skip all of this and just provide a link to
	 *	the full review at yelp.com
	*/
	if( isset( $atts['source'] ) ) {
		if( 'yelp' == $atts['source'] ) {
			$readmore['external_link'] = true;
		}
	}
	
	// External Link setup
	if( true == $readmore['external_link'] ) {
		// Remove internal classes
		$readmore['class'] = null;
		$readmore['link'] = null;
		
		// Place the external link within the message body text 
		// so that curtail does not adjust it.
		$message .= ' <a href="'.$atts['api']['website'].'" class="readmore" target="_blank" rel="noreferrer nofollow">'.$atts['readmore_text'].'</a>';
	}
	
}


/*
 * 	Schema Message Tag
 *	@url: https://schema.org/reviewBody
 *
*/
$schema_tag = bne_testimonials_get_schema( $atts['schema'], 'reviewBody' );


// Complete Message output
$output = '<div class="testimonial-content '.$clear.'" '.$styles.'>';

	// Arrow (bubble and cards themes)
	if( 'true' == $show_arrow ) {
		$output .= '<div class="testimonial-arrow-'.$arrow_side.'" style="border-'.$arrow_border_side.'-color:'.$arrow_color.';"></div>';
	}
	
	// Inner contnet wrapepr
	$output .= '<div class="testimonial-message'.$readmore['class'].'"'.$schema_tag.'>';
		
		// Returned message
		$message = wpautop( do_shortcode( $message ) );
		
		// Readmore Link
		$message .= $readmore['link'];
		
		// Allow developers to adjust the message content.
		$output .= apply_filters( 'bne_testimonials_content', $message, $atts );
	
	$output .= '</div>';	

$output .= '</div>';


// Final return to shortcode
return $output;