<?php
/*
 * 	Template Part - Image
 *
 *	The template used to display the image using 
 *	bne_testimonials_get_template( $part, $atts ). 
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
 *	$atts		Shortcode options and settings
 *	returns		$output back to the shortcode
 *
 *	@since 		v2.0
 *	@updated	v2.5
 *
*/


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

$output = '';
if( 'true' == $atts['image'] && ( 'thumbs' != $atts['layout'] && 'thumbnail' != $atts['layout'] ) ) {
	
	// Get Email for Gravatar
	$email = ( isset( $atts['api']['email'] ) ) ? $atts['api']['email'] : get_post_meta( get_the_id(), 'email', true );
	
	// Set Image Atts
	$class = 'testimonial-image testimonial-'.$atts['image_style'].' testimonial-crop-'.$atts['image_size'];
	$alt = the_title_attribute( 'echo=0' );


	// API
	if( isset( $atts['api']['image'] ) ) {
		$output .= '<img src="'.$atts['api']['image'].'" class="'.$class.'" alt="'.$atts['api']['name'].'" height="100" width="100"/>';


	// Local
	} elseif( has_post_thumbnail() ) {
		$output .= get_the_post_thumbnail( 
			get_the_id(),
			$atts['image_size'], 
			array(
				'class'	=>	$class,
				'alt'	=>	$alt
			)
		);


	// Gravatar Fallback
	} elseif( $email ) {
		$gravatar = bne_testimonials_get_gravatar( $email );
		if( $gravatar ) {
			$output .= '<img src="'.$gravatar.'" class="'.$class.'" alt="'.$alt.'" height="100" width="100"/>';
		}
	}
	

}
return apply_filters( 'bne_testimonials_image', $output, $atts );