<?php
/*
 *	Stats Shortcode Display
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
*/


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


	

/*
 * 	Display Stats Shortcode
 *	Aggregates and displays review counts as a bar graph or face chart.
 *
 *	@since 		v2.4.2
 *	@udpated	v2.7.2
 *
*/
function bne_testimonials_stats_shortcode( $atts ) {
	$atts = shortcode_atts( array(
		// Query
		'category'				=>	'',				// Taxonomy: slug | comma separated slugs
		'order'					=>	'desc',			// Summary direction: asc | desc

		// Style / Layout
		'color'					=>	'#337ab7',		// Bar color: #hex | color name
		'label'					=>	'above',		// Label location: above | side
		'label_text'			=>	'Star',			// Name of the label: Star
		'theme'					=>	'simple',		// Styled Theme: simple
		'layout'				=>	'bar',			// Type of display: bar | face
		
		// Manual Totals
		'total_5'				=>	'',
		'total_4'				=>	'',
		'total_3'				=>	'',
		'total_2'				=>	'',
		'total_1'				=>	'',
		
		
		// Other
		'class'					=>	''
	), $atts, 'bne_testimonials_stats' );

	
	// BNE Testimonials Category Args
	$taxonomy_args = null;
	if( $atts['category'] ) {
		$taxonomy_args = array(
	        array(
	            'taxonomy' 	=> 	'bne-testimonials-taxonomy',
	            'field' 	=> 	'slug',
	            'terms' 	=> 	explode( ',', esc_html( $atts['category'] ) )
	        )
	    );
	}

	// BNE Testimonial Query 
	$query_args = apply_filters( 'bne_testimonials_query_args', array(
		'post_type'			=>	'bne_testimonials',
		'posts_per_page'	=>	'-1',
	    'meta_query' 		=> array(
	        array(
	            'key' 			=> 	'rating',
	            'value' 		=> 	'0',
	            'compare' 		=>	'>'
	        )
	    ),
		'tax_query' 		=> 	$taxonomy_args
	) );
	$testimonials = get_posts( $query_args );

	
	/*
	 * 	Loop thru each testimonial and count
	 * 	the rating values
	*/
	$rating_counts = array(
		'1'	=>	'0',
		'2'	=>	'0',
		'3'	=>	'0',
		'4'	=>	'0',
		'5'	=>	'0',
	);
	foreach( $testimonials as $testimonial ) {
		$rating = get_post_meta( $testimonial->ID, 'rating', true );
		$rating_counts[$rating] += 1;
	}


	/*
	 * 	Each total value can be manually set from the shortcode
	 *	and if any are found, replace the inital $rating_counts array.
	*/
	$manual_rating_counts = array(
		'1'	=>	$atts['total_1'],
		'2'	=>	$atts['total_2'],
		'3'	=>	$atts['total_3'],
		'4'	=>	$atts['total_4'],
		'5'	=>	$atts['total_5'],
	);
	
	// Replace queried counts with final manual entries.
	$rating_counts = array_replace( $rating_counts, array_filter( $manual_rating_counts ) );


	// Total number of reviews from query
	$total = array_sum( $rating_counts );
	
	
	// Adjust Order
	if( 'desc' == $atts['order'] ) {
		$rating_counts = array_reverse($rating_counts, true);
	}


	// Category class
	$category = ($atts['category']) ? str_replace(',', '-', esc_html( $atts['category'] ) ) : 'all';
	$category = sanitize_title_with_dashes( $category );
	

	// Begin Output
	$output = '<div class="bne-testimonial-wrapper testimonial-stats theme-'.$atts['theme'].' label-'.$atts['label'].' layout-'.$atts['layout'].' testimonial-category-'.$category.' '.$atts['class'].' clearfix">';

		$output .= '<div class="rating-summary clearfix" data-count="'.$total.'">';

			
			// Bar Chart Layout
			if( $atts['layout'] == 'bar' ) {
			
				// Loop thru each rating set
				foreach( $rating_counts as $rating => $count ) {
					
					// Define the percent value
					$percent = ( $count > 0 ) ? ( $count / $total ) * 100 : 0;
					$percent = floatval( number_format( $percent, 0, '.', '' ) );
					
					// Adjust label position for low percent values
					$label_adjustment = ( $percent < 20 ) ? 'left:5px; right: auto;' : '';
					
					// Summary Rating
					$output .= '<div class="rating-summary-inner rating-summary-'.$rating.'">';
						
						// Labels
						$output .= '<span class="rating-title">'.$rating.' '.$atts['label_text'].'</span>';
						$output .= '<span class="rating-count">'.$count.'</span>';
						
						// Bar
						$output .= '<div class="rating-bar" data-rating="'.$rating.'" role="progressbar" tabindex="0" aria-valuenow="'.$percent.'" aria-valuemin="0" aria-valuetext="'.$percent.'%" aria-valuemax="100">';
							$output .= '<div class="rating-bar-inner" style="background:'.$atts['color'].';width:'.$percent.'%;" data-percent="'.$percent.'"><span class="rating-percent" style="'.$label_adjustment.'">'.$percent.'%</span></div>';
						$output .= '</div>';

					$output .= '</div><!-- .rating-summary-inner (end) -->';
				
				} // End Loop
			} // End Bar Layout



			// Face Chart Layout
			if( $atts['layout'] == 'face' ) {
				
				// Group Ratings into three "moods"
				$good_count = $rating_counts['4'] + $rating_counts['5'];
				$meh_count = $rating_counts['3'];
				$poor_count = $rating_counts['1'] + $rating_counts['2'];
				
				// Define the Faces Array
				$faces = array(
					array(
						'group'		=>	'poor',
						'icon'		=>	'frown',
						'percent'	=>	floatval( number_format( ( $poor_count / $total ) * 100, 0, '.', '' ) ),
						'total'		=>	$poor_count
					),
					array(
						'group'		=>	'meh',
						'icon'		=>	'meh',
						'percent'	=>	floatval( number_format( ( $meh_count / $total ) * 100, 0, '.', '' ) ),
						'total'		=>	$meh_count
					),
					array(
						'group'		=>	'good',
						'icon'		=>	'smile',
						'percent'	=>	floatval( number_format( ( $good_count / $total ) * 100, 0, '.', '' ) ),
						'total'		=>	$good_count
					),
				);
				
				// Adjust Order
				if( 'desc' == $atts['order'] ) {
					$faces = array_reverse($faces, true);
				}
				
				// Loop through each face statistics			
				foreach( $faces as $face ) {
					$output .= '<div class="rating-summary-inner rating-'.$face['group'].'">';
						$output .= '<div class="bne-icon-'.$face['icon'].'"></div>';
						$output .= '<span class="rating-percent">'.$face['percent'].'%</span>';
						$output .= '<span class="rating-count">'.$face['total'].' '.$atts['label_text'].'</span>';
					$output .= '</div>';
				}
						
			} // END Face Layout

		$output .= '</div><!-- .rating-summary (end) -->';
	$output .= '</div><!-- .testimonial-stats (end) -->';
	
	return $output;

}
add_shortcode( 'bne_testimonials_stats', 'bne_testimonials_stats_shortcode' );