<?php
/*
 *	Main Shortcode Display
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;



/*
 *	Shortcode
 *	
 *	@since		v2.0
 *	@updated	v2.9.13
*/
function bne_testimonials_shortcode( $atts ) {
	$atts = shortcode_atts( array(

		
		/*
		 *	Query Arguments
		 *	These control what is pulled from the database.
		 *
		*/		
		'post'				=> 	'',				// (depreciated) (-1) Query this number of testimonials. 
		'limit'				=>	'-1',			// (-1) Query this number of testimonials. (replaces "post")
		'id'				=> 	'',				// ('') Query only this testimonial post ID.
		'category'			=>	'',				// ('') Query only this category of testimonials.
		'order'				=>	'desc',			// (desc) Direction of testimonials. Options: asc or desc
		'orderby'			=>	'date',			// (date) Order of testimonials. Options: name, date, rand, etc
		'pagination'		=> 	'false',		// (false) Pagination for list and masonry displays.
		'rating_min'		=>	'',				// Limits testimonials with this rating or greater


		/*
		 *	Display Arguments
		 *	These control structure and style of the testimonials.
		 *
		*/		
		'layout'			=>	'list',			// (list) Options: list, slider, masonry
		'theme'				=>	'default',		// (default) Options: default, cards-v, cards-h, simple, bubble
		'arrangement'		=>	'1',			// (1) Options: 1 - author then message, 2 - message then author
		'alignment'			=>	'left',			// (left) Options: left, center, right
		'image_style'		=>	'square',		// (square) Options: circle, square, flat-circle, flat-square
		'image_size'		=>	'thumbnail',	// (thumbnail) Options: Any WP crop sizes
		'expand'			=>	'',				// (int) Allows hiding further testimonials after this number (list only)
		'expand_more'		=>	'Show More',	// (Show More) Text used in the expand hidden testimonials link
		'expand_less'		=>	'Show Less',	// (Show Less) Text used in the expanded testimonials link


		/*
		 *	Content Arguments
		 *	These control what information is displayed within the testimonial.
		 *
		*/		
		'name'				=>	'true',			// (true) Show/Hide the testimonial name. Options: ture or false
		'image'				=>	'true',			// (true) Show/Hide the testimonial image. Options: ture or false
		'tagline'			=>	'true',			// (true) Show/Hide the testimonial tagline. Options: ture or false
		'website'			=>	'true',			// (true) Show/Hide the testimonial website. Options: ture or false
		'rating'			=>	'true',			// (true) Show/Hide the testimonial rating/stars. Options: ture or false
		'readmore'			=>	'false',		// (false) Shorten the message with a readmore link
		'readmore_limit'	=>	'250',			// (250) Truncates the text to this character limit.
		'readmore_text'		=>	'Read More',	// (Read More) Text used in the readmore link
		'readless_text'		=>	'Read Less',	// ('') Text used in the readmore link


		/*
		 *	Theme Color Arguments
		 *	These control how the sections of the testimonial are styled. (font and bg only).
		 *
		*/		
		'author_bg_color'	=>	'',				// ('') Author section background color. Options: hex color value or color name.
		'author_color'		=>	'',				// ('') Author section font color. Options: hex color value or color name.
		'message_bg_color'	=>	'',				// ('') Message section background color. Options: hex color value or color name.
		'message_color'		=>	'',				// ('') Message section font color. Options: hex color value or color name.
		'rating_color'		=>	'',				// ('') Rating / stars color. Options: hex color value or color name.


		/*
		 *	Slider Layout Only Arguments
		 *	These control how slider is displayed
		 *
		*/
		'nav' 				=>	'true',			// (true) Flexslider: controlNav
		'arrows' 			=>	'true',			// (true) Flexslider: directionNav
		'pause' 			=>	'true',			// (true) Flexslider: pauseOnHover
		'animation' 		=>	'slide',		// (slide) Flexslider: animation
		'animation_speed'	=>	'700',			// (700) Flexslider: animationSpeed
		'smooth' 			=>	'true',			// (true) Flexslider: smoothHeight
		'speed'				=>	'7000',			// (7000) Flexsliser: slideshowSpeed


		/*
		 *	List, Masonry & Slider Layouts Only
		 *
		*/
		'columns'			=>	'',				// (int) Number of Columns.


		/*
		 *	Schema Arguments
		 *	These allow adjusting how the schema markup
		 *	is used such as specifying if multiple
		 *
		*/
		'schema'			=>	'true',						// Enable schema markup
		'schema_type'		=>	'Product',					// The Schema Type for this review, typically "Product"
		'schema_name'		=>	get_bloginfo( 'name' ),		// The Product Name. Default is the current site title
		'schema_image'		=>	'',							// The logo of the product or business
		//'schema_item_type'	=>	'Service',


		/*
		 *	Other Arguments
		 *
		*/
		'class'				=>	'',				// ('') Adds custom css classnames to the testimonial wrapper.
		'custom'			=>	'',				// Pulls in the generated shortcode build instead.

	), $atts, 'bne_testimonials' );


	// Check if we should use a generated shortcode build out first!
	if( $atts['custom'] ) {
		$id = get_post_meta( $atts['custom'], '_bne_testimonials_sg_shortcode', true );
		if( $id ) {
			$output = '<!-- Testimonial Generated Shortcode ID '.$atts['custom'].' -->';
			$output .= do_shortcode( get_post_meta( $atts['custom'], '_bne_testimonials_sg_shortcode', true ) );
			return $output;
		} else {
			return '<div class="bne-testimonial-warning">'.sprintf( __( 'The testimonial shortcode ID, %s, is not available. Make sure this generated shortcode is still available.', 'bne-testimonials' ),'<strong>'.$atts['custom'].'</strong>' ).'</div>';
		}
	}


	// Taxonomy Query Args
	$taxonomy_args = null;
	if( $atts['category'] ) {
		$taxonomy_args = array(
	        array(
	            'taxonomy' 	=> 	'bne-testimonials-taxonomy',
	            'field' 	=> 	'slug',
	            'terms' 	=> 	explode( ',', esc_html( $atts['category'] ) )
	        )
	    );
	}

	
	// Backwards compatibility - Replaced "post" with "limit"
	if( $atts['post'] ) { $atts['limit'] = $atts['post']; }


	// Post Query Args
	$query_args = apply_filters( 'bne_testimonials_query_args', array(
		'post_type' 		=>	'bne_testimonials',
		'page_id'		=> 	$atts['id'],
		'order'			=> 	$atts['order'],
		'orderby' 		=> 	$atts['orderby'],
		'posts_per_page'	=> 	$atts['limit'],
		
		// Taxonomy Query
	    'tax_query' 		=> 	$taxonomy_args
	) );
	

	/*
	 * 	Rating Type Query
	 *	If rating_min is defined, only query reviews that are
	 *	at lest the rating_min value.
	 * 
	*/
	if( $atts['rating_min'] && $atts['rating_min'] < 6 ) {
	    $query_args['meta_query'] = array(
	        array(
	            'key' 			=> 	'rating',
	            'value' 		=> 	$atts['rating_min'],
	            'compare' 		=>	'>='
	        )
	    );
	}
	

	// Setup Pagination
	if( $atts['pagination'] == 'true' ) {
		if( get_query_var( 'paged' ) ) {
			$query_args['paged'] = get_query_var('paged');
		} elseif( get_query_var( 'page' ) ) {
			$query_args['paged'] = get_query_var( 'page' );
		} else {
			$query_args['paged'] = 1;
		}
	}


	// Set Random ID's
	$wrapper_id = rand(1,1000);
	$slider_id = rand( 1,1000 );
	$masonry_id = rand( 1,1000 );


	// Single Testimonial
	if( $atts['id'] ) { 
		$atts['layout'] = 'single';
		$atts['schema_aggregate'] = 'false';
	}


	// List
	if( 'list' == $atts['layout'] && ( (int) $atts['columns'] > 1 ) ) {
		// Make sure we're not using more columns than possible
		if( $atts['columns'] > 4 ) { $atts['columns'] = 4; }
		
		$atts['class'] .= ' list-columns columns-'.$atts['columns'];
	}

	
	// Masonry
	if( 'masonry' == $atts['layout'] && !$atts['columns'] ) {
		// Set Default
		$atts['columns'] = '3';
	}


	// Thumb
	if( 'thumbnail' == $atts['layout'] || 'thumbs' == $atts['layout'] ) { 
		$atts['layout'] = 'thumbs';
		$atts['theme'] = ('default' == $atts['theme'] ) ? 'simple' : $atts['theme'];
		
		// Make sure we only query those with thumbnails
		// Replaced with fallback thumbnail (mystery man)
		/*
		$thumb = array( 'key' => '_thumbnail_id' );
		if( isset( $query_args['meta_query'] ) ) {
			array_merge($thumb, $query_args['meta_query'] );
		} else {
			$query_args['meta_query'] = array ( $thumb );
		}
		*/
	}


	// Slider Columns
	$slider_col_js = null;
	$slider_col_flex = null;
	if( 'slider' == $atts['layout'] && ( (int) $atts['columns'] > 1 ) ) {
		
		// Add styling class
		$atts['class'] .= ' has-slide-groups';
		
		// Group testimonials into groups based on columns
		$slider_col_js = '
			var fs = $("#bne-slider-id-'.$slider_id.'"),
			    item = fs.find(".testimonial-single");
			for (var i = 0; i < item.length; i+='.$atts['columns'].') {
				item.slice(i, i+'.$atts['columns'].').wrapAll("<div class=\"slide-group\"></div>");
			}
			item.css("width","'.(100 / $atts['columns']).'%");
		';
		
		// Adjust where flexslider should cycle with
		$slider_col_flex = 'selector: ".slides > .slide-group",';

	}




	/*
	 * 	Schema Data Setup
	 *
	 *	Collects all schema data for the item being reviewed 
	 *	and the aggragate rating.
	 *
	 *	$schema_header sets the schema type being reviewed
	 *	$schema_header_single sets the individual review that is reviewing the type
	 *
	 *	We need to do an additional query outside of the requested loop so that we
	 *	can correctly account for the rating and total.
	 *
	*/
	$schema_header = '';
	$schema_header_single = '';
	$atts['schema_data'] = '';
	if( 'true' == $atts['schema'] ) {
		
		// Make a new query to get the correct total and average rating of all testimonials of the main query used
		$schema_query_args = $query_args;
		$schema_query_args['posts_per_page'] = '-1'; 
		$schema_testimonials = get_posts( $schema_query_args );
		$aggregateRating = bne_testimonials_calculate_rating( $schema_testimonials );

		// Set the Data
		$atts['schema_data'] = array(
			'type'				=>	$atts['schema_type'],
			'name'				=>	$atts['schema_name'],
			'image'				=>	$atts['schema_image'],
			'aggregateRating'	=>	$aggregateRating
		);
		
		$schema_header = bne_testimonials_get_schema( 
			$atts['schema'], 
			'header',
			$atts['schema_data']['type']
		);
		
		$schema_header_single = bne_testimonials_get_schema( 
			$atts['schema'], 
			'header/review'
		);
	}



	// Begin the query
	$bne_testimonials_query = new WP_Query( $query_args );
	if( $bne_testimonials_query->have_posts() ) {
	

		// Readmore Script
		if( 'true' == $atts['readmore'] ) {
			wp_enqueue_script( 'curtail' );
			wp_add_inline_script( 'curtail', 
				'jQuery(document).ready(function($){
					// Testimonial Readmore JS
				    $(".testimonial-wrapper-id-'.$wrapper_id.' .testimonial-message.message-limit").curtail({
					    limit: '.$atts['readmore_limit'].',
					    toggle: true,
					    text: ["'.esc_html( $atts['readless_text'] ).'","'.esc_html( $atts['readmore_text'] ).'"]
				    });
					
					// Expand message
					$(".testimonial-wrapper-id-'.$wrapper_id.' .testimonial-message .readmore").on("click", function() {
						$(this).parent().toggleClass("expanded");
						
						// Check if there is masonry grid on the page and reload it
						if( $(".bne-testimonial-masonry-wrapper").length ) {
							$(this).closest(".bne-testimonial-masonry-wrapper").masonry();
						}
						
						// Check if there is slider on the page and reload it
						if( $(".bne-testimonial-slider").length ) {
							$(this).closest(".flex-active-slide, .slide-group").resize();
						}
					});
				});'
			);
		}	
		

		
		// Category class
		$category = ($atts['category']) ? str_replace(',', '-', esc_html( $atts['category'] ) ) : 'all';
		$category = sanitize_title_with_dashes( $category );


		// Classes
		$wrapper_classes = array(
			'bne-testimonial-wrapper',
			'testimonial-wrapper-id-'.$wrapper_id,
			'testimonial-layout-'.$atts['layout'],
			'testimonial-theme-'.$atts['theme'],
			'testimonial-'.$atts['alignment'],
			'testimonial-arrangement-'.$atts['arrangement'],
			'testimonial-category-'.$category,
			$atts['class'],
			'clearfix'
		);

	
		// Open Wrapper
		$output = '<div class="'.implode(' ', $wrapper_classes).'"'.$schema_header.'>';

			// Schema Data Output: Item Being Reviewed
			$output .= bne_testimonials_get_schema( 
				$atts['schema'], 
				'type',
				$atts['schema_data']
			);

			// General Counter
			$i = 1;


			/*
			 *	Devs - Before Testimonial Filter
			 *
			 *	Allow devs to extend content before the testimonial.
			 *
			*/
			$output .= apply_filters( 'bne_testimonials_before', '' );



			/*
			 *	Slider Layout
			 *
			 *	If using the slider layout, output the
			 *	necessary scripts and structure.
			 *
			*/
			if( 'slider' == $atts['layout'] ) {
				
				// Enqueue Flexslider script
				wp_enqueue_script( 'flexslider' );

				// Init Flexslider
				wp_add_inline_script( 'flexslider', 
					'jQuery(document).ready(function($){
						'.$slider_col_js.'
						$("#bne-slider-id-'.$slider_id.' .bne-testimonial-slider").flexslider({
							'.$slider_col_flex.'
							animation: "'.$atts['animation'].'",
							animationSpeed: '.$atts['animation_speed'].',
							smoothHeight: '.$atts['smooth'].',
							pauseOnHover: '.$atts['pause'].',
							controlNav: '.$atts['nav'].',
							directionNav: '.$atts['arrows'].',
							slideshowSpeed: '.$atts['speed'].'
						});
					});'
				);

				// Slider Wrapper
				$output .= '<div id="bne-slider-id-'.$slider_id.'" class="bne-testimonial-slider-wrapper">';

					$output .= '<div class="slides-inner">';
						$output .= '<div class="bne-testimonial-slider bne-flexslider">';
							$output .= '<ul class="slides">';
				
								// Begin Testimonial Loop!
								while( $bne_testimonials_query->have_posts() ) : $bne_testimonials_query->the_post();
										
										$output .= '<li id="testimonial-id-'.get_the_ID().'" class="testimonial-single"'.$schema_header_single.'>';
											$output .='<div class="flex-content">';
												$output .= bne_testimonials_get_template( 'single', $atts );
												$output .= '<div class="clear"></div>';	
											$output .= '</div>';
										$output .= '</li>';										
								
								endwhile; // END the Loop!
						
							$output .= '</ul> <!-- .slides (end) -->';
						$output .= '</div> <!-- .bne-testimonial-slider (end) -->';
					$output .= '</div> <!-- .slides-inner (end) -->';
				$output .= '</div> <!-- .bne-testimonial-slider-wrapper (end) -->';

			}



			/*
			 *	Thumbnail Slider Layout
			 *
			 *	If using the thumbs layout, output the
			 *	necessary structure.
			 *
			*/
			elseif( 'thumbs' == $atts['layout'] ) {
				
				// Assign Overrides:
				$atts['alignment'] = 'right';
				
				// Enqueue Flexslider script
				wp_enqueue_script( 'flexslider' );
							
				// Init Flexslider
				wp_add_inline_script( 'flexslider', 
					'jQuery(document).ready(function($){
						$("#bne-slider-id-'.$slider_id.' .bne-testimonial-slider").flexslider({
							animation: "'.$atts['animation'].'",
							animationSpeed: '.$atts['animation_speed'].',
							smoothHeight: '.$atts['smooth'].',
							slideshow: true,
							pauseOnHover: '.$atts['pause'].',
							controlsContainer: $("#bne-slider-id-'.$slider_id.' .thumbs-wrapper"),
							controlNav: "thumbnails",
							directionNav: false,
							slideshowSpeed: '.$atts['speed'].'
						});
					});'
				);
				
				// Slider Wrapper
				$output .= '<div id="bne-slider-id-'.$slider_id.'" class="bne-testimonial-slider-wrapper clearfix">';
					$output .= '<div class="slides-inner">';							
													
						// Control Nav (Thumbs)
						if( '1' == $atts['arrangement'] ) {
							$output .= '<div class="thumbs-wrapper thumb-'.$atts['image_style'].'"></div>';
						}

						$output .= '<div class="bne-testimonial-slider bne-flexslider">';
							$output .= '<ul class="slides">';
				
								// Begin Testimonial Loop!
								while( $bne_testimonials_query->have_posts() ) : $bne_testimonials_query->the_post();
										
										$thumb = get_the_post_thumbnail_url( null, 'thumbnail' );
										// Fallback thumbnail
										if( !$thumb ) {
											$thumb = BNE_TESTIMONIALS_URI.'/assets/images/blank-thumb2.jpg';
										}
										
										$output .= '<li id="testimonial-id-'.get_the_ID().'" class="testimonial-single" data-thumb="'.$thumb.'"'.$schema_header_single.' >';
											$output .='<div class="flex-content">';
												$output .= bne_testimonials_get_template( 'single', $atts );
												$output .= '<div class="clear"></div>';	
											$output .= '</div>';
										$output .= '</li>';										
								
								endwhile; // END the Loop!
						
							$output .= '</ul> <!-- .slides (end) -->';
						$output .= '</div> <!-- .bne-testimonial-slider (end) -->';
					
						// Control Nav (Thumbs)
						if( '2' == $atts['arrangement'] ) {
							$output .= '<div class="thumbs-wrapper thumb-'.$atts['image_style'].'"></div>';
						}

					$output .= '</div> <!-- .slides-inner (end) -->';
				$output .= '</div> <!-- .bne-testimonial-slider-wrapper (end) -->';

			}



			/*
			 *	Masonry Layout
			 *
			 *	If using the Masonry layout, output the
			 *	necessary structure.
			 *
			*/
			elseif( 'masonry' == $atts['layout'] ) {
				
				// Make sure we're not using more columns than possible
				if( $atts['columns'] > 4 ) { $atts['columns'] = 4; }
				
				// Enqueue Masonry script
				wp_enqueue_script( 'masonry' );
				
				// Init Masonry
				wp_add_inline_script( 'masonry', 
					'jQuery(document).ready(function($){
						$("#masonry-id-'.$masonry_id.'").masonry({
							itemSelector: \'.testimonial-single\',
							columnWidth: \'.testimonial-single\',
							percentPosition: true
						});
						$("#masonry-id-'.$masonry_id.'").addClass("masonry-loaded");
					});'
				);

				$output .= '<div id="masonry-id-'.$masonry_id.'" class="bne-testimonial-masonry-wrapper">';
					
					// Begin Testimonial Loop!
					while( $bne_testimonials_query->have_posts() ) : $bne_testimonials_query->the_post();


						/*
						 *	Expansion of hidden testimonials
						 *
						 *	The list layout allows hidding testimonials after X and
						 *	includes a show/hide link. These hidden testimonials triggered using
						 *	the expander links below and JS.
						 *
						 *	Once $atts['expand'] is reached based on the current count, the 
						 *	remainder receives the hidden class.
						 *
						*/
						$hidden = '';
						if( (int) $atts['expand'] ) {
							wp_enqueue_script('expander', BNE_TESTIMONIALS_URI . '/assets/js/jquery.expand.js', array( 'jquery' ), BNE_TESTIMONIALS_VERSION, true );
							if( $i > $atts['expand'] ) {
								$hidden = 'testimonial-hidden';
							}
							$i++;
						}

						
						$output .= '<div id="testimonial-id-'.get_the_ID().'" class="testimonial-single col-'.$atts['columns'].'-masonry '.$hidden.'"'.$schema_header_single.'>';
							$output .= bne_testimonials_get_template( 'single', $atts );	
							$output .= '<div class="clear"></div>';	
						$output .= '</div>';
										
					endwhile; // END the Loop!

				$output .= '</div>';
			}	



			/*
			 *	List / Default Layout
			 *
			 *	If using the list layout or no layout, output the
			 *	necessary structure.
			 *
			*/
			else {
				
				// Begin Testimonial Loop!
				while( $bne_testimonials_query->have_posts() ) : $bne_testimonials_query->the_post();

					
					/*
					 *	Expansion of hidden testimonials
					 *
					 *	The list layout allows hidding testimonials after X and
					 *	includes a show/hide link. These hidden testimonials triggered using
					 *	the expander links below and JS.
					 *
					 *	Once $atts['expand'] is reached based on the current count, the 
					 *	remainder receives the hidden class.
					 *
					*/
					$hidden = '';
					if( (int) $atts['expand'] ) {
						wp_enqueue_script('expander', BNE_TESTIMONIALS_URI . '/assets/js/jquery.expand.js', array( 'jquery' ), BNE_TESTIMONIALS_VERSION, true );
						if( $i > $atts['expand'] ) {
							$hidden = 'testimonial-hidden';
						}
						$i++;
					}

				
					$output .= '<div id="testimonial-id-'.get_the_ID().'" class="testimonial-single clearfix '.$hidden.'"'.$schema_header_single.'>';
						$output .= bne_testimonials_get_template( 'single', $atts );	
						$output .= '<div class="clear"></div>';	
					$output .= '</div>';

				endwhile; // END the Loop!

			}



			
			// Expand Triggers for Hidden Testimonials
			if( (int) $atts['expand'] ) {
				$output .= '<div class="clear"></div>';
				$output .= '<a href="#" class="testimonials-expander testimonial-hidden active active-opacity expand-more">'.$atts['expand_more'].'</a>';
				$output .= '<a href="#" class="testimonials-expander testimonial-hidden expand-less">'.$atts['expand_less'].'</a>';
			}





			/*
			 *	Devs - After Testimonial Filter
			 *
			 *	Allow devs to extend content after the testimonial.
			 *
			*/
			$output .= apply_filters( 'bne_testimonials_after', '' );



			/*
			 *	Pagination
			 *
			 *	List and Masonry Layouts only
			 *
			*/
			if( ( $atts['pagination'] == 'true' ) && ( 'slider' != $atts['layout'] ) ) {

				$output .= '<div class="bne-testimonial-pagination">';

					$big = 999999;
					$output .= paginate_links( array(
						'base'		=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format'	=> '?paged=%#%',
						'current'	=> max( 1, $query_args['paged'] ),
						'type'		=> 'plain',
						'prev_text'	=> '&laquo;',
						'next_text'	=> '&raquo;',
						//'show_all'	=>	true,
						'total'		=> $bne_testimonials_query->max_num_pages
					) );

				$output .= '</div><!-- .bne-testimonial-pagination (end) -->';
			}


		// Close the wrapper!
		$output .= '</div><!-- .bne-testimonials-wrapper (end) -->';

	} else {
		$output = '<div class="bne-testimonial-warning none-warning">'.__('No testimonials were found.', 'bne-testimonials').'</div>';
	}

	// Reset Query and Return output
	wp_reset_postdata();
	return $output;
	
}
add_shortcode( 'bne_testimonials', 'bne_testimonials_shortcode' );