<?php
/*
 *	API Shortcode Display
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;



/*
 *	API Shortcode Display
 *
 *	Roughly the same as bne_testimonials_shortcode() altered
 *	to support the API JSON response.
 *	
 *	@since 		v2.3
 *	@updated	v2.9.10
 *
*/
function bne_testimonials_shortcode_api( $atts ) {
	$atts = shortcode_atts( array(

		
		/*
		 *	Testimonial Query Arguments
		 *	These control what is pulled from the database.
		 *
		*/		
		'post'				=> 	'',				// (depreciated) (20) Query this number of testimonials. 
		'limit'				=>	'20',			// (20) Query this number of testimonials. (replaces "post")
		'category'			=>	'',				// ('') Query only this category of testimonials.
		'order'				=>	'desc',			// (desc) Direction of testimonials. Options: ASC or DESC
		'orderby'			=>	'date',			// (date) Options: title or date


		/*
		 *	Display Arguments
		 *	These control structure and style of the testimonials.
		 *
		*/		
		'layout'			=>	'list',			// (list) Options: list, slider, masonry
		'theme'				=>	'default',		// (default) Options: default, cards-v, cards-h, simple, bubble
		'arrangement'		=>	'1',			// (1) Options: 1 - author then message, 2 - message then author
		'alignment'			=>	'left',			// (left) Options: left, center, right
		'image_style'		=>	'square',		// (square) Options: circle, square, flat-circle, flat-square
		'image_size'		=>	'thumbnail',	// (thumbnail) Options: Any WP crop sizes
		'expand'			=>	'',				// (int) Allows hiding further testimonials after this number (list only)
		'expand_more'		=>	'Show More',	// (Show More) Text used in the expand hidden testimonials link
		'expand_less'		=>	'Show Less',	// (Show Less) Text used in the expanded testimonials link


		/*
		 *	Content Arguments
		 *	These control what information is displayed within the testimonial.
		 *
		*/		
		'name'				=>	'true',			// (true) Show/Hide the testimonial name. Options: ture or false
		'image'				=>	'true',			// (true) Show/Hide the testimonial image. Options: ture or false
		'tagline'			=>	'true',			// (true) Show/Hide the testimonial tagline. Options: ture or false
		'website'			=>	'true',			// (true) Show/Hide the testimonial website. Options: ture or false
		'rating'			=>	'true',			// (true) Show/Hide the testimonial rating/stars. Options: ture or false
		'rating_total'		=>	'',
		'readmore'			=>	'false',		// (false) Shorten the message with a readmore link
		'readmore_limit'	=>	'250',			// (250) Truncates the text to this character limit.
		'readmore_text'		=>	'Read More',	// (Read More) Text used in the readmore link
		'readless_text'		=>	'',				// ('') Text used in the readmore link


		/*
		 *	Theme Color Arguments
		 *	These control how the sections of the testimonial are styled. (font and bg only).
		 *
		*/		
		'author_bg_color'	=>	'',				// ('') Author section background color. Options: hex color value or color name.
		'author_color'		=>	'',				// ('') Author section font color. Options: hex color value or color name.
		'message_bg_color'	=>	'',				// ('') Message section background color. Options: hex color value or color name.
		'message_color'		=>	'',				// ('') Message section font color. Options: hex color value or color name.
		'rating_color'		=>	'',				// ('') Rating / stars color. Options: hex color value or color name.


		/*
		 *	Slider Layout Only Arguments
		 *	These control how slider is displayed
		 *
		*/
		'nav' 				=>	'true',			// (true) Flexslider: controlNav
		'arrows' 			=>	'true',			// (true) Flexslider: directionNav
		'pause' 			=>	'true',			// (true) Flexslider: pauseOnHover
		'animation' 		=>	'slide',		// (slide) Flexslider: animation
		'animation_speed'	=>	'700',			// (700) Flexslider: animationSpeed
		'smooth' 			=>	'true',			// (true) Flexslider: smoothHeight
		'speed'				=>	'7000',			// (7000) Flexsliser: slideshowSpeed


		/*
		 *	List, Masonry & Slider Layouts Only
		 *
		*/
		'columns'			=>	'',				// (int) Number of Columns.


		/*
		 *	Schema Arguments
		 *	These allow adjusting how the schema markup
		 *	is used such as specifying if multiple
		 *
		*/
		'schema'			=>	'true',						// Enable schema markup
		'schema_type'		=>	'Product',					// The Schema Type for this review, typically "Product"
		'schema_name'		=>	get_bloginfo( 'name' ),		// The Product Name. Default is the current site title.
		'schema_image'		=>	'',							// The Product Image. Should be used if schema_name is LocalBusiness
		//'schema_item_type'	=>	'Service',


		/*
		 *	API Arguments
		 *
		*/
		'url'				=>	'',				// The source site URL to query from (local only)
		'source'			=>	'local',		// The source type of the API (google, yelp, local)
		'cache'				=>	'true',			// Cache the results for 1 day
		'key'				=>	'',				// The Google API Key or Facebook Token
		'id'				=>	'',				// Google PlaceID, Yelp business ID or Facebook Page ID/Name
		'rating_min'		=>	'',				// Limits testimonials with this rating or greater
		'message_required'	=>	'false',		// Only display reviews with a message
		'branding'			=>	'true',			// Displays the branding of the source site (non local)

		/*
		 *	Other Arguments
		 *
		*/
		'class'				=>	''				// ('') Adds custom css classnames to the testimonial wrapper.

	), $atts, 'bne_testimonials_api' );


	// Backwards compatibility - Replaced "post" with "limit"
	if( $atts['post'] ) { $atts['limit'] = $atts['post']; }


	// Query Options
	$query_args = array(
		'limit'		=>	$atts['limit'],
		'order'		=>	$atts['order'],
		'orderby'	=>	$atts['orderby']
	);

	
	// Configure the Category Argument
	if( $atts['category'] ) {
		$query_args['category'] = esc_html( $atts['category'] );
	}


	// Make sure $source is lowercase
	if( $atts['source'] ) {
		$atts['source'] = strtolower($atts['source']);
	} 


	/*
	 *	Mix API Request
	 *
	 *	Testimonial API's can now be combined into a single instance.
	 *	Each response is still cached normally via the API, but will
	 *	be merged before output.
	 *
	 *	both $atts['source'] and $atts['id'] need to be used with each
	 *	request separated by a "|" vertical bar. In addition, the order
	 *	of both must match in order.
	 *
	*/
	$using_mix = false;
	if( ( strpos( $atts['source'], '|') !== false) || ( strpos( $atts['source'], ',') !== false ) ) {
		
		// Remove any possible white space and set new deliminator ","
		$atts['source'] = str_replace( '|', ',', $atts['source'] );
		$atts['source'] = str_replace( ' ', '', $atts['source'] );
		$atts['id'] = str_replace( '|', ',', $atts['id'] );
		$atts['id'] = str_replace( ' ', '', $atts['id'] );
		
		// Split the sources and ID using two arrays
		$mix_sources = explode(',', $atts['source'] );
		$mix_ids = explode(',', $atts['id'] );
		
		// Open a collection array
		$testimonials_mix = array();
		$mixed_rating = array();
		$mixed_total = array();
		
		// Loop through each source API
		foreach( $mix_sources as $index => $mix_source ) {
			// Allow local (WP) reviews
			if( 'local' == $mix_source ) {
				$atts['url'] = $mix_ids[$index];
			}
			// Request Reviews from this source using the matched index of the ID
			$testimonials = bne_testimonials_api_request( $mix_source, null, $atts['url'], $mix_ids[$index], $atts['cache'], $query_args );
			
			// Error out if the testimonials are not an array
			if( !is_array( $testimonials ) ) {
				
				echo '<div class="bne-testimonial-warning api-warning">'.esc_html( $testimonials ).'</div>';
			
			} elseif( $testimonials['reviews'] ) {
				
				// For each testimonial, we need to assign the source reference for individual branding
				foreach( $testimonials['reviews'] as $index => $testimonial ) {
					$testimonials['reviews'][$index]['source'] = $mix_source;
				}			
				
				// Merge this testimonial into the collection array
				$testimonials_mix = array_merge( $testimonials_mix, $testimonials['reviews'] );
				$mixed_rating[] = $testimonials['rating'];
				$mixed_total[] = $testimonials['total'];
				
			}		
		
		} // End API Loop
		
		// Set the normal testimonial array and set the $using_mix flag
		$testimonials = $testimonials_mix;
		$using_mix = true;

		// Get Schema Ratings
		$calculated_rating = bne_testimonials_calculate_rating( array(
			'mixed_rating'	=>	$mixed_rating, 
			'mixed_total'	=>	$mixed_total
		), true );
		$schema_api_rating = $calculated_rating['ratingValue'];
		$schema_api_total = $calculated_rating['ratingCount'];


	/*
	 *	Single API Request
	 *
	 *	The normal request to a single API source
	 *
	*/
	} else {
		
		// Fetch the testimonials!
		$testimonials = bne_testimonials_api_request( $atts['source'], $atts['key'], $atts['url'], $atts['id'], $atts['cache'], $query_args );
		
		// Allow injecting a total if one is not included from the API.
		if( empty( $testimonials['total'] ) ) {
			if( $atts['rating_total'] ) {
				$testimonials['total'] = $atts['rating_total'];
			}
		}
		
		// Error out if the testimonials are not an array
		if( !is_array( $testimonials ) ) {
			return '<div class="bne-testimonial-warning api-warning">'.esc_html( $testimonials ).'</div>';
		} else {
			$schema_api_rating = $testimonials['rating'];
			$schema_api_total = $testimonials['total'];
			$testimonials = $testimonials['reviews'];
		}
		
	}


	/*
	 * 	Randomize Testimonials
	 *
	 * 	With the possibility of having many testimonials, we can allow
	 *	the order to be randomized.
	*/
	if( $testimonials ) {
		if( 'rand' == $atts['orderby'] ) {
			shuffle( $testimonials );		
		}
	}


	/*
	 * 	Unset Lower Reviews
	 *	If rating_min is defined, remove reviews that are
	 *	less than the rating_min value.
	 * 
	*/
	if( $atts['rating_min'] && $atts['rating_min'] < 6 ) {
		if( $testimonials ) {
			foreach( $testimonials as $testimonial => $index ) {
				// Account for mixed source
				$source = ( true == $using_mix ) ? $index['source'] : $atts['source'];
			
				$atts['api'] = bne_testimonaials_api_set_fields( $index, $source );
				
				// Facebook Recommendation
				if( 'facebook' == $source ) {
					if( isset( $atts['api']['recommendation'] ) ) {
						if( 'negative' == $atts['api']['recommendation'] ) {
							unset($testimonials[$testimonial]);
						}
					}
					if( $atts['api']['rating'] ) {
						if( $atts['api']['rating'] < $atts['rating_min'] ) {
							unset($testimonials[$testimonial]);
						}
					}
					
	
				// Value Rating Check
				} elseif( $atts['api']['rating'] < $atts['rating_min'] ) {
					unset($testimonials[$testimonial]);
				}
			}					
		}
	}


	/*
	 * 	Unset Testimonials that do not have a message / review
	 * 
	*/
	if( 'true' == $atts['message_required'] ) {
		foreach( $testimonials as $testimonial => $index ) {
			// Account for mixed source
			$source = ( true == $using_mix ) ? $index['source'] : $atts['source'];
		
			$atts['api'] = bne_testimonaials_api_set_fields( $index, $source );
			if( !$atts['api']['message'] ) {
				unset($testimonials[$testimonial]);
			}
		}		
		
	}
			
	// Final check - Make sure we limit the return
	$testimonials = ( is_array( $testimonials ) ) ? array_slice( $testimonials, 0, $atts['limit'] ) : $testimonials;
	

	// Pre-made Branding Styles
	if( 'true' == $atts['branding'] && 'local' != $atts['source'] ) {
		
		// Branding Class
		$atts['class'] .= ' testimonial-branding';
		
		// Branding Styles
		$brand_assets = bne_testimonials_api_branding_assets( $atts['source'] );
		if( $brand_assets ) {
			if( !$atts['rating_color'] ) {
				$atts['rating_color'] = $brand_assets['rating_color'];
			}
		}
		
		// Yelp must remain white stars
		if( $atts['source'] == 'yelp' )  {
			$atts['rating_color'] = $brand_assets['rating_color'];
		}

	}

	
	// Set Random ID's
	$wrapper_id = rand( 1,1000 );
	$slider_id = rand( 1,1000 );
	$masonry_id = rand( 1,1000 );


	// List
	if( 'list' == $atts['layout'] && ( (int) $atts['columns'] > 1 ) ) {
		$atts['class'] .= ' list-columns columns-'.$atts['columns'];
	}


	// Masonry
	if( 'masonry' == $atts['layout'] && !$atts['columns'] ) {
		// Set Default
		$atts['columns'] = '3';
	}


	// Thumb
	if( 'thumbnail' == $atts['layout'] || 'thumbs' == $atts['layout'] ) { 
		$atts['layout'] = 'thumbs';
		$atts['theme'] = ('default' == $atts['theme'] ) ? 'simple' : $atts['theme'];
	}

	
	// Slider Columns
	$slider_col_js = null;
	$slider_col_flex = null;
	if( 'slider' == $atts['layout'] && ( (int) $atts['columns'] > 1 ) ) {
		
		// Add styling class
		$atts['class'] .= ' has-slide-groups';
		
		// Group testimonials into groups based on columns
		$slider_col_js = '
			var fs = $("#bne-slider-id-'.$slider_id.'"),
			    item = fs.find(".testimonial-single");
			for (var i = 0; i < item.length; i+='.$atts['columns'].') {
				item.slice(i, i+'.$atts['columns'].').wrapAll("<div class=\"slide-group\"></div>");
			}
			item.css("width","'.(100 / $atts['columns']).'%");
		';
		
		// Adjust where flexslider should cycle with
		$slider_col_flex = 'selector: ".slides > .slide-group",';

	}
	


	/*
	 * 	Schema Data Setup
	 *
	 *	Collects all schema data for the item being reviewed 
	 *	and the aggragate rating.
	 *
	 *	$schema_header sets the schema type being reviewed
	 *	$schema_header_single sets the individual review that is reviewing the type
	 *
	 *	We need to do an additional query outside of the requested loop so that we
	 *	can correctly account for the rating and total.
	 *
	*/
	$schema_header = '';
	$schema_header_single = '';
	$atts['schema_data'] = '';
	if( 'true' == $atts['schema'] ) {
		
		$atts['schema_data'] = array(
			'type'				=>	$atts['schema_type'],
			'name'				=>	$atts['schema_name'],
			'image'				=>	$atts['schema_image'],
			'aggregateRating'	=>	array(
				'ratingValue'		=>	$schema_api_rating,
				'ratingCount'		=>	$schema_api_total
			)
		);
		
		$schema_header = bne_testimonials_get_schema( 
			$atts['schema'], 
			'header',
			$atts['schema_data']['type']
		);
		$schema_header_single = bne_testimonials_get_schema( 
			$atts['schema'], 
			'header/review'
		);
	}



	/*
	 * 	Start displaying Testimonials
	 * 
	*/
	if( is_array( $testimonials ) && !empty( $testimonials ) ) {
		
		
		// Readmore Script
		if( 'true' == $atts['readmore'] ) {
			wp_enqueue_script( 'curtail' );
			wp_add_inline_script( 'curtail', 
				'jQuery(document).ready(function($){
					// Setup Readmore link
				    $(".testimonial-wrapper-id-'.$wrapper_id.' .testimonial-message.message-limit").curtail({
					    limit: '.$atts['readmore_limit'].',
					    toggle: true,
					    text: ["'.esc_html( $atts['readless_text'] ).'","'.esc_html( $atts['readmore_text'] ).'"]
				    });
					
					// Expand message
					$(".testimonial-wrapper-id-'.$wrapper_id.' .testimonial-message .readmore").on("click", function() {
						$(this).parent().toggleClass("expanded");
						
						// Check if there is masonry grid on the page and reload it
						if( $(".bne-testimonial-masonry-wrapper").length ) {
							$(this).closest(".bne-testimonial-masonry-wrapper").masonry();
						}
						
						// Check if there is masonry grid on the page and reload it
						if( $(".bne-testimonial-slider").length ) {
							$(this).closest(".flex-active-slide, .slide-group").resize();
						}
					});
				});'
			);
		}	

				
		// Classes
		$wrapper_classes = array(
			'bne-testimonial-wrapper',
			'testimonial-wrapper-id-'.$wrapper_id,
			'testimonial-api',
			'testimonial-api-'.( ( true == $using_mix ) ? 'mixed' : 'single' ),
			'testimonial-layout-'.$atts['layout'],
			'testimonial-theme-'.$atts['theme'],
			'testimonial-'.$atts['alignment'],
			'testimonial-arrangement-'.$atts['arrangement'],
			'testimonial-transient-'.$atts['cache'],
			$atts['class'],
			'clearfix'
		);

	
		// Open Wrapper
		$output = '<div class="'.implode(' ', $wrapper_classes).'"'.$schema_header.'>';
	
	
			// Schema Data Output: Item Being Reviewed
			$output .= bne_testimonials_get_schema( 
				$atts['schema'], 
				'type',
				$atts['schema_data']
			);

			// General Counter
			$i = 1;


			/*
			 *	Devs - Before Testimonial Filter
			 *
			 *	Allow devs to extend content before the testimonial.
			 *
			*/
			$output .= apply_filters( 'bne_testimonials_before', '' );


			/*
			 *	Slider Layout
			 *
			 *	If using the slider layout, output the
			 *	necessary scripts and structure.
			 *
			*/
			if( 'slider' == $atts['layout'] ) {
				
				// Enqueue Flexslider script
				wp_enqueue_script( 'flexslider' );
				
				// Init Flexslider
				wp_add_inline_script( 'flexslider', 
					'jQuery(document).ready(function($){
						'.$slider_col_js.'
						$("#bne-slider-id-'.$slider_id.' .bne-testimonial-slider").flexslider({
							'.$slider_col_flex.'
							animation: "'.$atts['animation'].'",
							animationSpeed: '.$atts['animation_speed'].',
							smoothHeight: '.$atts['smooth'].',
							pauseOnHover: '.$atts['pause'].',
							controlNav: '.$atts['nav'].',
							directionNav: '.$atts['arrows'].',
							slideshowSpeed: '.$atts['speed'].'
						});
					});'
				);

				// Slider Wrapper
				$output .= '<div id="bne-slider-id-'.$slider_id.'" class="bne-testimonial-slider-wrapper">';
					$output .= '<div class="slides-inner">';
						$output .= '<div class="bne-testimonial-slider bne-flexslider">';
							$output .= '<ul class="slides">';
				
								// Begin Testimonial Loop!
								foreach( $testimonials as $testimonial ) {
										
									/*
									 * 	Mixed API Source Class
									 *
									 *	Because some API's require certain branding, we need
									 *	to make sure the individual testimonials within a mixed
									 *	source group inherit the appropriate source class
									*/
									if( $using_mix == true ) {
										$atts['source'] = $testimonial['source'];
									}

									// Field Data
									$atts['api'] = bne_testimonaials_api_set_fields( $testimonial, $atts['source'] );
									
									$output .= '<li id="testimonial-id-'.$atts['api']['id'].'" class="testimonial-api-'.$atts['source'].' testimonial-single" '.$schema_header_single.'>';
										$output .='<div class="flex-content">';
											$output .= bne_testimonials_get_template( 'single', $atts );
											$output .= '<div class="clear"></div>';	
										$output .= '</div>';
									$output .= '</li>';										
								
								} // END the Loop!
						
							$output .= '</ul> <!-- .slides (end) -->';
						$output .= '</div> <!-- .bne-testimonial-slider (end) -->';
					$output .= '</div> <!-- .slides-inner (end) -->';
				$output .= '</div> <!-- .bne-testimonial-slider-wrapper (end) -->';

			}


			/*
			 *	Thumbnail Slider Layout
			 *
			 *	If using the thumbs layout, output the
			 *	necessary structure.
			 *
			*/
			elseif( 'thumbs' == $atts['layout'] ) {
				
				// Assign Overrides:
				$atts['alignment'] = 'right';
				
				// Enqueue Flexslider script
				wp_enqueue_script( 'flexslider' );
				
				// Init Flexslider
				wp_add_inline_script( 'flexslider', 
					'jQuery(document).ready(function($){
						$("#bne-slider-id-'.$slider_id.' .bne-testimonial-slider").flexslider({
							animation: "'.$atts['animation'].'",
							animationSpeed: '.$atts['animation_speed'].',
							smoothHeight: '.$atts['smooth'].',
							slideshow: true,
							pauseOnHover: '.$atts['pause'].',
							controlsContainer: $("#bne-slider-id-'.$slider_id.' .thumbs-wrapper"),
							controlNav: "thumbnails",
							directionNav: false,
							slideshowSpeed: '.$atts['speed'].'
						});
					});'
				);
				
				// Slider Wrapper
				$output .= '<div id="bne-slider-id-'.$slider_id.'" class="bne-testimonial-slider-wrapper clearfix">';
					$output .= '<div class="slides-inner">';							
													
						// Control Nav (Thumbs)
						if( '1' == $atts['arrangement'] ) {
							$output .= '<div class="thumbs-wrapper thumb-'.$atts['image_style'].'"></div>';
						}

						$output .= '<div class="bne-testimonial-slider bne-flexslider">';
							$output .= '<ul class="slides">';
				
								// Begin Testimonial Loop!
								foreach( $testimonials as $testimonial ) {

									/*
									 * 	Mixed API Source Class
									 *
									 *	Because some API's require certain branding, we need
									 *	to make sure the individual testimonials within a mixed
									 *	source group inherit the appropriate source class
									*/
									if( $using_mix == true ) {
										$atts['source'] = $testimonial['source'];
									}
				
									// Field Data
									$atts['api'] = bne_testimonaials_api_set_fields( $testimonial, $atts['source'] );
										
									$thumb = $atts['api']['image'];
									// Fallback thumbnail
									if( !$thumb ) { 
										$thumb = BNE_TESTIMONIALS_URI.'/assets/images/blank-thumb2.jpg';
									}
									
									$output .= '<li id="testimonial-id-'.$atts['api']['id'].'" class="testimonial-api-'.$atts['source'].' testimonial-single" data-thumb="'.$thumb.'"'.$schema_header_single.'>';
										$output .='<div class="flex-content">';
											$output .= bne_testimonials_get_template( 'single', $atts );
											$output .= '<div class="clear"></div>';	
										$output .= '</div>';
									$output .= '</li>';										
								
								} // END the Loop!
						
							$output .= '</ul> <!-- .slides (end) -->';
						$output .= '</div> <!-- .bne-testimonial-slider (end) -->';
					
						// Control Nav (Thumbs)
						if( '2' == $atts['arrangement'] ) {
							$output .= '<div class="thumbs-wrapper thumb-'.$atts['image_style'].'"></div>';
						}

					$output .= '</div> <!-- .slides-inner (end) -->';
				$output .= '</div> <!-- .bne-testimonial-slider-wrapper (end) -->';

			}


			/*
			 *	Masonry Layout
			 *
			 *	If using the Masonry layout, output the
			 *	necessary structure.
			 *
			*/
			elseif( 'masonry' == $atts['layout'] ) {
				
				// Make sure we're not using more columns than possible
				if( $atts['columns'] > 4 ) { $atts['columns'] = 4; }
				
				// Enqueue Masonry script
				wp_enqueue_script( 'masonry' );
				
				// Init Masonry
				wp_add_inline_script( 'masonry', 
					'jQuery(document).ready(function($){
						$("#masonry-id-'.$masonry_id.'").masonry({
							itemSelector: \'.testimonial-single\',
							columnWidth: \'.testimonial-single\',
							percentPosition: true
						});
						$("#masonry-id-'.$masonry_id.'").addClass("masonry-loaded");
					});'
				);

				$output .= '<div id="masonry-id-'.$masonry_id.'" class="bne-testimonial-masonry-wrapper">';
					
					// Begin Testimonial Loop!
					foreach( $testimonials as $testimonial ) {
						
						/*
						 *	Expansion of hidden testimonials
						 *
						 *	The list layout allows hidding testimonials after X and
						 *	includes a show/hide link. These hidden testimonials triggered using
						 *	the expander links below and JS.
						 *
						 *	Once $atts['expand'] is reached based on the current count, the 
						 *	remainder receives the hidden class.
						 *
						*/
						$hidden = '';
						if( (int) $atts['expand'] ) {
							wp_enqueue_script('expander', BNE_TESTIMONIALS_URI . '/assets/js/jquery.expand.js', array( 'jquery' ), BNE_TESTIMONIALS_VERSION, true );
							if( $i > $atts['expand'] ) {
								$hidden = 'testimonial-hidden';
							}
							$i++;
						}


						/*
						 * 	Mixed API Source Class
						 *
						 *	Because some API's require certain branding, we need
						 *	to make sure the individual testimonials within a mixed
						 *	source group inherit the appropriate source class
						*/
						if( $using_mix == true ) {
							$atts['source'] = $testimonial['source'];
						}

	
						// Field Data
						$atts['api'] = bne_testimonaials_api_set_fields( $testimonial, $atts['source'] );
						
						$output .= '<div id="testimonial-id-'.$atts['api']['id'].'" class="testimonial-api-'.$atts['source'].' testimonial-single col-'.$atts['columns'].'-masonry '.$hidden.'"'.$schema_header_single.'>';
							$output .= bne_testimonials_get_template( 'single', $atts );	
							$output .= '<div class="clear"></div>';	
						$output .= '</div>';
					
					} // END the Loop!
				
				$output .= '</div>';
			
			}	



			/*
			 *	List / Default Layout
			 *
			 *	If using the list layout or no layout, output the
			 *	necessary structure.
			 *
			*/
			else {
				
				// Begin Testimonial Loop!
				foreach( $testimonials as $testimonial ) {
					
					/*
					 *	Expansion of hidden testimonials
					 *
					 *	The list layout allows hidding testimonials after X and
					 *	includes a show/hide link. These hidden testimonials triggered using
					 *	the expander links below and JS.
					 *
					 *	Once $atts['expand'] is reached based on the current count, the 
					 *	remainder receives the hidden class.
					 *
					*/
					$hidden = '';
					if( (int) $atts['expand'] ) {
						wp_enqueue_script('expander', BNE_TESTIMONIALS_URI . '/assets/js/jquery.expand.js', array( 'jquery' ), BNE_TESTIMONIALS_VERSION, true );
						if( $i > $atts['expand'] ) {
							$hidden = 'testimonial-hidden';
						}
						$i++;
					}
					
					
					/*
					 * 	Mixed API Source Class
					 *
					 *	Because some API's require certain branding, we need
					 *	to make sure the individual testimonials within a mixed
					 *	source group inherit the appropriate source class
					*/
					if( $using_mix == true ) {
						$atts['source'] = $testimonial['source'];
					}


					// Field Data
					$atts['api'] = bne_testimonaials_api_set_fields( $testimonial, $atts['source'] );
					
					$output .= '<div id="testimonial-id-'.$atts['api']['id'].'" class="testimonial-api-'.$atts['source'].' testimonial-single clearfix '.$hidden.'"'.$schema_header_single.'>';
						$output .= bne_testimonials_get_template( 'single', $atts );	
						$output .= '<div class="clear"></div>';	
					$output .= '</div>';
				

				} // END the Loop!

			}


			// Expand Triggers for Hidden Testimonials
			if( (int) $atts['expand'] ) {
				$output .= '<div class="clear"></div>';
				$output .= '<a href="#" class="testimonials-expander testimonial-hidden active active-opacity expand-more">'.$atts['expand_more'].'</a>';
				$output .= '<a href="#" class="testimonials-expander testimonial-hidden expand-less">'.$atts['expand_less'].'</a>';
			}

			/*
			 *	Devs - After Testimonial Filter
			 *
			 *	Allow devs to extend content after the testimonial.
			 *
			*/
			$output .= apply_filters( 'bne_testimonials_after', '' );
			
			
		// Close the wrapper!
		$output .= '</div><!-- .bne-testimonials-wrapper (end) -->';


	} else {
		$output = '<div class="bne-testimonial-warning none-warning">'.__('No testimonials were found.', 'bne-testimonials').'</div>';
	}


	return $output;

}
add_shortcode( 'bne_testimonials_api', 'bne_testimonials_shortcode_api' );