<?php
/*
 *	Badge Shortcode Display
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
*/


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


	

/*
 * 	Display Badge Shortcode
 *
 *	@since 		v2.4
 *	@updated	v2.9.12
 *
*/
function bne_testimonials_badge_shortcode( $atts ) {
	$atts = shortcode_atts( array(
		
		'schema'		=>	'true',					// Enable schema markup
		'schema_type'	=>	'Product',				// Schema Type	
		'schema_name'	=>	get_bloginfo( 'name' ),	// Schema Name
		
		'image'			=>	'',						// Image URL
		'image_size'	=>	'60px',					// Image Size
		'image_align'	=>	'left',					// Image Align
		
		'category'		=>	'',						// Cat slugs (separated by ",")
		'rating'		=>	'',						// Number (accepts decimal)
		'total'			=>	'',						// Number
		
		'heading'		=>	'',						// Widget heading
		'rating_color'	=>	'gold',					// Color # or name
		'rating_name'	=>	'Stars',				// Rating text
		'before_total'	=>	'- Based on',			// Text before total number
		'after_total'	=>	'User Reviews',			// Text after average number
		'link'			=>	'',						// Link
		'link_title'	=>	'User Reviews',			// Link title

		// API Arguments
		'api'			=>	'false',				// Replaces data with API data of the source
		'url'			=>	'',						// The source site URL to query from (local only)
		'source'		=>	'',						// The source type of the API (google, yelp, local)
		'cache'			=>	'true',					// Cache the results for 1 day
		'key'			=>	'',						// The Google API Key
		'id'			=>	'',						// Google PlaceID or Yelp business ID

		'branding'		=>	'local',				// Branding Style: facebook, google, yelp.
		'fancy'			=>	'true',					// Default Styled container
		'width'			=>	'400px',					// The max width of the container
		'accent'		=>	'',						// The accent color
		'class'			=>	''						// Custom classes
		
	), $atts, 'bne_testimonials_badge' );


	
	/*
	 *	BNE Testimonials Query Only
	 *	For local published BNE Testimonials. This will automatically
	 *	set the average rating and total based on the query.
	 *
	*/
	if( ( !$atts['total'] || !$atts['rating'] ) && $atts['api'] == 'false' ) {
		

		// BNE Testimonials Category Args
		$taxonomy_args = null;
		if( $atts['category'] ) {
			$taxonomy_args = array(
		        array(
		            'taxonomy' 	=> 	'bne-testimonials-taxonomy',
		            'field' 	=> 	'slug',
		            'terms' 	=> 	explode( ',', esc_html( $atts['category'] ) )
		        )
		    );
		}


		// BNE Testimonial Post Query 
		$args = array(
			'post_type'			=>	'bne_testimonials',
			'posts_per_page'	=>	'-1',
		    'meta_query' 		=> array(
		        array(
		            'key' 			=> 	'rating',
		            'value' 		=> 	'0',
		            'compare' 		=>	'>'
		        )
		    ),
			'tax_query' 		=> 	$taxonomy_args
		);
		$testimonials = get_posts( $args );


		// Set Average & Total Rating
		$calculated_rating = bne_testimonials_calculate_rating( $testimonials );
		if( !$atts['rating'] ) {
			$atts['rating'] = $calculated_rating['ratingValue'];
		}

		// Set Total
		if( !$atts['total'] ) {
			$atts['total'] = $calculated_rating['ratingCount'];
		}


	} // End local BNE Testimonials Query
	

	// Make sure $source is lowercase
	if( $atts['source'] ) {
		$atts['source'] = strtolower($atts['source']);
	} 


	/*
	 *	BNE Testimonials API
	 *	
	 *	Queries the source API's for review data
	 *
	*/
	if( 'true' == $atts['api'] ) {
		$query_args = null;
		

		// WP API v1
		if( $atts['url'] ) {
			$atts['id'] = null;
			$atts['source'] = 'local';
			$query_args = array(
				'category'	=>	esc_html( $atts['category'] ),
				'limit'		=>	-1
			);
		
		
		// Platform API's
		} elseif( !$atts['source'] || !$atts['id'] ) {
			return '<div class="bne-testimonial-warning api-warning api-'.$atts['source'].'">'.esc_html__( 'The Badge API requires both the source and ID.', 'bne-testimonials' ).'</div>';
		}
		
	
		/*
		 *	Mix API Request
		 *
		 *	Testimonial API's can now be combined into a single instance.
		 *	Each response is still cached normally via the API, but will
		 *	be merged before output.
		 *
		 *	both $atts['source'] and $atts['id'] need to be used with each
		 *	request separated by a "|" vertical bar. In addition, the order
		 *	of both must match in order.
		 *
		 *	@since 		v2.7
		 *
		*/
		$using_mix = false;
		if( ( strpos( $atts['source'], '|') !== false) || ( strpos( $atts['source'], ',') !== false ) ) {
			
			// Remove any possible white space and set new deliminator ","
			$atts['source'] = str_replace( '|', ',', $atts['source'] );
			$atts['source'] = str_replace( ' ', '', $atts['source'] );
			$atts['id'] = str_replace( '|', ',', $atts['id'] );
			$atts['id'] = str_replace( ' ', '', $atts['id'] );
			
			// Split the sources and ID using two arrays
			$mix_sources = explode(',', $atts['source'] );
			$mix_ids = explode(',', $atts['id'] );
	
			// Open collection arrays
			$mixed_rating = array();
			$mixed_total = array();
			
			// Loop through each source API
			foreach( $mix_sources as $index => $source ) {
				
				if( 'local' == $source ) {
					$atts['url'] = $mix_ids[$index];
					$query_args = array(
						'category'	=>	esc_html( $atts['category'] )
					);
				}
				
				// Request data from this source using the matched index of the ID
				$api_data = bne_testimonials_api_request( $source, null, $atts['url'], $mix_ids[$index], $atts['cache'], $query_args );
				
				// Error out if the data is not an array
				if( !is_array( $api_data ) ) {
					echo '<div class="bne-testimonial-warning api-warning api-mixed">'.esc_html( $api_data ).'</div>';
				
				// Add the new source values to their collection arrays
				} else {
					// skip this profile if rating is not defined or returns 0
					if( $api_data['rating'] && 0 != $api_data['rating'] ) {
						$mixed_rating[] = $api_data['rating'];
						$mixed_total[] = $api_data['total'];
					}
				}		
			
			} // End API Loop
				
	
			$calculated_rating = bne_testimonials_calculate_rating( array(
				'mixed_rating'	=>	$mixed_rating, 
				'mixed_total'	=>	$mixed_total
			), true );
			
			// Finalize new $api_data array
			$api_data = array(
				'name'		=>	'',
				'url'		=>	'',
				'icon'		=>	'',
				'rating'	=>	$calculated_rating['ratingValue'],
				'total'		=>	$calculated_rating['ratingCount'],	
			);
			
			// Add a styling class
			$atts['class'] .= ' testimonial-badge-api-mix';

			// Set the $using_mix flag
			$using_mix = true;

		} // END MIX API Request
		
		
		/*
		 *	Single API Request
		 *
		 *	The normal request to a single API source
		 *
		*/
		else {
			
			// Get API data
			$api_data = bne_testimonials_api_request( $atts['source'], $atts['key'], $atts['url'], $atts['id'], $atts['cache'], $query_args );
			// Error out if the $api_data is not an array
			if( !is_array($api_data) ) {
				return '<div class="bne-testimonial-warning api-warning api-source-'.$atts['source'].'">'.$api_data.'</div>';
			} 
			
			// Make sure branding matches source
			$atts['branding'] = $atts['source'];

		} // END SINGLE API Request

		
		// Set Fields
		$atts['heading'] = ( $atts['heading'] ) ?: $api_data['name'];
		$atts['rating'] = $api_data['rating'];
		$atts['total'] = ( $api_data['total'] ) ?: $atts['total'];
		$atts['link'] = ( $atts['link'] ) ?: $api_data['url'];
		$atts['image'] = ( $atts['image'] ) ?: $api_data['icon'];

		// API Classes
		$atts['class'] .= ' testimonial-badge-api';
			
	
	} // END API Setup	
	
	
	// Classes
	if( 'true' == $atts['fancy'] ) {
		$atts['class'] .= ' fancy';
		if( 'yelp' == $atts['branding'] ) {
			$atts['class'] .= ' fancy-stars';
		}
	}
	
	
	// Branding Styles
	$brand_assets = bne_testimonials_api_branding_assets( $atts['branding'] );
	if( $brand_assets ) {
		$atts['image'] = $brand_assets['badge'];
		$atts['image_size'] = $brand_assets['badge_width'];
		$atts['rating_color'] = $brand_assets['rating_color'];
		if( !$atts['heading'] ) { $atts['heading'] = ucfirst( $atts['branding'] ).' Rating'; }
	}

	
	// Custom Styles
	$styles = 'max-width:'.$atts['width'].';';
	$styles .= ( $atts['accent'] ) ? 'border-top-color:'.esc_attr( $atts['accent'] ).';' : '';

	
	// Cancel Schema if rating is 0 or undefined
	if( !$atts['rating'] || 0 == $atts['rating'] ) {
		$atts['schema'] = 'false';
		// Set rating to 0 (display only)
		$atts['rating'] = 0;
		// Set total to 0 (display only)
		if( !$atts['total'] ) { 
			$atts['total'] = 0;
		}
	}

	
	// Schema Tags
	$schema_type = $schema_name = $schema_image = $schema_aggregate = $schema_ratingValue = $schema_reviewCount = '';
	if( 'true' == $atts['schema'] ) {
		$schema_type = ' itemscope itemtype="http://schema.org/'.esc_html( $atts['schema_type'] ).'"';
		$schema_name = '<meta itemprop="name" content="'.esc_attr( $atts['schema_name'] ).'" />';
		$schema_image = ' itemprop="image"';
		$schema_aggregate = ' itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating"';
		$schema_ratingValue = ' itemprop="ratingValue"';
		$schema_reviewCount = ' itemprop="reviewCount"';
	}
	
	
	
	// Begin Output
	$output = '<div class="bne-testimonial-wrapper testimonial-badge '.$atts['branding'].'-badge '.$atts['class'].' clearfix" style="'.$styles.'">';
	
		// Schema Type
		$output .= '<div'.$schema_type.'>';

			// Schema Name
			$output .= $schema_name;
			
			// Allow Devs to add additional schema tags for their particular type (pricerange, telephone, address, etc)
			if( 'true' == $atts['schema'] ) {
				$output .= apply_filters( 'bne_testimonials_schema_additional_tags', '' );
			}
			
			// Image
			if( $atts['image'] ) {
				$output .= '<img'.$schema_image.' src="'.esc_url( $atts['image'] ).'" class="badge-image align'.$atts['image_align'].'" alt="'.esc_attr( $atts['schema_name'] ).'" width="'.$atts['image_size'].'"/>';
			}

			
			// Heading
			if( $atts['heading'] ) {
				$output .= '<span class="badge-title">'.esc_html( $atts['heading'] ).'</span>';
			}
			

			// AggregateRating
			$output .= '<div'.$schema_aggregate.'>';
				
				// Stars
				$output .= '<div class="testimonial-rating badge-rating rating-'.str_replace('.', '-', $atts['rating']).'">';
														
					// Star Defaults (adding "+0" removes the ".0")
					$full = ( $atts['rating'] > 5 ) ? 5 : $atts['rating'] + 0;
					$half = 0;
					$empty = 0;
					$max = 5;
											
					// Adjust full if rating is a decimal
					if( strpos( $full, "." ) !== false ) {
						$full = floor( $atts['rating'] );
						$half = 1;
					}
					
					// Full Stars
					for( $i = 1; $i <= $full; $i++ ) {
						$output .= '<span class="bne-icon-star-filled bne-stars" style="color:'.esc_html( $atts['rating_color'] ).';"></span>';;
					}
					
					// Half Star
					if( $half == 1 ) {
						$output .= '<span class="bne-icon-star-half-outline bne-stars" style="color:'.esc_html( $atts['rating_color'] ).';"></span>';
					}
				
					// Empty Stars
					for( $i = 1; $i <= ( $max - $full - $half ); $i++ ) {
						$output .= '<span class="bne-icon-star-empty bne-stars" style="color:'.esc_html( $atts['rating_color'] ).';"></span>';
					}
				
				$output .= '</div><!-- .testimonial-rating (end) -->';
				
				// Average Rating
				$output .= '<div class="badge-text">';
					$output .= '<span'.$schema_ratingValue.' class="badge-average">'.$atts['rating'].'</span> ';
					
					// Based on...
					if( $atts['rating'] == 1 ) {  
						$atts['rating_name'] = preg_replace("/s\b/", "",  $atts['rating_name'] );
					}
					$output .= esc_html( $atts['rating_name'] ).' '.esc_html( $atts['before_total'] ). ' ';
					
					// Link (open)
					if( $atts['link'] ) {
						$output .= '<a href="'.esc_url( $atts['link'] ).'" class="badge-link" title="'.esc_attr( $atts['link_title'] ).'">';
					}
					
					// Total
					$output .= '<span'.$schema_reviewCount.' class="badge-total">'.$atts['total'].'</span> '.esc_html( $atts['after_total'] );
					
					// Link (close)
					if( $atts['link'] ) {
						$output .= '</a>';
					}
				
				$output .= '</div><!-- .badge-text (end) -->';
			
			$output .= '</div><!-- .aggregateRating (end) -->';
		$output .= '</div><!-- .rating-schema (end) -->';
	$output .= '</div><!-- .testimonial-badge (end) -->';
	
	return $output;

}
add_shortcode( 'bne_testimonials_badge', 'bne_testimonials_badge_shortcode' );