<?php
/*
 *	Help Admin Page - Shortcode v1.x Docs
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *	@updated	v2.0
 *
*/

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;



?>

<div class="widget" style="margin-top: 15px;">
	<h3 class="widget-title">Display Testimonials as a List (v1.x shortcode)</h3>

	<div class="alert alert-warning">
		<p><span class="dashicons dashicons-warning"></span> These instructions are only for the <strong>v1.x</strong> List shortcode. Use these shortcode options if you are relying on the previous 1.x version of Testimonials PRO only. If you are new to this plugin or plan on updating your existing shortcodes, use v2 instead as it includes newer features.</p>
	</div>

	<p><strong>Shortcode:</strong> [bne_testimonials_list]</p>
	<p>To change the default behavior of this shortcode, include any of the available arguments below. You only need to include them if changing the default behavior.</p>

	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>post</td>
				<td>-1</td>
				<td>Any numerical value</td>
				<td>Number determines amount of testimonials to display.</td>
			</tr>
			<tr>
				<td>id</td>
				<td></td>
				<td>Any numerical value</td>
				<td>Display a single testimonial anywhere using the post ID number of the testimonial.</td>
			</tr>
			<tr>
				<td>order</td>
				<td>date</td>
				<td>date, rand, or title</td>
				<td>Displays the order of the testimonials based on publish date, random order or alphabetically by title.</td>
			</tr>
			<tr>
				<td>order_direction</td>
				<td>DESC</td>
				<td>DESC or ASC</td>
				<td>Displays the testimonials based on the order parameter in either ascending or descending direction.</td>
			</tr>
			<tr>
				<td>name</td>
				<td>true</td>
				<td>true or false</td>
				<td>Display the testimonial name/title.</td>
			</tr>
			<tr>
				<td>image</td>
				<td>true</td>
				<td>true or false</td>
				<td>Display the testimonial featured image or not.</td>
			</tr>
			<tr>
				<td>image_style</td>
				<td>square</td>
				<td>square, circle, flat-square, flat-circle</td>
				<td>Styles the featured image using one of the four built in styles. Square and Circle will give the image a border, frame and shadow. flat-square and flat-circle will show no border, no frame, and no shadow.</td>
			</tr>
			<tr>
				<td>category</td>
				<td></td>
				<td></td>
				<td>If you created categories, add the slug you wish to only display. Ex: If the category is "San Diego", the slug will be "san-diego".</td>
			</tr>
			<tr>
				<td>class</td>
				<td></td>
				<td></td>
				<td>Allows you to add a custom class name to the main shortcode div. This way you can easily style each list/slider testimonial individually based on the class used.</td>
			</tr>
			<tr>
				<td>pagination</td>
				<td>false</td>
				<td>true or false</td>
				<td>If set to true, a row of numbered buttons will show on the bottom allowing pagination. In addition, pagination will only display if limiting the number of testimonials shown per page, example: post="6"</td>
			</tr>
		</tbody>
	</table>
	<p><strong>Example Use:</strong> [bne_testimonials_list post="3" image_style="circle"]</p>
	<p>The above will display only 3 testimonials using the circle featured image style.</p>
</div><!-- .widget (end) -->


<!-- Slider Shortcode -->
<div class="widget" id="slider_shortcode">
	<h3 class="widget-title">Display Testimonials as a Slider (v1.x shortcode)</h3>

	<div class="alert alert-warning">
		<p><span class="dashicons dashicons-warning"></span> These instructions are only for the <strong>v1.x</strong> Slider shortcode. Use these shortcode options if you are relying on the previous 1.x version of Testimonials PRO only. If you are new to this plugin or plan on updating your existing shortcodes, use v2 instead as it includes newer features.</p>
	</div>

	<p><strong>Shortcode:</strong> [bne_testimonials_slider]</p>
	<p>To change the default behavior of this shortcode, include any of the available arguments below. You only need to include them if changing the default behavior.</p>

	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>post</td>
				<td>-1</td>
				<td>Any numerical value</td>
				<td>Number determines amount of testimonials to display.</td>
			</tr>
			<tr>
				<td>order</td>
				<td>date</td>
				<td>date, rand, or title</td>
				<td>Displays the order of the testimonials based on publish date, random order or alphabetically by title.</td>
			</tr>
			<tr>
				<td>order_direction</td>
				<td>DESC</td>
				<td>DESC or ASC</td>
				<td>Displays the testimonials based on the order parameter in either ascending or descending direction.</td>
			</tr>
			<tr>
				<td>name</td>
				<td>true</td>
				<td>true or false</td>
				<td>Display the testimonial name/title.</td>
			</tr>
			<tr>
				<td>image</td>
				<td>true</td>
				<td>true or false</td>
				<td>Display the testimonial featured image or not.</td>
			</tr>
			<tr>
				<td>image_style</td>
				<td>square</td>
				<td>square, circle, flat-square, flat-circle</td>
				<td>Styles the featured image using one of the four built in styles. Square and Circle will give the image a border, frame and shadow. flat-square and flat-circle will show no border, no frame, and no shadow.</td>
			</tr>
			<tr>
				<td>category</td>
				<td></td>
				<td></td>
				<td>If you created categories, add the slug you wish to only display. Ex: If the category is "San Diego", the slug will be "san-diego".</td>
			</tr>
			<tr>
				<td>class</td>
				<td></td>
				<td></td>
				<td>Allows you to add a custom class name to the main shortcode div. This way you can easily style each list/slider testimonial individually based on the class used.</td>
			</tr>
			<tr>
				<td>animation</td>
				<td>slide</td>
				<td>slide or fade</td>
				<td>The transition of each testimonial.</td>
			</tr>
			<tr>
				<td>animation_speed</td>
				<td>700</td>
				<td>Any numerical value</td>
				<td>This determines the speed of the transition, in milliseconds. "1000" would equal to 1 seconds.</td>
			</tr>
			<tr>
				<td>nav</td>
				<td>true</td>
				<td>true or false</td>
				<td>Display the pagination buttons.</td>
			</tr>
			<tr>
				<td>arrows</td>
				<td>true</td>
				<td>true or false</td>
				<td>Display the directional arrows.</td>
			</tr>
			<tr>
				<td>smooth</td>
				<td>true</td>
				<td>true or false</td>
				<td>Height will adjust with a smooth animation based on the amount of content.</td>
			</tr>
			<tr>
				<td>pause</td>
				<td>true</td>
				<td>true or false</td>
				<td>If mouse cursor hovers over slider, slideshow will pause.</td>
			</tr>
			<tr>
				<td>speed</td>
				<td>7000</td>
				<td>Any numerical value</td>
				<td>This determines the speed of the slideshow cycling, in milliseconds. "7000" would equal to 7 seconds.</td>
			</tr>
		</tbody>
	</table>
	<p><strong>Example Use:</strong> [bne_testimonials_slider animation="fade" arrows="false" image_style="flat-circle"]</p>
	<p>The above will transition each testimonial using Fade, not show navigation arrows, and use the flat circle featured image style.</p>
</div><!-- .widget (end) -->

<!-- Masonry Shortcode -->
<div class="widget" id="masonry_shortcode">
	<h3 class="widget-title">Display Testimonials as a Masonry Grid (v1.x shortcode)</h3>

	<div class="alert alert-warning">
		<p><span class="dashicons dashicons-warning"></span> These instructions are only for the <strong>v1.x</strong> Masonry shortcode. Use these shortcode options if you are relying on the previous 1.x version of Testimonials PRO only. If you are new to this plugin or plan on updating your existing shortcodes, use v2 instead as it includes newer features.</p>
	</div>

	<p><strong>Shortcode:</strong> [bne_testimonials_masonry]</p>
	<p>To change the default behavior of this shortcode, include any of the available arguments below. You only need to include them if changing the default behavior.</p>

	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>post</td>
				<td>-1</td>
				<td>Any numerical value</td>
				<td>Number determines amount of testimonials to display.</td>
			</tr>
			<tr>
				<td>order</td>
				<td>date</td>
				<td>date, rand, or title</td>
				<td>Displays the order of the testimonials based on publish date, random order or alphabetically by title.</td>
			</tr>
			<tr>
				<td>order_direction</td>
				<td>DESC</td>
				<td>DESC or ASC</td>
				<td>Displays the testimonials based on the order parameter in either ascending or descending direction.</td>
			</tr>
			<tr>
				<td>name</td>
				<td>true</td>
				<td>true or false</td>
				<td>Display the testimonial name/title.</td>
			</tr>
			<tr>
				<td>image</td>
				<td>true</td>
				<td>true or false</td>
				<td>Display the testimonial featured image or not.</td>
			</tr>
			<tr>
				<td>image_style</td>
				<td>square</td>
				<td>square, circle, flat-square, flat-circle</td>
				<td>Styles the featured image using one of the four built in styles. Square and Circle will give the image a border, frame and shadow. flat-square and flat-circle will show no border, no frame, and no shadow.</td>
			</tr>
			<tr>
				<td>category</td>
				<td></td>
				<td></td>
				<td>If you created categories, add the slug you wish to only display. Ex: If the category is "San Diego", the slug will be "san-diego".</td>
			</tr>
			<tr>
				<td>class</td>
				<td></td>
				<td></td>
				<td>Allows you to add a custom class name to the main shortcode div. This way you can easily style each list/slider testimonial individually based on the class used.</td>
			</tr>
			<tr>
				<td>columns</td>
				<td>3</td>
				<td>2, 3, or 4</td>
				<td>Displays the testimonials in either 2, 3 or 4 columns using a masonry style. NOTE: Columns are also responsive and will reduce in number as the window gets smaller to prevent the content "squeezing." For example, 4 columns will become 3, then 2, then 1.</td>
			</tr>
			<tr>
				<td>pagination</td>
				<td>false</td>
				<td>true or false</td>
				<td>If set to true, a row of numbered buttons will show on the bottom allowing pagination. In addition, pagination will only display if limiting the number of testimonials shown per page, example: post="6"</td>
			</tr>
		</tbody>
	</table>
	<p><strong>Example Use:</strong> [bne_testimonials_masonry image_style="circle" columns="4"]</p>
	<p>The above will display your testimonials using the circle featured image style in 4 columns.</p>
</div><!-- .widget (end) -->