<?php
/*
 *	Help Admin Page
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
*/

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;



/*
 *	Register admin page and location
 *
 *	@since v1.0
 *
*/
function bne_testimonials_help_menu_link() {
    add_submenu_page(
    	'edit.php?post_type=bne_testimonials',
    	esc_html__( 'BNE Testimonials Pro', 'bne-testimonials' ),
    	esc_html__( 'Help', 'bne-testimonials' ),
    	'edit_posts',
    	'bne-testimonial-help',
    	'bne_testimonials_admin_help_page'
    );
}
add_action( 'admin_menu' , 'bne_testimonials_help_menu_link');



/*
 *	Output the Admin Page
 *
 *	@since 		v1.0
 *	@updated 	v2.6
 *
*/
function bne_testimonials_admin_help_page() {

	// Load BNE Admin CSS
	wp_enqueue_style( 'bne-admin-styles', BNE_TESTIMONIALS_URI . '/assets/css/bne-admin.css' );
	
	?>

	<div id="bne-admin-wrapper" class="wrap">
		<div class="bne-inner" style="padding:0;">

			<script type="text/javascript">
				jQuery(document).ready(function($) {
					$('a.scroll').on('click', function() {
						$('html, body').animate({
							scrollTop: $(this.hash).offset().top - 50
						}, 1000);
						return false;
					});
				});
			</script>
			<style type="text/css">
				.label.new {
					background: #0099ff;
					color: white;
					font-weight: bold;
					padding: 2px 5px;
					border-radius: 5px;
					font-size: 12px;
					margin-right: 5px;
				}
				.info-box {
				}
				.info-box p { margin-top: 0; margin-bottom:5px; }
			</style>

			<h2><?php echo __('BNE Testimonials Pro Documentation', 'bne-testimonials' ); ?></h2>
			
			<div class="info-box">
				<p><strong>Current Version:</strong> <?php echo BNE_TESTIMONIALS_VERSION; ?> (<a href="http://updates.bnecreative.com/changelogs/?product=testimonials-pro" target="_blank">View changelog</a>)</p>
				<p><strong>Developer Resources:</strong> Extend how testimonials are displayed using the available hooks and filters within the plugin, including with being able to extend to other API platforms. <a href="http://docs.bnecreative.com/articles/plugins/testimonials-pro/" target="_blank">Learn More</a>.</p>
			</div>
			<hr>

			<div class="clear"></div>
			
			<div class="canvas">
				
				<?php

					// Adjust Query from Tab choice
					$active_tab = 'display-shortcode';
					if( isset( $_GET[ 'tab' ] ) ) {
						$active_tab = $_GET['tab'];
					}


					$tabs = apply_filters( 'bne_testimonials_help_addon', array(
						array(
							'title'		=>	esc_html__( 'Display Shortcode', 'bne-testimonials' ),
							'content'	=>	'',
							'include'	=>	BNE_TESTIMONIALS_DIR . '/includes/help/shortcode-2x.php'
						),
						/*
						array(
							'title'		=>	'v1.x Shortcodes',
							'content'	=>	'',
							'include'	=>	BNE_TESTIMONIALS_DIR . '/includes/help/shortcode-1x.php'
						),
						*/
						array(
							'title'		=>	esc_html__( 'Badge', 'bne-testimonials' ),
							'content'	=>	'',
							'include'	=>	BNE_TESTIMONIALS_DIR . '/includes/help/badges.php'
						),
						array(
							'title'		=>	esc_html__( 'Stats', 'bne-testimonials' ),
							'content'	=>	'',
							'include'	=>	BNE_TESTIMONIALS_DIR . '/includes/help/stats.php'
						),
						array(
							'title'		=>	esc_html__( 'API Platforms', 'bne-testimonials' ),
							'content'	=>	'',
							'include'	=>	BNE_TESTIMONIALS_DIR . '/includes/help/api.php'
						),
						array(
							'title'		=>	esc_html__( 'Submit Form', 'bne-testimonials' ),
							'content'	=>	'',
							'include'	=>	BNE_TESTIMONIALS_DIR . '/includes/help/form.php'
						),
					) );
				?>
	
				<!-- Tab Navigation -->
				<h2 class="nav-tab-wrapper">
					<?php foreach( $tabs as $tab ) {
						$tab_id = sanitize_title( $tab['title'] );
						$tab_arg = add_query_arg('tab', $tab_id );
						echo '<a href="'.$tab_arg.'" id="'.$tab_id.'" class="nav-tab '.( $active_tab == $tab_id ? 'nav-tab-active' : '' ).'">'.$tab['title'].'</a>';
					} ?>
				</h2>
				
				<!-- Tab content -->
				<?php 
					foreach( $tabs as $tab ) {
						$tab_id = sanitize_title( $tab['title'] );
						if( $active_tab == $tab_id ) {
							echo '<div class="tab-content" id="'.sanitize_title( $tab['title'] ).'">';
								if( file_exists( $tab['include'] ) ) {
									include( $tab['include'] );
								} else {
									echo '<div style="margin-top: 15px;">'.$tab['content'].'</div>';
								}
							echo '</div>';
						}
					} 
				?>
				

			</div><!-- .canvas (end) -->
		</div><!-- .bne-inner (end) -->
	</div><!-- .bne-admin-wrapper.wrap (end) -->

	<?php
} // END Admin Help Page