<?php
/*
 *	Help Admin Page - Shortcode Badges Tab
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *	@since		v2.4
 *	@updated	v2.4.2
 *
*/

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;



?>
<div class="widget" style="margin-top: 15px;">
	<h3 class="widget-title">Testimonial Badge Shortcode</h3>
	<img src="<?php echo BNE_TESTIMONIALS_URI;?>/assets/images/admin/help-badge.png" width="250px" class="alignright pretty" />
	<p><strong>Shortcode:</strong> [bne_testimonials_badge]</p>
	<p>The Badge shortcode is a simple display with schema markup showing the aggregated rating of all testimonials published on this site with a rating.</p>
	<p>The average rating and total will automatically calculate for you based on the published testimonials on this website that have ratings. If you would like to manually set your rating and total amounts, include the <code>rating</code> and <code>total</code> shortcode arguments.</p>
	
	<hr>
	
	<p>To change the default behavior of this shortcode, include any of the available arguments below. You only need to include them if changing the default behavior.</p>
	
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>branding</td>
				<td>local</td>
				<td>local, Yelp, Google, or Facebook</td>
				<td>The branding argument styles the badge to use the review provider's logo, color scheme and a styled frame.<br><br><strong>Note:</strong> By using branding, the following shortcode arguments <strong>will not apply</strong> <code>image</code>, <code>image_size</code>, <code>category</code>, <code>rating_color</code>, and <code>rating_name</code>.</td>
			</tr>
			<tr>
				<td>schema</td>
				<td>true</td>
				<td>true or false</td>
				<td>Allows completely turning off the schema markup if not needed or is displayed elsewhere on the page.</td>
			</tr>
			<tr>
				<td>schema_type</td>
				<td>Product</td>
				<td></td>
				<td>(string) This is the "itemReviewed" property in schema. If the reviews are about a business, this should be set to "LocalBusiness" or a more closely related term such as "Restaurant", "Book", "Product", etc.</td>
			</tr>
			<tr>
				<td>schema_name</td>
				<td>The site name</td>
				<td>(string)</td>
				<td>This should be the name of the item being reviewed such as the business or product name.</td>
			</tr>
			<tr>
				<td>image</td>
				<td></td>
				<td>(url)</td>
				<td>Depending on the the schema type, you may need to include an image. This could be to a logo or product image.</td>
			</tr>
			<tr>
				<td>image_size</td>
				<td>50px</td>
				<td>(string)</td>
				<td>The width size of the image using pixels.</td>
			</tr>
			<tr>
				<td>image_align</td>
				<td>left</td>
				<td>left, right, or center</td>
				<td>Align the image around the review content.</td>
			</tr>
			<tr>
				<td>category</td>
				<td></td>
				<td>(category slug)</td>
				<td>Will display testimonials from this category only. You can display multiple categories by separating each category slug with a comma (,). Example: <code>category="marketing, management, support-team"</code></td>
			</tr>
			<tr>
				<td>rating</td>
				<td></td>
				<td>(number)</td>
				<td> When not defined, this will be the sum average of all published testimonial ratings. Only testimonials that have a rating will be included.</td>
			</tr>
			<tr>
				<td>total</td>
				<td></td>
				<td>(number)</td>
				<td>When not defined, this will be the total of all published testimonials that have a rating. Only testimonials that have a rating will be included.</td>
			</tr>
			<tr>
				<td>rating_color</td>
				<td>gold</td>
				<td>color name or #hex</td>
				<td>The style color for the star icons.</td>
			</tr>
			<tr>
				<td>heading</td>
				<td></td>
				<td>(string)</td>
				<td>Text displayed as a heading.</td>
			</tr>
			<tr>
				<td>rating_name</td>
				<td>Stars</td>
				<td>(string)</td>
				<td>The label used to describe the rating type. <br>Example: 4.5 <code>Stars</code>- Based on 305 User Reviews.</td>
			</tr>
			<tr>
				<td>before_total</td>
				<td>- Based on</td>
				<td>(string)</td>
				<td>Text displayed between the average rating and total numbers. <br>Example: 4.5 Stars <code>- Based on</code> 305 User Reviews</td>
			</tr>
			<tr>
				<td>after_total</td>
				<td>User Reviews</td>
				<td>(string)</td>
				<td>Text displayed after the total number. <br>Example: 4.5 Stars - Based on 305 <code>User Reviews</code></td>
			</tr>
			<tr>
				<td>link</td>
				<td></td>
				<td>(url)</td>
				<td>The link where the review total is linked to - typically a review page of all published reviews on your site.</td>
			</tr>
			<tr>
				<td>link_title</td>
				<td>User Reviews</td>
				<td>(string)</td>
				<td>The alt label used for the above link.</td>
			</tr>
			<tr>
				<td>width</td>
				<td>400px</td>
				<td>(number with px)</td>
				<td>The max width of the badge.</td>
			</tr>
			<tr>
				<td>accent</td>
				<td></td>
				<td>(hex or color name)</td>
				<td>The accent color used on the top border</td>
			</tr>
			<tr>
				<td>class</td>
				<td></td>
				<td>(string)</td>
				<td>Allows you to include a custom class for this widget.</td>
			</tr>
		</tbody>
	</table>

	<div style="height: 35px;"></div>
	<hr>
	<h3>Display a Badge using the API from Facebook, Google, Yelp, or Yellow Pages</h3>
	<p><strong>Shortcode:</strong> [bne_testimonials_badge api="true" source="" id=""]</p>
	<p>You can display the Facebook, Google, Yelp, or Yellow Pages review stats by including an API call in the badge shortcode. Google, Facebook, and Yellow Pages requires an active API key. Note that total and rating arguments above will not apply as these are pulled from the API directly.</p>
	

	<hr>

	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>api</td>
				<td>false</td>
				<td>true or false</td>
				<td>(required) This tells the badge shortcode to access the API functions instead.</td>
			</tr>
			<tr>
				<td>source</td>
				<td></td>
				<td>facebook, google, yelp, or yp</td>
				<td>(required) The source argument tells the API shortcode to query the correct API resource. When using source, <code>branding</code>will be set to the source type automatically.</td>
			</tr>
			<tr>
				<td>id</td>
				<td></td>
				<td></td>
				<td>(required) The Business or page ID from the source.</td>
			</tr>
			<tr>
				<td>cache</td>
				<td>true</td>
				<td>true or false</td>
				<td>The initial response will be cached for 1 week (7 days) and future calls will use the cache stored locally until reset after expiration. APIs are limited to number of request from their providers. For a faster website and API response, make sure to set this to true after you are finished testing.</td>
			</tr>
		</tbody>
	</table>
	
	<hr>
	<h4>Notes:</h4>
	<ul>
		<li>The <code>heading</code> argument can be used to adjust business name text provided from the provider.</li>
	</ul>

	<hr>
	<h3>Mixed Source Eligible</h3>
	
	<p>This API can be used in a mixed source setup by including a <code>,</code> (comma) for each <code>source</code> and <code>id</code> option. Make sure the order you use for source matches the order used for their id. You will need to manually set the <code>heading</code>, <code>image</code>, and <code>link</code> options.</p>
	<p><strong>Shortcode Example:</strong> [bne_testimonials_badge api="true" source="facebook,local" id="facebook_page_id,http://yourwebsite.com" heading="Your Business Name"]</p>
	
</div><!-- .widget (end) -->