/*!
 * Copyright (c) 2017 Kerry Kline
 *
 * jQuery Expander used with BNE Testimonials Pro
 * Version 1.0 (November 2017)
 *
*/
jQuery(document).ready(function($){
	$('.bne-testimonial-wrapper .testimonials-expander').each(function() {
		$(this).on('click', function(e) {
			
			// Get all hidden testimonials
			var elm = $(this).parent().find('.testimonial-hidden');
			
			// Set all to active
			elm.toggleClass('active');

			// Check if there is masonry grid on the page and reload it
			if( $(".bne-testimonial-masonry-wrapper").length ) {
				$(".bne-testimonial-masonry-wrapper").masonry();
			}
			
			// Delay opacity
			if( elm.hasClass('active') ) {
				setTimeout(function(){
					elm.toggleClass('active-opacity');
				}, 500 );
			// Remove all
			} else {
				elm.removeClass('active-opacity');
			}
			
			e.preventDefault();
		});
	});
});