<?php
/*
 * Plugin Name: BNE Slider
 * Version: 2.1.6
 * Description: A basic slider built using flexslider for BNE themes.
 * Author: Kerry Kline
 * Author URI: http://www.bnecreative.com
 * Requires at least: 5.0
 * Text Domain: bne-slider
 * Domain Path: languages
 * License: GPL2

    Copyright 2020 BNE Creative

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2,
    as published by the Free Software Foundation.

    You may NOT assume that you can use any other version of the GPL.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    The license for this software can likely be found here:
    http://www.gnu.org/licenses/gpl-2.0.html

*/



// Exit if accessed directly
if ( !defined('ABSPATH')) exit;

// Set Constants
define( 'BNE_SLIDER_VERSION', '2.1.6' );
define( 'BNE_SLIDER_BASENAME', plugin_basename( __FILE__ ) );
define( 'BNE_SLIDER_DIR', dirname( __FILE__ ) );
define( 'BNE_SLIDER_URI', plugins_url( '', __FILE__ ) );

// Plugin Init Class
include_once( BNE_SLIDER_DIR .'/class-bne-slider.php' );
$BNE_Slider = new BNE_Slider();



/*
 * 	Slider Page Option
 *	Adds a slider meta field to the theme's page metabox
 *
 *	@since v2.1
*/
function bne_slider_add_page_option() {
	$metabox = cmb2_get_metabox( 'bne_theme_meta_box_page' );
	if( $metabox ) {
		$sliders_object = get_posts( array( 'post_type' => 'bne_slider' ) );
		$sliders = array(
			'hide'	=>	'Disabled',
		);
		foreach( $sliders_object as $slider ) {
			$sliders[$slider->post_name] = $slider->post_title;
		}
		if( !empty($sliders) ) {
	        $metabox->add_field( array(
	            'id'      	=>	'bne_page_featured_slider',
	            'name'    	=>	__( 'Featured Slider', 'bne' ),
	            'desc'		=>	__( 'Select a Theme Slider to display before the page content.', 'bne' ),
	            'type'    	=>	'select',
	            'options'	=>	$sliders
	        ) );	
		}
	}	
}
add_action( 'cmb2_init_before_hookup', 'bne_slider_add_page_option' );
					


/*
 * 	Featured Slider Display
 *	Includes the slider output within the theme's featured area.
 *
 *	@since 		v2.1
 *	@updated 	v2.1.6
*/
function bne_slider_main_before_display() {
	
	if( is_singular() ) { 
		$slider = get_post_meta( get_the_id(), 'bne_page_featured_slider', true );
		if( $slider && $slider != 'hide' ) {
			
			// Set default shortcode arguments
			$args = apply_filters( 'bne_slider_featured_display_args', array(
				'crop' 				=> 	'full',
				'smooth_height'		=> 	'true',
				'play_pause'		=> 	'false',
				'animation_speed'	=> 	'700',
				'image_loading'		=>	'eager',
				'class'				=>	''
			) );
			
			// format the arguments for the shortcode
			$args = str_replace( "&", "\" ", str_replace( "=", "=\"", http_build_query( $args ) ) ) . "\"";
			
			// output the display
			echo '<div id="featured-page-slider" class="alignfull">';
				echo do_shortcode('[slider id="'.$slider.'" '.$args.']');
			echo '</div>';
		}
	}
	
}
add_action( 'bne_main_before', 'bne_slider_main_before_display' );