<?php
/*
 *	Admin Plugin Settings
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) 2017, Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Navbar
 *	@package	CMB2
 *
*/

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;



class bne_navbar_register_options {
	

	/*
 	 * 	Option key used in the Database
 	 *	 
 	 * 	@var string
 	*/
	private $options_key = 'bne_navbar_options';
	
	
	/*
 	 * 	Metabox ID assigned using CMB2
 	 *	 
 	 * 	@var string
 	*/
	private $metabox_id = 'bne_navbar_option_metabox';


	/*
	 * 	Constructor
 	 *
	 * 	@since 		v1.0
	 * 	@updated 	v1.2
	 *
	*/
	function __construct() {
		
		// Plugin action Links
		add_filter( 'plugin_action_links_' . BNE_NAVBAR_BASENAME, array( $this, 'add_plugin_action_links' ) );
		
		// Register the Metabox
		add_action( 'cmb2_admin_init', array( $this, 'register_settings' ) );
		
		// Hook before Metabox
		add_action( "cmb2_before_options-page_form_{$this->metabox_id}", array( $this, 'before_metabox' ), 10, 2 );
		
		// Hook After Metabox
		add_action( "cmb2_after_options-page_form_{$this->metabox_id}", array( $this, 'after_metabox' ), 10, 2 );
		
	}


	/*
	 * 	Register our admin page links
 	 *
	 * 	@since 		v1.0
	 * 	@updated 	v1.2
	 *
	*/
	function add_plugin_action_links( $links ) {
		$links[] = '<a href="'. esc_url( get_admin_url( null, 'options-general.php?page='.$this->options_key) ) .'">'.esc_html__( 'Settings', 'bne-navbar' ).'</a>';
		$links[] = '<a href="http://docs.bnecreative.com/articles/plugins/navbar/" target="_blank">'.esc_html__( 'Documentation', 'bne-navbar' ).'</a>';
		return $links;
	}


	/*
	 * 	Register the Settings Metabox and Settings Page
	 *	Hooks into CMB2 to automatically register the page and options metabox
	 *
	 * 	@since 		v1.2
	 *	@updated	v1.3.2
	 *
	*/
	function register_settings() {

		/**
		 * Registers options page menu item and form.
		 */
		$cmb_options = new_cmb2_box( array(
			'id'			=> 	$this->metabox_id,
			'title'			=> 	esc_html__( 'BNE Navbar', 'bne-navbar' ),
			'object_types'	=> 	array( 'options-page' ),
			'option_key'	=> 	$this->options_key,
			'parent_slug'	=> 'options-general.php',
			'capability'	=> 'manage_options',
		) );
		
		
		// == SECTION: General Settings/Styles == /
		$cmb_options->add_field( array(
			'name' 		=> 	esc_html__( 'General Settings and Styles', 'bne-navbar' ),
			'desc' 		=> 	esc_html__( 'Define the general options and styles for the navbar.', 'bne-navbar' ),
			'id'   		=> 	'section_styles',
			'type' 		=> 	'title',
		) );


		// Visiblity
		$cmb_options->add_field( array(
			'name' 		=> 	esc_html__( 'Visibility', 'bne-navbar' ),
			'desc' 		=> 	esc_html__( 'Check any of the above responsive screen sizes or page positions to hide the navbar.', 'bne-navbar' ),
			'id'   		=> 	'nav_visibility',
			'type'				=> 	'multicheck',
			'select_all_button' => 	false,
			'options'			=> 	array(
				'hide_on_standard' 	=>	esc_html__( 'Hide on Desktop ( > 1024px)', 'bne-navbar' ),
				'hide_on_tablet' 	=>	esc_html__( 'Hide on Tablets ( 768px to 1024px )', 'bne-navbar' ),
				'hide_on_mobile' 	=>	esc_html__( 'Hide on Mobile ( 0 < 768px )', 'bne-navbar' ),
				'hide_on_footer' 	=>	esc_html__( 'Hide when scrolled to the bottom (footer)', 'bne-navbar' ),
			),
		) );


		// Icon Font
		$cmb_options->add_field( array(
		    'name'             	=>	esc_html__( 'Icon Set', 'bne-navbar' ),
		    'desc'             	=>	esc_html__( 'Include the built in FontAwesome (v4) icon assets (css).', 'bne-navbar' ),
			'id'      			=>	'include_fa',
		    'type'             	=> 	'checkbox',
		    'default'			=>	!get_option('bne_navbar_options') ? 'on' : '',
		    'after_field'		=>	'<p class="cmb2-metabox-description">'.esc_html__( 'Uncheck this if you already have FontAwesome available from your theme or another plugin to prevent it from loading twice.', 'bne-navbar' ).'</p>',
		) );


		// Nav Background
		$cmb_options->add_field( array(
			'name'    	=> 	esc_html__( 'Nav Bar Background', 'bne-navbar' ),
			'desc'    	=> 	esc_html__( 'Sets the background color of the navbar.', 'bne-navbar' ),
			'id'      	=> 	'nav_bg_color',
			'type'    	=> 	'colorpicker',
			'default' 	=> 	'#ffffff',
			'options' 			=> 	array(
				'alpha' 			=> 	true, 
			)
		) );


		// Icon Color
		$cmb_options->add_field( array(
			'name'    	=> 	esc_html__( 'Icon Color', 'bne-navbar' ),
			'desc'    	=> 	esc_html__( 'Sets the icon color within the navbar.', 'bne-navbar' ),
			'id'      	=> 	'nav_icon_color',
			'type'    	=> 	'colorpicker',
			'default' 	=> 	'#777777',
		) );


		// Title Color
		$cmb_options->add_field( array(
			'name'    	=> 	esc_html__( 'Title Color', 'bne-navbar' ),
			'desc'    	=> 	esc_html__( 'Sets the title color within the navbar.', 'bne-navbar' ),
			'id'      	=> 	'nav_title_color',
			'type'    	=> 	'colorpicker',
			'default' 	=> 	'#777777',
		) );


		// Overlay
		$cmb_options->add_field( array(
		    'name'             	=>	esc_html__( 'Overlay', 'bne-navbar' ),
		    'desc'             	=>	esc_html__( 'Show shaded overlay', 'bne-navbar' ),
			'id'      			=>	'nav_overlay',
		    'type'             	=> 	'checkbox',
		    'after_field'		=>	'<p class="cmb2-metabox-description">'.__('When a custom menu panel is open, should the page content area be shaded?', 'bne-navbar' ).'</p>',
		) );


		// == SECTION: Nav Buttons == /
		$cmb_options->add_field( array(
			'name' 		=> 	esc_html__( 'Nav Buttons', 'bne-navbar' ),
			'desc' 		=> 	esc_html__( 'When creating your nav buttons, keep in mind of the available space that is available. Each nav button will be equally divided within the navbar.', 'bne-navbar' ),
			'id'   		=> 	'section_buttons',
			'type' 		=> 	'title',
		) );


		// Link Group
		$cmb_nav_btn_group = $cmb_options->add_field( array(
			'id'          	=> 	'nav_buttons',
			'type'        	=> 	'group',
			'options'     	=> 	array(
				'group_title'   => 	esc_html__( 'Nav Button {#}', 'bne-navbar' ),
				'add_button'    => 	esc_html__( 'Add Another Nav Button', 'bne-navbar' ),
				'remove_button' => 	esc_html__( 'Remove Nav Button', 'bne-navbar' ),
				'sortable'      => 	true,
				'closed'		=>	true,
			),
		) );

	
		// Title
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
		    'name'			=>	esc_html__( 'Title (optional)', 'bne-navbar' ),
		    'desc'			=>	esc_html__( "The title for this nav button. There's not alot of room, so keep this short - typically a single word.", 'bne-navbar' ),
			'id'			=>	'title',
		    'type'			=> 	'text',
		) );


		// Vector Icon
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
		    'name'			=>	esc_html__( 'Vector Icon', 'bne-navbar' ),
		    'desc'			=>	__( 'Enter the icon name (icon names are fa-diamond, fa-anchor etc) from a collection of 600+ FontAwesome v4 icons. Available icons can be viewed <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_blank">here</a>. Leave empty to use an image icon below instead. If both icon choices are empty, no icon will be used.', 'bne-navbar' ),
			'id'			=>	'icon',
		    'type'			=> 	'text',
		) );


		// Image Icon
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
		    'name'			=>	esc_html__( 'Image Icon', 'bne-navbar' ),
		    'desc'			=>	esc_html__( 'Use a custom image for the icon instead of a vector icon above. Leave empty to use a vector icon instead. If both icon choices are empty, no icon will be used.', 'bne-navbar' ),
			'id'			=>	'image',
		    'type'			=> 	'file',
			'options' 		=>	array(
				'url'      				=> 	false,
				'add_upload_file_text' 	=>  esc_html__( 'Select Image', 'bne-navbar' ),
			),
		) );

		// Link Type
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
		    'name'			=>	esc_html__( 'Behavior', 'bne-navbar' ),
		    'desc'			=>	esc_html__( 'What should happen when this nav button is clicked?', 'bne-navbar' ),
			'id'			=>	'link_type',
		    'type'			=> 	'select',
		    'options'			=>	array(
			    'page'				=>	esc_html__( 'Opens another page', 'bne-navbar' ),
			    'custom_menu'		=>	esc_html__( 'Opens a custom menu panel', 'bne-navbar' ),
		    ),
		    'classes'		=>	'link_type_controller',
		) );


		// Link URL
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
		    'name'			=>	esc_html__( 'Destination URL', 'bne-navbar' ),
		    'desc'			=>	esc_html__( 'The URL where this button should link to.', 'bne-navbar' ),
			'id'			=>	'link',
		    'type'			=> 	'text',
		    'classes'		=>	'link_type_page_only',
		    'attributes'	=>	array(
			    'placeholder'	=>	'http://domain.com/page/'
		    )
		) );


		// Link Target
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
		    'name'			=>	esc_html__( 'Target', 'bne-navbar' ),
		    'desc'			=>	esc_html__( 'Open the link in a new window?', 'bne-navbar' ),
			'id'			=>	'link_target',
		    'type'			=> 	'checkbox',
		    'classes'		=>	'link_type_page_only',
		) );


		// Custom Menu
		$get_menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
		$menu_items = array();
		foreach( $get_menus as $menu ) {
			$menu_items[$menu->term_id] = $menu->name;
		}
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
		    'name'			=>	esc_html__( 'Custom Menu', 'bne-navbar' ),
		    'desc'			=>	esc_html__( 'Open an available custom menu (Appearance > Menus) from this button. A custom menu must be created first before it can be selected here.', 'bne-navbar' ),
			'id'			=>	'custom_menu',
		    'type'			=> 	'select',
		    'show_option_none'	=> 	true,
		    'options'		=>	$menu_items,
		    'classes'		=>	'hide link_type_menu_only',
		) );


		// Heading
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
		    'name'			=>	esc_html__( 'Heading', 'bne-navbar' ),
		    'desc'			=>	esc_html__( 'Display a heading for the custom menu.', 'bne-navbar' ),
			'id'			=>	'custom_menu_heading',
		    'type'			=> 	'text',
		    'classes'		=>	'hide link_type_menu_only',
		) );

		// Menu Background Color
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
			'name'			=> 	esc_html__( 'Background Color', 'bne-navbar' ),
			'desc'			=> 	esc_html__( 'Set the color of the menu background.', 'bne-navbar' ),
			'id'			=> 	'custom_menu_bg_color',
			'type'			=> 	'colorpicker',
			'default'		=> 	'#222222',
		    'classes'		=>	'hide link_type_menu_only',
			'options' 		=> 	array(
				'alpha' 		=> 	true, 
			)
		) );

		// Menu Link Color
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
			'name'			=> 	esc_html__( 'Link Color', 'bne-navbar' ),
			'desc'			=> 	esc_html__( 'Depending on the background color used above, you may want to use a dark or light color for the menu links.', 'bne-navbar' ),
			'id'			=> 	'custom_menu_link_color',
			'type'			=> 	'select',
			'default'		=> 	'light',
			'options'		=>	array(
				'light'			=>	esc_html__( 'Light color text', 'bne-navbar' ),
				'dark'			=>	esc_html__( 'Dark color text', 'bne-navbar' )
			),
		    'classes'		=>	'hide link_type_menu_only',
		) );

		// Class
		$cmb_options->add_group_field( $cmb_nav_btn_group, array(
		    'name'			=>	esc_html__( 'Classes', 'bne-navbar' ),
		    'desc'			=>	esc_html__( 'Add a custom class to this nav button for further CSS customizations.', 'bne-navbar' ),
			'id'			=>	'class',
		    'type'			=> 	'text',
		) );

	}
	

	/*
	 * 	Before Metabox Hook
	 *	Adds content before the CMB2 metabox
	 *
	 * 	@since 	v1.2
	 *
	*/
	function before_metabox( $cmb_id, $object_id ) {
		echo '<div class="bne-cmb-options-wrapper">';
	}
	

	/*
	 * 	After Metabox Hook
	 *	Adds content after the CMB2 metabox
	 *
	 * 	@since 	v1.2
	 *
	*/
	function after_metabox( $cmb_id, $object_id ) {
		?>
			<div class="bne-cmb-options-footer">v<?php echo BNE_NAVBAR_VERSION; ?> (<a href="http://updates.bnecreative.com/changelogs/?product=navbar" target="_blank">changelog</a>) Created by <a href="https://www.bnecreative.com" target="_blank">BNE Creative</a>.</div>
		</div><!-- .bne-cmb-options-wrapper (end) -->
		<?php
	}


} // End Class
$bne_navbar_register_options = new bne_navbar_register_options();