/*
 * 	BNE Navbar JS (frontend)
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) 2017, Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 *	@updated	May 10, 2019
 *
*/

jQuery(document).ready(function($) {

	// Scroll Class
	$(window).on('scroll', function() {
		var fromTop = $(this).scrollTop();
		var fromBottom = $(document).height() - $(this).height();
		
		if( fromTop > fromBottom - 75 )  {
			$('#bne-navbar.hide_on_footer').removeClass('active');
		} else {
			$('#bne-navbar.hide_on_footer').addClass('active');
		}
	});

	// Close Navbar
	function closeNavBar() {
		$('html').removeClass('bne-lock');
		$('.bne-navbar-link').removeClass('active');		
		$('.bne-navbar-menu.active').removeClass('active');		
		$('.bne-navbar-overlay').removeClass('active');
	}

	// Open Navbar
	function openNavBar(btn, id) {
		btn.addClass('active');
		$('html').addClass('bne-lock');
		$('.bne-navbar-overlay').addClass('active');
		$('#bne-navbar-menu-' + id).toggleClass('active');
	}

	// Open a menu from the Navbar
	$('.bne-navbar-link.has-custom-menu').on( 'click', function(e) {
		btn = $(this);
		id = $(this).data('navlink');
		
		if( btn.hasClass('active') ) {
			closeNavBar();
		} else {
			closeNavBar();
			openNavBar(btn, id);
		}

		e.preventDefault();
	});

	// Close Menu button
	$('.bne-navbar-menu-close, .bne-navbar-overlay').on( 'click', function(e) {
		closeNavBar();
		e.preventDefault();
	});
	
	// Close Menu from Hash or other element
	$('.bne-close-navbar, .bne-close-navbar a').on( 'click', function(e) {
		closeNavBar();
	});

});  //End