/*
 *	BNE Navbar Admin JS
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) 2017-2018, Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 *	@updated	Oct 12, 2018
*/
jQuery(document).ready(function($) { 
	
	// BNE Framework Styles
	$('.bne-cmb-options-wrapper .cmb2_select').wrap('<div class="bne-fancy-select"></div>');
	
	
	/*
	 * 	Link Type Conditional Logic
	 *
	 *	Loop through each group and check the value of
	 *	the link type and show/hide controller groups
	 *	on page load.
	 *
	*/
	$('.link_type_controller select').each(function() {
		
		// If Linking to Page - Show Page Options
		if( this.value === 'page' ) {
			$(this).closest('.cmb-repeatable-grouping').find('.link_type_page_only').show();
			$(this).closest('.cmb-repeatable-grouping').find('.link_type_menu_only').hide();
		
		// Else Show Custom Menu Options
		} else {
			$(this).closest('.cmb-repeatable-grouping').find('.link_type_page_only').hide();
			$(this).closest('.cmb-repeatable-grouping').find('.link_type_menu_only').show();
		} 

	}); // End link_type_controller loop


	/*
	 * 	Listen for link type changes.
	 *
	 *	For each group, listen for user change of link type and
	 *	sow/hide controller groups.
	 *
	*/
	$('body').on('change', '.link_type_controller select', function() {
	    
		// If Linking to Page - Show Page Options
		if( this.value === 'page' ) {
			$(this).closest('.cmb-repeatable-grouping').find('.link_type_page_only').show();
			$(this).closest('.cmb-repeatable-grouping').find('.link_type_menu_only').hide();
		
		// Else Show Custom Menu Options
		} else {
			$(this).closest('.cmb-repeatable-grouping').find('.link_type_page_only').hide();
			$(this).closest('.cmb-repeatable-grouping').find('.link_type_menu_only').show();
		} 
	}); // End link_type_controller loop
		
	
	/*
	 * 	Group Titles
	 *
	 *	@url https://github.com/WebDevStudios/CMB2-Snippet-Library/blob/master/javascript/dynamically-change-group-field-title-from-subfield.php
	*/
	var $box = $( document.getElementById( 'bne_navbar_option_metabox' ) );
	var replaceTitles = function() {
		$box.find( '.cmb-group-title' ).each( function() {
			var $this = $( this );
			var txt = $this.next().find( '[id$="title"]' ).val();
			var rowindex;
			if ( ! txt ) {
				//txt = $box.find( '[data-grouptitle]' ).data( 'grouptitle' );
				//if ( txt ) {
				//	rowindex = $this.parents( '[data-iterator]' ).data( 'iterator' );
				//	txt = txt.replace( '{#}', ( rowindex + 1 ) );
				//}
			}
			if ( txt ) {
				$this.text( txt );
			}
		});
	};
	var replaceOnKeyUp = function( evt ) {
		var $this = $( evt.target );
		var id = 'title';
		if ( evt.target.id.indexOf(id, evt.target.id.length - id.length) !== -1 ) {
			console.log( 'val', $this.val() );
			$this.parents( '.cmb-row.cmb-repeatable-grouping' ).find( '.cmb-group-title' ).text( $this.val() );
		}
	};
	$box
		.on( 'cmb2_add_row cmb2_shift_rows_complete', function( evt ) {
			replaceTitles();
		})
		.on( 'keyup', replaceOnKeyUp );
	replaceTitles();

});